---
generated_at: 2026-02-03 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：90-Derived Fields

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/index/mapper/DerivedFieldMapper.java`
- E-02: `server/src/main/java/org/opensearch/index/mapper/DerivedField.java`
- E-03: `server/src/main/java/org/opensearch/index/mapper/DerivedFieldType.java`
- E-04: `server/src/main/java/org/opensearch/index/mapper/DerivedFieldSupportedTypes.java`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` 90行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CONTENT_TYPE="derived" | E-01 (34行目) | ○ |
| C-02 | type, script, properties, prefilter_field, format, ignoreMalformedの6パラメータ | E-01 (48-75, 150-152行目) | ○ |
| C-03 | parseCreateFieldでUnsupportedOperationException | E-01 (235-239行目) | ○ |
| C-04 | 名前に"."含む場合はObjectDerivedFieldType | E-01 (175-179行目) | ○ |
| C-05 | DerivedField @PublicApi(since="2.14.0") | E-02 (28行目) | ○ |
| C-06 | DerivedFieldの7フィールド | E-02 (31-36行目) | ○ |
| C-07 | V_2_15_0以降でproperties等追加 | E-02 (48行目) | ○ |
| C-08 | termQueryでDerivedFieldQuery生成 | E-03 (160-173行目) | ○ |
| C-09 | prefilter_fieldでBooleanQuery(FILTER)結合 | E-03 (170-172, 488-493行目) | ○ |
| C-10 | prefilter_fieldはtext型のみ | E-03 (106-115行目) | ○ |
| C-11 | _source無効でIllegalArgumentException | E-03 (500-506行目) | ○ |
| C-12 | existsQueryでUnsupportedOperationException | E-03 (479-481行目) | ○ |
| C-13 | spanPrefixQueryでIllegalArgumentException | E-03 (446-450行目) | ○ |
| C-14 | isAggregatable()がtrue | E-03 (484-486行目) | ○ |
| C-15 | IP型でBytesRefにフォーマット | E-03 (547-551行目) | ○ |
| C-16 | getAggregationScript実装 | E-03 (512-539行目) | ○ |
| C-17 | DerivedFieldSupportedTypesにBOOLEAN, DATE等の型定義 | E-04 (45-80行目) | ○ |
| C-18 | propertiesの値はString型のみ | E-01 (77-108行目, parseProperties) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] DerivedFieldQueryの内部実装（MemoryIndex使用）が正確に記述されているか確認
- [ ] サポートされる全型（boolean, date, geo_point, ip, keyword, long, double, float, text, object）が漏れなく記載されているか確認
- [ ] prefilter最適化の動作が正確か確認
