---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：91-Star-Treeマッパー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の具体的数値**：根拠不足
  2. **Star-Tree構築モードの将来計画**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/index/mapper/StarTreeMapper.java` （全620行）
- E-02: `server/src/main/java/org/opensearch/index/compositeindex/datacube/startree/StarTreeField.java`
- E-03: `server/src/main/java/org/opensearch/index/compositeindex/datacube/startree/StarTreeFieldConfiguration.java`
- E-04: `server/src/main/java/org/opensearch/index/compositeindex/datacube/startree/StarTreeIndexSettings.java`
- E-05: `server/src/main/java/org/opensearch/index/compositeindex/datacube/MetricStat.java`
- E-06: `server/src/main/java/org/opensearch/index/compositeindex/datacube/Dimension.java`
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Star-Treeマッパーは実験的API(@ExperimentalApi)である | E-01 46行目 | ○ |
| C-02 | コンテンツタイプは"star_tree"である | E-01 48行目 | ○ |
| C-03 | max_leaf_docsは1以上でなければならない | E-01 79-83行目 | ○ |
| C-04 | ordered_dimensionsは必須パラメータ | E-01 134-138行目 | ○ |
| C-05 | ディメンション数は最低2つ必要 | E-01 160-164行目 | ○ |
| C-06 | ディメンションの重複は禁止 | E-01 168-177行目 | ○ |
| C-07 | メトリクスセクションは必須 | E-01 284-288行目 | ○ |
| C-08 | メトリクスフィールドは数値型でなければならない | E-01 318-322行目 | ○ |
| C-09 | _doc_countメトリクスは自動追加される | E-01 367-368行目 | ○ |
| C-10 | 派生メトリクスは基底メトリクスが揃えば自動追加される | E-01 414-423行目 | ○ |
| C-11 | skip_star_node_creation_for_dimensionsはordered_dimensionsに含まれなければならない | E-01 97-106行目 | ○ |
| C-12 | ビルドモードはOFF_HEAPのみ | E-01 89行目 | ○ |
| C-13 | parseCreateField()はMapperParsingExceptionをスロー | E-01 562-569行目 | ○ |
| C-14 | deriveSource()は空実装 | E-01 619行目 | ○ |
| C-15 | canDeriveSource()は空実装 | E-01 613行目 | ○ |
| C-16 | TypeParser.parse()がエントリーポイント | E-01 518-538行目 | ○ |
| C-17 | date_dimensionはdate型フィールドでなければならない | E-01 219-223行目 | ○ |
| C-18 | ディメンションの型チェックはisBuilderAllowedForDimension()で行われる | E-01 430-432行目 | ○ |
| C-19 | メトリクスの型チェックはisBuilderAllowedForMetric()で行われる | E-01 434-436行目 | ○ |
| C-20 | 基底メトリクス数に上限がある | E-01 349-366行目, E-04 | ○ |
| C-21 | ディメンション数に上限がある | E-01 142-159行目, E-04 | ○ |
| C-22 | メトリクスの重複は禁止 | E-01 302-311行目 | ○ |
| C-23 | findMapperBuilderByNameはネストされたフィールドをサポート | E-01 438-487行目 | ○ |
| C-24 | パフォーマンスへの影響は大規模分析ワークロードで大幅短縮 | **根拠なし** | △ |
| C-25 | Star-Tree構築モードの将来拡張可能性 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンスの具体的な改善数値はソースコード内に記載がなく、ベンチマーク結果等の外部文書を参照する必要がある
  - 候補：OpenSearch公式ドキュメント / ベンチマークレポート / GitHub Issue
- OFF_HEAP以外のビルドモードの将来計画についてはロードマップ等の参照が必要
  - 候補：GitHub Roadmap / RFC文書 / Design Document

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードの構造と行番号は正確に記載されている
- 0: 低リスク - ビジネスルールはすべてソースコードのバリデーションロジックに基づいている
- 1: 中リスク - 実験的API（@ExperimentalApi）であるため、将来のバージョンで変更される可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] StarTreeMapper.javaの行番号が最新コードと一致しているか確認
- [ ] StarTreeIndexSettingsのデフォルト値（MAX_DIMENSIONS_DEFAULT, MAX_BASE_METRICS_DEFAULT）の具体的な数値を確認
- [ ] 実験的APIの安定化計画を確認
