---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：95-リモートクラスタ接続

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **RemoteClusterConnectionの内部接続リトライ仕様**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/transport/RemoteClusterService.java`
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RemoteClusterAwareを継承しCloseableを実装 | E-01 80行目 | ○ |
| C-02 | 初期接続タイムアウトデフォルト30秒 | E-01 87-91行目 | ○ |
| C-03 | REMOTE_NODE_ATTRIBUTEでゲートウェイノード選択 | E-01 99-101行目 | ○ |
| C-04 | ENABLE_REMOTE_CLUSTERSは非推奨(Deprecated) | E-01 109-114行目 | ○ |
| C-05 | skip_unavailableはAffix設定でクラスタ別に指定 | E-01 116-120行目 | ○ |
| C-06 | ping_scheduleはAffix設定で動的変更可能 | E-01 122-132行目 | ○ |
| C-07 | compressはAffix設定で動的変更可能 | E-01 134-144行目 | ○ |
| C-08 | enabled判定はDiscoveryNode.isRemoteClusterClient | E-01 157行目 | ○ |
| C-09 | remoteClustersConcurrentMapで管理 | E-01 153行目 | ○ |
| C-10 | groupIndices()でインデックスをクラスタ別に振り分け | E-01 172-190行目 | ○ |
| C-11 | getConnection()でリモートノード接続を取得 | E-01 212-214行目 | ○ |
| C-12 | ensureConnected()で接続を確保 | E-01 220-222行目 | ○ |
| C-13 | isSkipUnavailable()でスキップ判定 | E-01 227-229行目 | ○ |
| C-14 | NoSuchRemoteClusterExceptionをスロー | E-01 243行目 | ○ |
| C-15 | ロールなしノードでIllegalArgumentExceptionをスロー | E-01 237-239行目 | ○ |
| C-16 | 画面No.98がリモートクラスタ情報に対応 | E-02 | ○ |
| C-17 | RemoteClusterConnectionが内部リトライを管理 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- RemoteClusterConnection.javaの内部リトライメカニズムの詳細は未確認
  - 候補：`server/src/main/java/org/opensearch/transport/RemoteClusterConnection.java`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設定項目と主要メソッドは正確に記載
- 0: 低リスク - エラーケースはソースコードに基づいて正確

## 6) レビュアーチェックリスト（最小）
- [ ] RemoteClusterConnection.javaの接続リトライ仕様を確認
- [ ] listenForUpdates()の動的設定変更処理を確認
- [ ] RemoteClusterAware.groupClusterIndices()のインデックスパース仕様を確認
