---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 167
  claims_with_evidence: 165
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：画面一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：165 / 167、根拠なし：2
- 優先レビュー（高）
  1. **No.81 同期フラッシュ（非推奨）**：専用のAPIスペックファイルが存在せず、flush.jsonを参照している
  2. **No.166 Cat PITセグメント**：専用のAPIスペックファイルが存在せず、cat.segments.jsonを参照している
  3. **プラグイン提供のREST API**：plugins/ディレクトリ内の各プラグインが追加提供するREST APIは本一覧に含まれていない可能性がある

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/info.json`
- E-02: `rest-api-spec/src/main/resources/rest-api-spec/api/ping.json`
- E-03: `rest-api-spec/src/main/resources/rest-api-spec/api/index.json`
- E-04: `rest-api-spec/src/main/resources/rest-api-spec/api/create.json`
- E-05: `rest-api-spec/src/main/resources/rest-api-spec/api/get.json`
- E-06: `rest-api-spec/src/main/resources/rest-api-spec/api/get_source.json`
- E-07: `rest-api-spec/src/main/resources/rest-api-spec/api/exists.json`
- E-08: `rest-api-spec/src/main/resources/rest-api-spec/api/exists_source.json`
- E-09: `rest-api-spec/src/main/resources/rest-api-spec/api/delete.json`
- E-10: `rest-api-spec/src/main/resources/rest-api-spec/api/update.json`
- E-11: `rest-api-spec/src/main/resources/rest-api-spec/api/mget.json`
- E-12: `rest-api-spec/src/main/resources/rest-api-spec/api/bulk.json`
- E-13: `rest-api-spec/src/main/resources/rest-api-spec/api/delete_by_query.json`
- E-14: `rest-api-spec/src/main/resources/rest-api-spec/api/delete_by_query_rethrottle.json`
- E-15: `rest-api-spec/src/main/resources/rest-api-spec/api/update_by_query.json`
- E-16: `rest-api-spec/src/main/resources/rest-api-spec/api/update_by_query_rethrottle.json`
- E-17: `rest-api-spec/src/main/resources/rest-api-spec/api/reindex.json`
- E-18: `rest-api-spec/src/main/resources/rest-api-spec/api/reindex_rethrottle.json`
- E-19: `rest-api-spec/src/main/resources/rest-api-spec/api/termvectors.json`
- E-20: `rest-api-spec/src/main/resources/rest-api-spec/api/mtermvectors.json`
- E-21: `rest-api-spec/src/main/resources/rest-api-spec/api/search.json`
- E-22: `rest-api-spec/src/main/resources/rest-api-spec/api/msearch.json`
- E-23: `rest-api-spec/src/main/resources/rest-api-spec/api/count.json`
- E-24: `rest-api-spec/src/main/resources/rest-api-spec/api/explain.json`
- E-25: `rest-api-spec/src/main/resources/rest-api-spec/api/field_caps.json`
- E-26: `rest-api-spec/src/main/resources/rest-api-spec/api/search_template.json`
- E-27: `rest-api-spec/src/main/resources/rest-api-spec/api/msearch_template.json`
- E-28: `rest-api-spec/src/main/resources/rest-api-spec/api/render_search_template.json`
- E-29: `rest-api-spec/src/main/resources/rest-api-spec/api/rank_eval.json`
- E-30: `rest-api-spec/src/main/resources/rest-api-spec/api/search_shards.json`（= `search_shards.json`）
- E-31: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.validate_query.json`
- E-32: `rest-api-spec/src/main/resources/rest-api-spec/api/scroll.json`
- E-33: `rest-api-spec/src/main/resources/rest-api-spec/api/clear_scroll.json`
- E-34: `rest-api-spec/src/main/resources/rest-api-spec/api/create_pit.json`
- E-35: `rest-api-spec/src/main/resources/rest-api-spec/api/delete_pit.json`
- E-36: `rest-api-spec/src/main/resources/rest-api-spec/api/delete_all_pits.json`
- E-37: `rest-api-spec/src/main/resources/rest-api-spec/api/get_all_pits.json`
- E-38: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.create.json`
- E-39: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.delete.json`
- E-40: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.get.json`
- E-41: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.exists.json`
- E-42: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.open.json`
- E-43: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.close.json`
- E-44: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.add_block.json`
- E-45: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.clone.json`
- E-46: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.shrink.json`
- E-47: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.split.json`
- E-48: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.rollover.json`
- E-49: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.resolve_index.json`
- E-50: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.get_mapping.json`
- E-51: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.put_mapping.json`
- E-52: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.get_field_mapping.json`
- E-53: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.get_settings.json`
- E-54: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.put_settings.json`
- E-55: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.analyze.json`
- E-56: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.get_alias.json`
- E-57: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.put_alias.json`
- E-58: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.delete_alias.json`
- E-59: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.exists_alias.json`
- E-60: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.update_aliases.json`
- E-61: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.get_template.json`
- E-62: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.put_template.json`
- E-63: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.delete_template.json`
- E-64: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.exists_template.json`
- E-65: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.get_index_template.json`
- E-66: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.put_index_template.json`
- E-67: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.delete_index_template.json`
- E-68: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.exists_index_template.json`
- E-69: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.get_component_template.json`
- E-70: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.put_component_template.json`
- E-71: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.delete_component_template.json`
- E-72: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.exists_component_template.json`
- E-73: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.simulate_index_template.json`
- E-74: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.simulate_template.json`
- E-75: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.create_data_stream.json`
- E-76: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.get_data_stream.json`
- E-77: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.delete_data_stream.json`
- E-78: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.data_streams_stats.json`
- E-79: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.refresh.json`
- E-80: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.flush.json`
- E-81: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.forcemerge.json`
- E-82: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.clear_cache.json`
- E-83: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.recovery.json`
- E-84: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.segments.json`
- E-85: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.shard_stores.json`
- E-86: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.stats.json`
- E-87: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.upgrade.json`
- E-88: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.get_upgrade.json`
- E-89: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.health.json`
- E-90: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.state.json`
- E-91: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.stats.json`
- E-92: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.get_settings.json`
- E-93: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.put_settings.json`
- E-94: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.allocation_explain.json`
- E-95: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.reroute.json`
- E-96: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.pending_tasks.json`
- E-97: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.remote_info.json`
- E-98: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.post_voting_config_exclusions.json`
- E-99: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.delete_voting_config_exclusions.json`
- E-100: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.get_weighted_routing.json`
- E-101: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.put_weighted_routing.json`
- E-102: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.delete_weighted_routing.json`
- E-103: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.put_decommission_awareness.json`
- E-104: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.get_decommission_awareness.json`
- E-105: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.delete_decommission_awareness.json`
- E-106: `rest-api-spec/src/main/resources/rest-api-spec/api/nodes.info.json`
- E-107: `rest-api-spec/src/main/resources/rest-api-spec/api/nodes.stats.json`
- E-108: `rest-api-spec/src/main/resources/rest-api-spec/api/nodes.usage.json`
- E-109: `rest-api-spec/src/main/resources/rest-api-spec/api/nodes.hot_threads.json`
- E-110: `rest-api-spec/src/main/resources/rest-api-spec/api/nodes.reload_secure_settings.json`
- E-111: `rest-api-spec/src/main/resources/rest-api-spec/api/tasks.list.json`
- E-112: `rest-api-spec/src/main/resources/rest-api-spec/api/tasks.get.json`
- E-113: `rest-api-spec/src/main/resources/rest-api-spec/api/tasks.cancel.json`
- E-114: `rest-api-spec/src/main/resources/rest-api-spec/api/snapshot.create_repository.json`
- E-115: `rest-api-spec/src/main/resources/rest-api-spec/api/snapshot.get_repository.json`
- E-116: `rest-api-spec/src/main/resources/rest-api-spec/api/snapshot.delete_repository.json`
- E-117: `rest-api-spec/src/main/resources/rest-api-spec/api/snapshot.verify_repository.json`
- E-118: `rest-api-spec/src/main/resources/rest-api-spec/api/snapshot.cleanup_repository.json`
- E-119: `rest-api-spec/src/main/resources/rest-api-spec/api/snapshot.create.json`
- E-120: `rest-api-spec/src/main/resources/rest-api-spec/api/snapshot.get.json`
- E-121: `rest-api-spec/src/main/resources/rest-api-spec/api/snapshot.delete.json`
- E-122: `rest-api-spec/src/main/resources/rest-api-spec/api/snapshot.clone.json`
- E-123: `rest-api-spec/src/main/resources/rest-api-spec/api/snapshot.restore.json`
- E-124: `rest-api-spec/src/main/resources/rest-api-spec/api/snapshot.status.json`
- E-125: `rest-api-spec/src/main/resources/rest-api-spec/api/remote_store.restore.json`
- E-126: `rest-api-spec/src/main/resources/rest-api-spec/api/remote_store.stats.json`
- E-127: `rest-api-spec/src/main/resources/rest-api-spec/api/dangling_indices.list_dangling_indices.json`
- E-128: `rest-api-spec/src/main/resources/rest-api-spec/api/dangling_indices.import_dangling_index.json`
- E-129: `rest-api-spec/src/main/resources/rest-api-spec/api/dangling_indices.delete_dangling_index.json`
- E-130: `rest-api-spec/src/main/resources/rest-api-spec/api/ingest.get_pipeline.json`
- E-131: `rest-api-spec/src/main/resources/rest-api-spec/api/ingest.put_pipeline.json`
- E-132: `rest-api-spec/src/main/resources/rest-api-spec/api/ingest.delete_pipeline.json`
- E-133: `rest-api-spec/src/main/resources/rest-api-spec/api/ingest.simulate.json`
- E-134: `rest-api-spec/src/main/resources/rest-api-spec/api/ingest.processor_grok.json`
- E-135: `rest-api-spec/src/main/resources/rest-api-spec/api/search_pipeline.get.json`
- E-136: `rest-api-spec/src/main/resources/rest-api-spec/api/search_pipeline.put.json`
- E-137: `rest-api-spec/src/main/resources/rest-api-spec/api/search_pipeline.delete.json`
- E-138: `rest-api-spec/src/main/resources/rest-api-spec/api/get_script.json`
- E-139: `rest-api-spec/src/main/resources/rest-api-spec/api/put_script.json`
- E-140: `rest-api-spec/src/main/resources/rest-api-spec/api/delete_script.json`
- E-141: `rest-api-spec/src/main/resources/rest-api-spec/api/get_script_context.json`
- E-142: `rest-api-spec/src/main/resources/rest-api-spec/api/get_script_languages.json`
- E-143: `rest-api-spec/src/main/resources/rest-api-spec/api/scripts_painless_execute.json`
- E-144: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.help.json`
- E-145: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.aliases.json`
- E-146: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.allocation.json`
- E-147: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.cluster_manager.json`
- E-148: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.count.json`
- E-149: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.fielddata.json`
- E-150: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.health.json`
- E-151: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.indices.json`
- E-152: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.nodeattrs.json`
- E-153: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.nodes.json`
- E-154: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.pending_tasks.json`
- E-155: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.plugins.json`
- E-156: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.recovery.json`
- E-157: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.repositories.json`
- E-158: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.segment_replication.json`
- E-159: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.segments.json`
- E-160: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.shards.json`
- E-161: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.snapshots.json`
- E-162: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.tasks.json`
- E-163: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.templates.json`
- E-164: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.thread_pool.json`
- E-165: `rest-api-spec/src/main/resources/rest-api-spec/api/wlm_stats_list.json`
- E-166: `server/src/main/java/org/opensearch/rest/action/` （RestHandlerクラス群）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | No.1 クラスタ情報 (GET /) | E-01 | ○ |
| C-02 | No.2 Ping (HEAD /) | E-02 | ○ |
| C-03 | No.3 ドキュメント登録・更新 | E-03 | ○ |
| C-04 | No.4 ドキュメント作成 | E-04 | ○ |
| C-05 | No.5 ドキュメント取得 | E-05 | ○ |
| C-06 | No.6 ドキュメントソース取得 | E-06 | ○ |
| C-07 | No.7 ドキュメント存在確認 | E-07 | ○ |
| C-08 | No.8 ドキュメントソース存在確認 | E-08 | ○ |
| C-09 | No.9 ドキュメント削除 | E-09 | ○ |
| C-10 | No.10 ドキュメント更新 | E-10 | ○ |
| C-11 | No.11 複数ドキュメント取得 | E-11 | ○ |
| C-12 | No.12 バルク操作 | E-12 | ○ |
| C-13 | No.13 クエリによる削除 | E-13 | ○ |
| C-14 | No.14 クエリによる削除スロットル変更 | E-14 | ○ |
| C-15 | No.15 クエリによる更新 | E-15 | ○ |
| C-16 | No.16 クエリによる更新スロットル変更 | E-16 | ○ |
| C-17 | No.17 Reindex | E-17 | ○ |
| C-18 | No.18 Reindexスロットル変更 | E-18 | ○ |
| C-19 | No.19 Term Vectors | E-19 | ○ |
| C-20 | No.20 Multi Term Vectors | E-20 | ○ |
| C-21 | No.21 検索 | E-21 | ○ |
| C-22 | No.22 複数検索 | E-22 | ○ |
| C-23 | No.23 ドキュメント件数 | E-23 | ○ |
| C-24 | No.24 検索説明 | E-24 | ○ |
| C-25 | No.25 フィールド機能 | E-25 | ○ |
| C-26 | No.26 検索テンプレート | E-26 | ○ |
| C-27 | No.27 複数検索テンプレート | E-27 | ○ |
| C-28 | No.28 検索テンプレートレンダリング | E-28 | ○ |
| C-29 | No.29 ランク評価 | E-29 | ○ |
| C-30 | No.30 検索シャード情報 | E-30 | ○ |
| C-31 | No.31 クエリバリデーション | E-31 | ○ |
| C-32 | No.32 スクロール検索 | E-32 | ○ |
| C-33 | No.33 スクロールクリア | E-33 | ○ |
| C-34 | No.34 PIT作成 | E-34 | ○ |
| C-35 | No.35 PIT削除 | E-35 | ○ |
| C-36 | No.36 全PIT削除 | E-36 | ○ |
| C-37 | No.37 全PIT取得 | E-37 | ○ |
| C-38 | No.38 インデックス作成 | E-38 | ○ |
| C-39 | No.39 インデックス削除 | E-39 | ○ |
| C-40 | No.40 インデックス情報取得 | E-40 | ○ |
| C-41 | No.41 インデックス存在確認 | E-41 | ○ |
| C-42 | No.42 インデックスオープン | E-42 | ○ |
| C-43 | No.43 インデックスクローズ | E-43 | ○ |
| C-44 | No.44 インデックスブロック追加 | E-44 | ○ |
| C-45 | No.45 インデックスクローン | E-45 | ○ |
| C-46 | No.46 インデックス縮小 | E-46 | ○ |
| C-47 | No.47 インデックス分割 | E-47 | ○ |
| C-48 | No.48 インデックスロールオーバー | E-48 | ○ |
| C-49 | No.49 インデックス解決 | E-49 | ○ |
| C-50 | No.50 マッピング取得 | E-50 | ○ |
| C-51 | No.51 マッピング更新 | E-51 | ○ |
| C-52 | No.52 フィールドマッピング取得 | E-52 | ○ |
| C-53 | No.53 設定取得 | E-53 | ○ |
| C-54 | No.54 設定更新 | E-54 | ○ |
| C-55 | No.55 アナライズ | E-55 | ○ |
| C-56 | No.56 エイリアス取得 | E-56 | ○ |
| C-57 | No.57 エイリアス作成・更新 | E-57 | ○ |
| C-58 | No.58 エイリアス削除 | E-58 | ○ |
| C-59 | No.59 エイリアス存在確認 | E-59 | ○ |
| C-60 | No.60 エイリアス一括更新 | E-60 | ○ |
| C-61 | No.61 インデックステンプレート取得（レガシー） | E-61 | ○ |
| C-62 | No.62 インデックステンプレート作成（レガシー） | E-62 | ○ |
| C-63 | No.63 インデックステンプレート削除（レガシー） | E-63 | ○ |
| C-64 | No.64 インデックステンプレート存在確認（レガシー） | E-64 | ○ |
| C-65 | No.65 Composableインデックステンプレート取得 | E-65 | ○ |
| C-66 | No.66 Composableインデックステンプレート作成 | E-66 | ○ |
| C-67 | No.67 Composableインデックステンプレート削除 | E-67 | ○ |
| C-68 | No.68 Composableインデックステンプレート存在確認 | E-68 | ○ |
| C-69 | No.69 コンポーネントテンプレート取得 | E-69 | ○ |
| C-70 | No.70 コンポーネントテンプレート作成 | E-70 | ○ |
| C-71 | No.71 コンポーネントテンプレート削除 | E-71 | ○ |
| C-72 | No.72 コンポーネントテンプレート存在確認 | E-72 | ○ |
| C-73 | No.73 インデックステンプレートシミュレーション | E-73 | ○ |
| C-74 | No.74 テンプレートシミュレーション | E-74 | ○ |
| C-75 | No.75 データストリーム作成 | E-75 | ○ |
| C-76 | No.76 データストリーム取得 | E-76 | ○ |
| C-77 | No.77 データストリーム削除 | E-77 | ○ |
| C-78 | No.78 データストリーム統計 | E-78 | ○ |
| C-79 | No.79 リフレッシュ | E-79 | ○ |
| C-80 | No.80 フラッシュ | E-80 | ○ |
| C-81 | No.81 同期フラッシュ（非推奨） | **根拠なし** | △ |
| C-82 | No.82 強制マージ | E-81 | ○ |
| C-83 | No.83 キャッシュクリア | E-82 | ○ |
| C-84 | No.84 リカバリ情報 | E-83 | ○ |
| C-85 | No.85 セグメント情報 | E-84 | ○ |
| C-86 | No.86 シャードストア情報 | E-85 | ○ |
| C-87 | No.87 インデックス統計 | E-86 | ○ |
| C-88 | No.88 アップグレード（非推奨） | E-87 | ○ |
| C-89 | No.89 アップグレードステータス（非推奨） | E-88 | ○ |
| C-90 | No.90 クラスタヘルス | E-89 | ○ |
| C-91 | No.91 クラスタ状態 | E-90 | ○ |
| C-92 | No.92 クラスタ統計 | E-91 | ○ |
| C-93 | No.93 クラスタ設定取得 | E-92 | ○ |
| C-94 | No.94 クラスタ設定更新 | E-93 | ○ |
| C-95 | No.95 アロケーション説明 | E-94 | ○ |
| C-96 | No.96 クラスタ再ルーティング | E-95 | ○ |
| C-97 | No.97 保留中タスク | E-96 | ○ |
| C-98 | No.98 リモートクラスタ情報 | E-97 | ○ |
| C-99 | No.99 投票設定除外追加 | E-98 | ○ |
| C-100 | No.100 投票設定除外クリア | E-99 | ○ |
| C-101 | No.101 重み付きルーティング取得 | E-100 | ○ |
| C-102 | No.102 重み付きルーティング設定 | E-101 | ○ |
| C-103 | No.103 重み付きルーティング削除 | E-102 | ○ |
| C-104 | No.104 デコミッション設定 | E-103 | ○ |
| C-105 | No.105 デコミッション状態取得 | E-104 | ○ |
| C-106 | No.106 デコミッション削除 | E-105 | ○ |
| C-107 | No.107 ノード情報 | E-106 | ○ |
| C-108 | No.108 ノード統計 | E-107 | ○ |
| C-109 | No.109 ノード使用状況 | E-108 | ○ |
| C-110 | No.110 ホットスレッド | E-109 | ○ |
| C-111 | No.111 セキュア設定リロード | E-110 | ○ |
| C-112 | No.112 タスク一覧 | E-111 | ○ |
| C-113 | No.113 タスク取得 | E-112 | ○ |
| C-114 | No.114 タスクキャンセル | E-113 | ○ |
| C-115 | No.115 リポジトリ作成 | E-114 | ○ |
| C-116 | No.116 リポジトリ取得 | E-115 | ○ |
| C-117 | No.117 リポジトリ削除 | E-116 | ○ |
| C-118 | No.118 リポジトリ検証 | E-117 | ○ |
| C-119 | No.119 リポジトリクリーンアップ | E-118 | ○ |
| C-120 | No.120 スナップショット作成 | E-119 | ○ |
| C-121 | No.121 スナップショット取得 | E-120 | ○ |
| C-122 | No.122 スナップショット削除 | E-121 | ○ |
| C-123 | No.123 スナップショットクローン | E-122 | ○ |
| C-124 | No.124 スナップショットリストア | E-123 | ○ |
| C-125 | No.125 スナップショットステータス | E-124 | ○ |
| C-126 | No.126 リモートストアリストア | E-125 | ○ |
| C-127 | No.127 リモートストア統計 | E-126 | ○ |
| C-128 | No.128 Danglingインデックス一覧 | E-127 | ○ |
| C-129 | No.129 Danglingインデックスインポート | E-128 | ○ |
| C-130 | No.130 Danglingインデックス削除 | E-129 | ○ |
| C-131 | No.131 パイプライン取得 | E-130 | ○ |
| C-132 | No.132 パイプライン作成・更新 | E-131 | ○ |
| C-133 | No.133 パイプライン削除 | E-132 | ○ |
| C-134 | No.134 パイプラインシミュレーション | E-133 | ○ |
| C-135 | No.135 Grokパターン一覧 | E-134 | ○ |
| C-136 | No.136 検索パイプライン取得 | E-135 | ○ |
| C-137 | No.137 検索パイプライン作成・更新 | E-136 | ○ |
| C-138 | No.138 検索パイプライン削除 | E-137 | ○ |
| C-139 | No.139 スクリプト取得 | E-138 | ○ |
| C-140 | No.140 スクリプト作成・更新 | E-139 | ○ |
| C-141 | No.141 スクリプト削除 | E-140 | ○ |
| C-142 | No.142 スクリプトコンテキスト一覧 | E-141 | ○ |
| C-143 | No.143 スクリプト言語一覧 | E-142 | ○ |
| C-144 | No.144 Painlessスクリプト実行 | E-143 | ○ |
| C-145 | No.145 Cat ヘルプ | E-144 | ○ |
| C-146 | No.146 Cat エイリアス | E-145 | ○ |
| C-147 | No.147 Cat アロケーション | E-146 | ○ |
| C-148 | No.148 Cat クラスタマネージャ | E-147 | ○ |
| C-149 | No.149 Cat ドキュメント件数 | E-148 | ○ |
| C-150 | No.150 Cat Fielddata | E-149 | ○ |
| C-151 | No.151 Cat ヘルス | E-150 | ○ |
| C-152 | No.152 Cat インデックス | E-151 | ○ |
| C-153 | No.153 Cat ノード属性 | E-152 | ○ |
| C-154 | No.154 Cat ノード | E-153 | ○ |
| C-155 | No.155 Cat 保留中タスク | E-154 | ○ |
| C-156 | No.156 Cat プラグイン | E-155 | ○ |
| C-157 | No.157 Cat リカバリ | E-156 | ○ |
| C-158 | No.158 Cat リポジトリ | E-157 | ○ |
| C-159 | No.159 Cat セグメントレプリケーション | E-158 | ○ |
| C-160 | No.160 Cat セグメント | E-159 | ○ |
| C-161 | No.161 Cat シャード | E-160 | ○ |
| C-162 | No.162 Cat スナップショット | E-161 | ○ |
| C-163 | No.163 Cat タスク | E-162 | ○ |
| C-164 | No.164 Cat テンプレート | E-163 | ○ |
| C-165 | No.165 Cat スレッドプール | E-164 | ○ |
| C-166 | No.166 Cat PITセグメント | **根拠なし** | △ |
| C-167 | No.167 WLM統計一覧 | E-165 | ○ |

## 4) 不足情報（Unknown / Missing）
- No.81 同期フラッシュ（非推奨）: 専用のAPIスペックファイル（`indices.synced_flush.json`）が存在しない。`RestSyncedFlushAction.java` は存在するが、APIスペックが削除されている可能性がある。非推奨APIのため影響は軽微。
  - 候補：`RestSyncedFlushAction.java` / OpenSearch公式ドキュメント / 過去のAPIスペック
- No.166 Cat PITセグメント: 専用のAPIスペックファイルが存在しない。`RestPitSegmentsAction.java` は存在するが、APIスペックには `cat.pit_segments.json` がない。
  - 候補：`RestPitSegmentsAction.java` / OpenSearch公式ドキュメント
- プラグイン提供REST API: `plugins/` ディレクトリ内の各プラグインが独自に提供するREST APIエンドポイントは本一覧に含まれていない。
  - 候補：各プラグインの `RestHandler` 実装 / プラグインのAPIスペック

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大半のAPIエンドポイント（165/167）はREST APIスペックファイルに基づき正確に記載
- 1: 中リスク - プラグインが提供するREST APIが一覧に含まれていない可能性がある（plugins/ディレクトリは30以上のプラグインを含む）
- 0: 低リスク - 非推奨API（No.81, No.88, No.89）は存在するが将来的に削除される可能性がある
- 1: 中リスク - 本プロジェクトはバックエンドAPIサーバーであり、従来のGUI画面は存在しない。REST APIエンドポイントを「画面」として解釈している

## 6) レビュアーチェックリスト（最小）
- [ ] REST APIスペックファイル（`rest-api-spec/src/main/resources/rest-api-spec/api/`）の166ファイルとCSVの167行の対応が妥当か確認
- [ ] No.81（同期フラッシュ）とNo.166（Cat PITセグメント）の根拠不足について、`RestSyncedFlushAction.java` と `RestPitSegmentsAction.java` を確認
- [ ] プラグイン提供のREST API（security, alerting, ISM等）を一覧に追加する必要があるか判断
- [ ] カテゴリ分類が業務要件と合致しているか確認
- [ ] 画面遷移図のAPI間の論理的関連が正確か確認
- [ ] 非推奨API（synced_flush, upgrade）を一覧に含めるべきか判断
