# 画面遷移図（REST APIエンドポイント関連図）

本プロジェクト（OpenSearch）はバックエンドの検索エンジンであり、従来のGUI画面は存在しません。
以下では、REST APIエンドポイント間の論理的な関連・遷移をカテゴリ別にmermaid形式で示します。

## 全体構成図

```mermaid
graph TB
    Client[クライアント]

    subgraph BasicInfo["基本情報"]
        INFO[クラスタ情報<br/>GET /]
        PING[Ping<br/>HEAD /]
    end

    subgraph DocumentOps["ドキュメント操作"]
        DOC_INDEX[ドキュメント登録・更新<br/>PUT/POST /{index}/_doc/{id}]
        DOC_CREATE[ドキュメント作成<br/>PUT /{index}/_create/{id}]
        DOC_GET[ドキュメント取得<br/>GET /{index}/_doc/{id}]
        DOC_DELETE[ドキュメント削除<br/>DELETE /{index}/_doc/{id}]
        DOC_UPDATE[ドキュメント更新<br/>POST /{index}/_update/{id}]
        DOC_MGET[複数ドキュメント取得<br/>GET /_mget]
        DOC_BULK[バルク操作<br/>POST /_bulk]
        DOC_DBQ[クエリによる削除<br/>POST /{index}/_delete_by_query]
        DOC_UBQ[クエリによる更新<br/>POST /{index}/_update_by_query]
        DOC_REINDEX[Reindex<br/>POST /_reindex]
    end

    subgraph Search["検索"]
        SEARCH[検索<br/>GET/POST /{index}/_search]
        MSEARCH[複数検索<br/>GET/POST /_msearch]
        COUNT[ドキュメント件数<br/>GET/POST /{index}/_count]
        EXPLAIN[検索説明<br/>GET/POST /{index}/_explain/{id}]
        SCROLL[スクロール検索<br/>GET/POST /_search/scroll]
        CLEAR_SCROLL[スクロールクリア<br/>DELETE /_search/scroll]
        PIT_CREATE[PIT作成<br/>POST /{index}/_search/point_in_time]
        PIT_DELETE[PIT削除<br/>DELETE /_search/point_in_time]
        SEARCH_TEMPLATE[検索テンプレート<br/>GET/POST /_search/template]
    end

    subgraph IndexMgmt["インデックス管理"]
        IDX_CREATE[インデックス作成<br/>PUT /{index}]
        IDX_DELETE[インデックス削除<br/>DELETE /{index}]
        IDX_GET[インデックス情報取得<br/>GET /{index}]
        IDX_OPEN[インデックスオープン<br/>POST /{index}/_open]
        IDX_CLOSE[インデックスクローズ<br/>POST /{index}/_close]
        IDX_CLONE[インデックスクローン<br/>PUT /{index}/_clone/{target}]
        IDX_SHRINK[インデックス縮小<br/>PUT /{index}/_shrink/{target}]
        IDX_SPLIT[インデックス分割<br/>PUT /{index}/_split/{target}]
        IDX_ROLLOVER[インデックスロールオーバー<br/>POST /{alias}/_rollover]
    end

    subgraph IndexSettings["インデックス設定・マッピング"]
        MAP_GET[マッピング取得<br/>GET /{index}/_mapping]
        MAP_PUT[マッピング更新<br/>PUT /{index}/_mapping]
        SET_GET[設定取得<br/>GET /{index}/_settings]
        SET_PUT[設定更新<br/>PUT /{index}/_settings]
        ANALYZE[アナライズ<br/>GET/POST /{index}/_analyze]
    end

    subgraph AliasMgmt["エイリアス管理"]
        ALIAS_GET[エイリアス取得<br/>GET /{index}/_alias/{name}]
        ALIAS_PUT[エイリアス作成・更新<br/>PUT /{index}/_alias/{name}]
        ALIAS_DELETE[エイリアス削除<br/>DELETE /{index}/_alias/{name}]
        ALIAS_UPDATE[エイリアス一括更新<br/>POST /_aliases]
    end

    subgraph IndexOps["インデックス運用"]
        REFRESH[リフレッシュ<br/>POST /{index}/_refresh]
        FLUSH[フラッシュ<br/>POST /{index}/_flush]
        FORCEMERGE[強制マージ<br/>POST /{index}/_forcemerge]
        CACHE_CLEAR[キャッシュクリア<br/>POST /{index}/_cache/clear]
        RECOVERY[リカバリ情報<br/>GET /{index}/_recovery]
        IDX_STATS[インデックス統計<br/>GET /{index}/_stats]
    end

    subgraph ClusterMgmt["クラスタ管理"]
        CLUSTER_HEALTH[クラスタヘルス<br/>GET /_cluster/health]
        CLUSTER_STATE[クラスタ状態<br/>GET /_cluster/state]
        CLUSTER_STATS[クラスタ統計<br/>GET /_cluster/stats]
        CLUSTER_SETTINGS_GET[クラスタ設定取得<br/>GET /_cluster/settings]
        CLUSTER_SETTINGS_PUT[クラスタ設定更新<br/>PUT /_cluster/settings]
        CLUSTER_REROUTE[クラスタ再ルーティング<br/>POST /_cluster/reroute]
        ALLOC_EXPLAIN[アロケーション説明<br/>GET /_cluster/allocation/explain]
    end

    subgraph NodeMgmt["ノード管理"]
        NODES_INFO[ノード情報<br/>GET /_nodes]
        NODES_STATS[ノード統計<br/>GET /_nodes/stats]
        NODES_HOT[ホットスレッド<br/>GET /_nodes/hot_threads]
    end

    subgraph TaskMgmt["タスク管理"]
        TASKS_LIST[タスク一覧<br/>GET /_tasks]
        TASKS_GET[タスク取得<br/>GET /_tasks/{task_id}]
        TASKS_CANCEL[タスクキャンセル<br/>POST /_tasks/{task_id}/_cancel]
    end

    subgraph SnapshotMgmt["スナップショット管理"]
        SNAP_REPO_CREATE[リポジトリ作成<br/>PUT /_snapshot/{repository}]
        SNAP_REPO_GET[リポジトリ取得<br/>GET /_snapshot/{repository}]
        SNAP_CREATE[スナップショット作成<br/>PUT /_snapshot/{repo}/{snap}]
        SNAP_GET[スナップショット取得<br/>GET /_snapshot/{repo}/{snap}]
        SNAP_RESTORE[スナップショットリストア<br/>POST /_snapshot/{repo}/{snap}/_restore]
        SNAP_DELETE[スナップショット削除<br/>DELETE /_snapshot/{repo}/{snap}]
    end

    subgraph IngestMgmt["Ingestパイプライン管理"]
        PIPE_GET[パイプライン取得<br/>GET /_ingest/pipeline/{id}]
        PIPE_PUT[パイプライン作成・更新<br/>PUT /_ingest/pipeline/{id}]
        PIPE_DELETE[パイプライン削除<br/>DELETE /_ingest/pipeline/{id}]
        PIPE_SIM[パイプラインシミュレーション<br/>POST /_ingest/pipeline/_simulate]
    end

    subgraph TemplateMgmt["テンプレート管理"]
        TPL_GET[インデックステンプレート取得<br/>GET /_index_template/{name}]
        TPL_PUT[インデックステンプレート作成<br/>PUT /_index_template/{name}]
        TPL_DELETE[インデックステンプレート削除<br/>DELETE /_index_template/{name}]
        COMP_TPL_GET[コンポーネントテンプレート取得<br/>GET /_component_template/{name}]
        COMP_TPL_PUT[コンポーネントテンプレート作成<br/>PUT /_component_template/{name}]
    end

    subgraph ScriptMgmt["スクリプト管理"]
        SCRIPT_GET[スクリプト取得<br/>GET /_scripts/{id}]
        SCRIPT_PUT[スクリプト作成・更新<br/>PUT /_scripts/{id}]
        SCRIPT_DELETE[スクリプト削除<br/>DELETE /_scripts/{id}]
    end

    subgraph SearchPipeline["検索パイプライン管理"]
        SP_GET[検索パイプライン取得<br/>GET /_search/pipeline/{id}]
        SP_PUT[検索パイプライン作成・更新<br/>PUT /_search/pipeline/{id}]
        SP_DELETE[検索パイプライン削除<br/>DELETE /_search/pipeline/{id}]
    end

    %% クライアントからのアクセス
    Client --> BasicInfo
    Client --> DocumentOps
    Client --> Search
    Client --> IndexMgmt
    Client --> IndexSettings
    Client --> AliasMgmt
    Client --> IndexOps
    Client --> ClusterMgmt
    Client --> NodeMgmt
    Client --> TaskMgmt
    Client --> SnapshotMgmt
    Client --> IngestMgmt
    Client --> TemplateMgmt
    Client --> ScriptMgmt
    Client --> SearchPipeline

    %% ドキュメント操作の関連
    DOC_INDEX --> SEARCH
    DOC_CREATE --> SEARCH
    DOC_BULK --> SEARCH
    DOC_REINDEX --> DOC_INDEX

    %% 検索の関連
    SEARCH --> SCROLL
    SCROLL --> CLEAR_SCROLL
    SEARCH --> PIT_CREATE
    PIT_CREATE --> PIT_DELETE
    SEARCH_TEMPLATE --> SEARCH
    MSEARCH --> SEARCH

    %% インデックス管理の関連
    IDX_CREATE --> DOC_INDEX
    IDX_CREATE --> MAP_PUT
    IDX_CREATE --> SET_PUT
    IDX_CREATE --> ALIAS_PUT
    IDX_CLONE --> IDX_CREATE
    IDX_SHRINK --> IDX_CREATE
    IDX_SPLIT --> IDX_CREATE
    IDX_ROLLOVER --> IDX_CREATE

    %% インデックス運用の関連
    DOC_INDEX --> REFRESH
    REFRESH --> SEARCH
    IDX_CREATE --> IDX_STATS

    %% スナップショットの関連
    SNAP_REPO_CREATE --> SNAP_CREATE
    SNAP_CREATE --> SNAP_RESTORE
    SNAP_RESTORE --> IDX_CREATE

    %% Ingestパイプラインの関連
    PIPE_PUT --> DOC_INDEX
    PIPE_SIM --> PIPE_PUT

    %% テンプレートの関連
    TPL_PUT --> IDX_CREATE
    COMP_TPL_PUT --> TPL_PUT

    %% タスク管理の関連
    DOC_DBQ --> TASKS_GET
    DOC_UBQ --> TASKS_GET
    DOC_REINDEX --> TASKS_GET
    TASKS_LIST --> TASKS_GET
    TASKS_GET --> TASKS_CANCEL

    %% 検索パイプラインの関連
    SP_PUT --> SEARCH

    %% スクリプトの関連
    SCRIPT_PUT --> SEARCH
    SCRIPT_PUT --> DOC_UPDATE
```

## カテゴリ別遷移詳細

### 1. ドキュメントライフサイクル

```mermaid
graph LR
    CREATE[ドキュメント作成] --> GET[ドキュメント取得]
    CREATE --> UPDATE[ドキュメント更新]
    UPDATE --> GET
    GET --> DELETE[ドキュメント削除]
    CREATE --> SEARCH[検索]
    UPDATE --> SEARCH
    BULK[バルク操作] --> CREATE
    BULK --> UPDATE
    BULK --> DELETE
    REINDEX[Reindex] --> CREATE
    DBQ[クエリによる削除] --> DELETE
    UBQ[クエリによる更新] --> UPDATE
```

### 2. 検索フロー

```mermaid
graph LR
    SEARCH[検索] --> SCROLL[スクロール検索]
    SCROLL --> SCROLL_NEXT[次ページ取得]
    SCROLL_NEXT --> CLEAR[スクロールクリア]
    SEARCH --> PIT[PIT作成]
    PIT --> SEARCH_PIT[PIT付き検索]
    SEARCH_PIT --> PIT_DEL[PIT削除]
    TEMPLATE[検索テンプレート作成] --> SEARCH_TPL[テンプレート検索]
    PIPELINE[検索パイプライン作成] --> SEARCH
    EXPLAIN[検索説明] --> SEARCH
    COUNT[件数取得] --> SEARCH
```

### 3. インデックスライフサイクル

```mermaid
graph LR
    TPL[テンプレート作成] --> CREATE[インデックス作成]
    CREATE --> OPEN[オープン]
    OPEN --> CLOSE[クローズ]
    CLOSE --> OPEN
    CREATE --> CLONE[クローン]
    CREATE --> SHRINK[縮小]
    CREATE --> SPLIT[分割]
    CLONE --> CREATE2[新インデックス作成]
    SHRINK --> CREATE2
    SPLIT --> CREATE2
    CREATE --> ROLLOVER[ロールオーバー]
    ROLLOVER --> CREATE2
    CREATE --> DELETE[インデックス削除]
```

### 4. スナップショット・リストアフロー

```mermaid
graph LR
    REPO_CREATE[リポジトリ作成] --> REPO_VERIFY[リポジトリ検証]
    REPO_CREATE --> SNAP_CREATE[スナップショット作成]
    SNAP_CREATE --> SNAP_STATUS[ステータス確認]
    SNAP_CREATE --> SNAP_RESTORE[リストア]
    SNAP_CREATE --> SNAP_CLONE[クローン]
    SNAP_CREATE --> SNAP_DELETE[スナップショット削除]
    REPO_CREATE --> REPO_CLEANUP[リポジトリクリーンアップ]
    REPO_CREATE --> REPO_DELETE[リポジトリ削除]
```

### 5. クラスタ・ノード管理フロー

```mermaid
graph TB
    HEALTH[クラスタヘルス確認] --> STATE[クラスタ状態確認]
    HEALTH --> STATS[クラスタ統計確認]
    STATE --> REROUTE[シャード再ルーティング]
    STATE --> ALLOC[アロケーション説明]
    SETTINGS_GET[クラスタ設定取得] --> SETTINGS_PUT[クラスタ設定更新]
    NODES_INFO[ノード情報] --> NODES_STATS[ノード統計]
    NODES_INFO --> HOT_THREADS[ホットスレッド]
    TASKS_LIST[タスク一覧] --> TASKS_GET[タスク詳細]
    TASKS_GET --> TASKS_CANCEL[タスクキャンセル]
```

### 6. Ingestパイプラインフロー

```mermaid
graph LR
    GROK[Grokパターン確認] --> PIPE_CREATE[パイプライン作成]
    PIPE_CREATE --> PIPE_SIM[シミュレーション]
    PIPE_SIM --> PIPE_UPDATE[パイプライン更新]
    PIPE_CREATE --> DOC_INDEX[ドキュメント登録（パイプライン適用）]
    PIPE_CREATE --> PIPE_DELETE[パイプライン削除]
    PIPE_CREATE --> PIPE_GET[パイプライン取得]
```
