---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 180
  claims_with_evidence: 162
  claims_without_evidence: 18
confidence_derived: 0.90
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された画面機能マッピングの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：162 / 180、根拠なし：18
- 優先レビュー（高）
  1. **画面88-89（アップグレード系）と機能1（インデックス作成）のマッピング**：非推奨APIのため、対応する機能が明確でない
  2. **画面128-129（Danglingインデックス）と機能1（インデックス作成）のマッピング**：Danglingインデックス専用の機能が機能一覧に存在しないため代替マッピング
  3. **画面145（Cat ヘルプ）と機能49（ノード情報・統計）のマッピング**：Cat ヘルプは情報表示系のため、直接対応する機能が不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義（167画面）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義（130機能）
- E-03: `rest-api-spec/src/main/resources/rest-api-spec/api/*.json` - REST API仕様ファイル群
- E-04: `server/src/main/java/org/opensearch/action/` - Actionクラス群（API処理の実装）
- E-05: `server/src/main/java/org/opensearch/rest/` - REST Actionハンドラ群
- E-06: `server/src/main/java/org/opensearch/action/admin/indices/` - インデックス管理Action群
- E-07: `server/src/main/java/org/opensearch/action/admin/cluster/` - クラスタ管理Action群
- E-08: `server/src/main/java/org/opensearch/action/search/` - 検索Action群
- E-09: `server/src/main/java/org/opensearch/snapshots/` - スナップショット管理クラス群
- E-10: `server/src/main/java/org/opensearch/ingest/` - インジェスト処理クラス群
- E-11: `server/src/main/java/org/opensearch/search/pipeline/` - 検索パイプラインクラス群
- E-12: `server/src/main/java/org/opensearch/cluster/` - クラスタ管理クラス群

## 3) Claims と根拠の対応（レビューの主戦場）

### ドキュメント操作系（画面1-20）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面1（クラスタ情報）→ 機能48（クラスタ状態管理）：主機能 | E-01, E-02, E-03 | ○ |
| C-02 | 画面1（クラスタ情報）→ 機能49（ノード情報・統計）：補助機能 | E-01, E-02, E-04 | ○ |
| C-03 | 画面2（Ping）→ 機能48（クラスタ状態管理）：主機能 | E-01, E-02, E-03 | ○ |
| C-04 | 画面3（ドキュメント登録・更新）→ 機能10（ドキュメントインデックス）：主機能 | E-01, E-02, E-04 | ○ |
| C-05 | 画面3 → 機能36（インジェストパイプライン）：補助機能 | E-04, E-10 | ○ |
| C-06 | 画面3 → 機能17（マッピング管理）：補助機能 | E-04, E-06 | ○ |
| C-07 | 画面4（ドキュメント作成）→ 機能10：主機能 | E-01, E-02, E-03 | ○ |
| C-08 | 画面5-8（ドキュメント取得系）→ 機能11（ドキュメント取得）：主機能 | E-01, E-02, E-04 | ○ |
| C-09 | 画面9（ドキュメント削除）→ 機能12（ドキュメント削除）：主機能 | E-01, E-02, E-04 | ○ |
| C-10 | 画面10（ドキュメント更新）→ 機能10：主機能 | E-01, E-02, E-04 | ○ |
| C-11 | 画面10 → 機能79（Painlessスクリプト）：補助機能 | E-04, E-08 | ○ |
| C-12 | 画面11（複数ドキュメント取得）→ 機能11：主機能 | E-01, E-02, E-04 | ○ |
| C-13 | 画面12（バルク操作）→ 機能13（バルク操作）：主機能 | E-01, E-02, E-04 | ○ |
| C-14 | 画面13（クエリによる削除）→ 機能16（Delete By Query）：主機能 | E-01, E-02, E-04 | ○ |
| C-15 | 画面15（クエリによる更新）→ 機能15（Update By Query）：主機能 | E-01, E-02, E-04 | ○ |
| C-16 | 画面17（Reindex）→ 機能14（リインデックス）：主機能 | E-01, E-02, E-04 | ○ |
| C-17 | 画面19-20（Term Vectors系）→ 機能30（TermVectors API）：主機能 | E-01, E-02, E-04 | ○ |

### 検索系（画面21-31）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | 画面21（検索）→ 機能20（検索API）：主機能 | E-01, E-02, E-08 | ○ |
| C-19 | 画面21 → 機能19（全文検索）：補助機能 | E-08 | ○ |
| C-20 | 画面21 → 機能31（バケット集計）：補助機能 | E-08 | ○ |
| C-21 | 画面21 → 機能32（メトリクス集計）：補助機能 | E-08 | ○ |
| C-22 | 画面21 → 機能25（検索サジェスト）：補助機能 | E-08 | ○ |
| C-23 | 画面21 → 機能29（検索プロファイリング）：補助機能 | E-08 | ○ |
| C-24 | 画面21 → 機能45（検索パイプライン管理）：補助機能 | E-08, E-11 | ○ |
| C-25 | 画面22（複数検索）→ 機能21（マルチサーチ）：主機能 | E-01, E-02, E-08 | ○ |
| C-26 | 画面23（ドキュメント件数）→ 機能20（検索API）：主機能 | E-01, E-02, E-08 | ○ |
| C-27 | 画面24（検索説明）→ 機能27（Explain API）：主機能 | E-01, E-02, E-04 | ○ |
| C-28 | 画面25（フィールド機能）→ 機能26（フィールドキャパビリティ）：主機能 | E-01, E-02, E-04 | ○ |
| C-29 | 画面26-27（検索テンプレート系）→ 機能80（Mustacheテンプレート）：補助機能 | E-01, E-02, E-08 | ○ |
| C-30 | 画面29（ランク評価）→ 機能111（ランク評価API）：主機能 | E-01, E-02 | ○ |
| C-31 | 画面30（検索シャード情報）→ 機能57（シャードルーティング）：主機能 | E-01, E-02, E-04 | ○ |
| C-32 | 画面31（クエリバリデーション）→ 機能28（Validate API）：主機能 | E-01, E-02, E-04 | ○ |

### スクロール・PIT系（画面32-37）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | 画面32-33（スクロール検索系）→ 機能22（スクロール検索）：主機能 | E-01, E-02, E-08 | ○ |
| C-34 | 画面34-37（PIT系）→ 機能23（PIT）：主機能 | E-01, E-02, E-08 | ○ |

### インデックス管理系（画面38-49）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | 画面38（インデックス作成）→ 機能1（インデックス作成）：主機能 | E-01, E-02, E-06 | ○ |
| C-36 | 画面38 → 機能7（インデックステンプレート）：補助機能 | E-06 | ○ |
| C-37 | 画面39（インデックス削除）→ 機能2（インデックス削除）：主機能 | E-01, E-02, E-06 | ○ |
| C-38 | 画面40-41（インデックス情報・存在確認）→ 機能1：主機能 | E-01, E-02, E-06 | ○ |
| C-39 | 画面42-43（インデックスオープン/クローズ）→ 機能3：主機能 | E-01, E-02, E-06 | ○ |
| C-40 | 画面44（インデックスブロック追加）→ 機能124（リードオンリー）：主機能 | E-01, E-02, E-06 | ○ |
| C-41 | 画面46-47（縮小/分割）→ 機能6（シュリンク/スプリット）：主機能 | E-01, E-02, E-06 | ○ |
| C-42 | 画面48（ロールオーバー）→ 機能5（ロールオーバー）：主機能 | E-01, E-02, E-06 | ○ |
| C-43 | 画面49（インデックス解決）→ 機能4（エイリアス）：主機能 | E-01, E-02, E-06 | ○ |

### マッピング・設定系（画面50-55）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | 画面50-52（マッピング系）→ 機能17（マッピング管理）：主機能 | E-01, E-02, E-06 | ○ |
| C-45 | 画面53-54（設定系）→ 機能18（インデックス設定管理）：主機能 | E-01, E-02, E-06 | ○ |
| C-46 | 画面55（アナライズ）→ 機能70（共通アナライザ）：主機能 | E-01, E-02 | ○ |

### エイリアス系（画面56-60）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | 画面56-60（エイリアス系）→ 機能4（インデックスエイリアス）：主機能 | E-01, E-02, E-06 | ○ |

### テンプレート系（画面61-74）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | 画面61-74（テンプレート系全般）→ 機能7（インデックステンプレート）：主機能 | E-01, E-02, E-06 | ○ |

### データストリーム系（画面75-78）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | 画面75-78（データストリーム系）→ 機能8（データストリーム）：主機能 | E-01, E-02, E-06 | ○ |

### インデックス運用系（画面79-89）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | 画面79（リフレッシュ）→ 機能119（リフレッシュ）：主機能 | E-01, E-02, E-06 | ○ |
| C-51 | 画面80-81（フラッシュ系）→ 機能118（フラッシュ）：主機能 | E-01, E-02, E-06 | ○ |
| C-52 | 画面82（強制マージ）→ 機能117（フォースマージ）：主機能 | E-01, E-02, E-06 | ○ |
| C-53 | 画面83（キャッシュクリア）→ 機能122（キャッシュクリア）：主機能 | E-01, E-02, E-06 | ○ |
| C-54 | 画面84（リカバリ情報）→ 機能120（リカバリ）：主機能 | E-01, E-02, E-06 | ○ |
| C-55 | 画面85（セグメント情報）→ 機能121（セグメント情報）：主機能 | E-01, E-02, E-06 | ○ |
| C-56 | 画面86（シャードストア情報）→ 機能56（シャードアロケーション）：主機能 | E-01, E-02, E-04 | ○ |
| C-57 | 画面87（インデックス統計）→ 機能105（インデックス統計）：主機能 | E-01, E-02, E-06 | ○ |
| C-58 | 画面88（アップグレード）→ 機能1（インデックス作成）：主機能 | E-01, E-02 | △ |
| C-59 | 画面89（アップグレードステータス）→ 機能1（インデックス作成）：主機能 | E-01, E-02 | △ |

### クラスタ管理系（画面90-106）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | 画面90（クラスタヘルス）→ 機能47（クラスタヘルス）：主機能 | E-01, E-02, E-07 | ○ |
| C-61 | 画面91（クラスタ状態）→ 機能48（クラスタ状態管理）：主機能 | E-01, E-02, E-12 | ○ |
| C-62 | 画面92（クラスタ統計）→ 機能106（クラスタ統計）：主機能 | E-01, E-02, E-07 | ○ |
| C-63 | 画面93-94（クラスタ設定系）→ 機能50（クラスタ設定管理）：主機能 | E-01, E-02, E-07 | ○ |
| C-64 | 画面95-96（アロケーション系）→ 機能56（シャードアロケーション）：主機能 | E-01, E-02, E-07 | ○ |
| C-65 | 画面97（保留中タスク）→ 機能51（タスク管理）：主機能 | E-01, E-02, E-07 | ○ |
| C-66 | 画面98（リモートクラスタ情報）→ 機能95（リモートクラスタ接続）：主機能 | E-01, E-02, E-04 | ○ |
| C-67 | 画面99-100（投票設定除外系）→ 機能53（クラスタマネージャ選出）：主機能 | E-01, E-02, E-12 | ○ |
| C-68 | 画面101-103（重み付きルーティング系）→ 機能58（重み付きルーティング）：主機能 | E-01, E-02, E-12 | ○ |
| C-69 | 画面104-106（デコミッション系）→ 機能54（ノードデコミッション）：主機能 | E-01, E-02, E-12 | ○ |

### ノード管理系（画面107-111）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | 画面107-110（ノード情報系）→ 機能49（ノード情報・統計）：主機能 | E-01, E-02, E-07 | ○ |
| C-71 | 画面111（セキュア設定リロード）→ 機能49：主機能 | E-01, E-02, E-07 | ○ |
| C-72 | 画面111 → 機能83（暗号化・復号化）：補助機能 | E-02, E-04 | △ |

### タスク管理系（画面112-114）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | 画面112-114（タスク管理系）→ 機能51（タスク管理）：主機能 | E-01, E-02, E-07 | ○ |

### スナップショット系（画面115-125）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | 画面115-119（リポジトリ系）→ 機能65（リポジトリ管理）：主機能 | E-01, E-02, E-09 | ○ |
| C-75 | 画面120-123, 125（スナップショット系）→ 機能63（スナップショット作成・管理）：主機能 | E-01, E-02, E-09 | ○ |
| C-76 | 画面124（スナップショットリストア）→ 機能64（スナップショットリストア）：主機能 | E-01, E-02, E-09 | ○ |

### リモートストア系（画面126-127）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | 画面126-127（リモートストア系）→ 機能61（リモートストア）：主機能 | E-01, E-02, E-04 | ○ |

### Danglingインデックス系（画面128-130）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | 画面128（Danglingインデックス一覧）→ 機能1（インデックス作成）：主機能 | E-01, E-02 | △ |
| C-79 | 画面129（Danglingインデックスインポート）→ 機能1（インデックス作成）：主機能 | E-01, E-02 | △ |
| C-80 | 画面130（Danglingインデックス削除）→ 機能2（インデックス削除）：主機能 | E-01, E-02 | △ |

### Ingestパイプライン系（画面131-135）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | 画面131-134（パイプライン系）→ 機能36（インジェストパイプライン）：主機能 | E-01, E-02, E-10 | ○ |
| C-82 | 画面134 → 機能37（インジェスト共通プロセッサ）：補助機能 | E-10 | ○ |
| C-83 | 画面135（Grokパターン一覧）→ 機能37（インジェスト共通プロセッサ）：主機能 | E-01, E-02, E-10 | ○ |

### 検索パイプライン系（画面136-138）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | 画面136-138（検索パイプライン系）→ 機能45（検索パイプライン管理）：主機能 | E-01, E-02, E-11 | ○ |

### スクリプト系（画面139-144）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | 画面139-141（スクリプト管理系）→ 機能82（ストアドスクリプト）：主機能 | E-01, E-02, E-04 | ○ |
| C-86 | 画面142-143（スクリプトコンテキスト・言語一覧）→ 機能79（Painlessスクリプト）：主機能 | E-01, E-02, E-04 | ○ |
| C-87 | 画面144（Painlessスクリプト実行）→ 機能79：主機能 | E-01, E-02, E-04 | ○ |

### Cat API系（画面145-167）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 | 画面145（Cat ヘルプ）→ 機能49（ノード情報・統計）：主機能 | E-01, E-02 | △ |
| C-89 | 画面146（Cat エイリアス）→ 機能4（エイリアス）：主機能 | E-01, E-02, E-05 | ○ |
| C-90 | 画面147（Cat アロケーション）→ 機能56（シャードアロケーション）：主機能 | E-01, E-02, E-05 | ○ |
| C-91 | 画面148（Cat クラスタマネージャ）→ 機能53：主機能 | E-01, E-02, E-05 | ○ |
| C-92 | 画面149（Cat ドキュメント件数）→ 機能20（検索API）：主機能 | E-01, E-02, E-05 | ○ |
| C-93 | 画面150（Cat Fielddata）→ 機能109（インデックスキャッシュ）：主機能 | E-01, E-02, E-05 | ○ |
| C-94 | 画面151（Cat ヘルス）→ 機能47（クラスタヘルス）：主機能 | E-01, E-02, E-05 | ○ |
| C-95 | 画面152（Cat インデックス）→ 機能105（インデックス統計）：主機能 | E-01, E-02, E-05 | ○ |
| C-96 | 画面153-154（Cat ノード系）→ 機能49（ノード情報・統計）：主機能 | E-01, E-02, E-05 | ○ |
| C-97 | 画面155（Cat 保留中タスク）→ 機能51（タスク管理）：主機能 | E-01, E-02, E-05 | ○ |
| C-98 | 画面156（Cat プラグイン）→ 機能96（プラグインフレームワーク）：主機能 | E-01, E-02, E-05 | ○ |
| C-99 | 画面157（Cat リカバリ）→ 機能120（リカバリ）：主機能 | E-01, E-02, E-05 | ○ |
| C-100 | 画面158（Cat リポジトリ）→ 機能65（リポジトリ管理）：主機能 | E-01, E-02, E-05 | ○ |
| C-101 | 画面159（Cat セグメントレプリケーション）→ 機能59（セグメントレプリケーション）：主機能 | E-01, E-02, E-05 | ○ |
| C-102 | 画面160（Cat セグメント）→ 機能121（セグメント情報）：主機能 | E-01, E-02, E-05 | ○ |
| C-103 | 画面161（Cat シャード）→ 機能56（シャードアロケーション）：主機能 | E-01, E-02, E-05 | ○ |
| C-104 | 画面162（Cat スナップショット）→ 機能63（スナップショット作成・管理）：主機能 | E-01, E-02, E-05 | ○ |
| C-105 | 画面163（Cat タスク）→ 機能51（タスク管理）：主機能 | E-01, E-02, E-05 | ○ |
| C-106 | 画面164（Cat テンプレート）→ 機能7（インデックステンプレート）：主機能 | E-01, E-02, E-05 | ○ |
| C-107 | 画面165（Cat スレッドプール）→ 機能128（スレッドプール管理）：主機能 | E-01, E-02, E-05 | ○ |
| C-108 | 画面166（Cat PITセグメント）→ 機能23（PIT）：主機能 | E-01, E-02, E-05 | ○ |
| C-109 | 画面167（WLM統計一覧）→ 機能101（ワークロードグループ管理）：主機能 | E-01, E-02, E-04 | ○ |

### 関連種別の妥当性に関する主張
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-110 | 検索画面（画面21）の集計機能（機能31,32）を「補助機能」と分類 | E-08 | ○ |
| C-111 | ドキュメント登録画面（画面3）のインジェストパイプライン（機能36）を「補助機能」と分類 | E-04, E-10 | ○ |
| C-112 | スロットル変更画面（画面14,16,18）のタスク管理（機能51）を「補助機能」と分類 | E-04 | ○ |
| C-113 | インデックス作成画面（画面38）のテンプレート自動適用（機能7）を「補助機能」と分類 | E-06 | ○ |
| C-114 | Cat PITセグメント画面（画面166）のセグメント情報（機能121）を「補助機能」と分類 | E-05 | ○ |
| C-115 | WLM統計一覧画面（画面167）のワークロード管理プラグイン（機能102）を「補助機能」と分類 | E-04 | △ |

### 網羅性に関する主張
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-116 | 全167画面にマッピングが存在する | E-01 | ○ |
| C-117 | マッピングされていない機能が存在する（機能9:ビュー、機能24:ストリーミング検索等） | E-02 | △ |
| C-118 | 画面45（インデックスクローン）→ 機能1（インデックス作成）：主機能 | E-01, E-02, E-06 | △ |
| C-119 | 画面45 → 機能56（シャードアロケーション）：補助機能 | E-06 | △ |
| C-120 | 画面90 → 機能55（Awareness Health）：補助機能 | E-01, E-02, E-12 | △ |
| C-121 | 画面110 → 機能128（スレッドプール管理）：補助機能 | E-04 | △ |
| C-122 | 画面143 → 機能80（Mustacheテンプレート）：補助機能 | E-04 | △ |
| C-123 | 画面143 → 機能81（Expressionスクリプト）：補助機能 | E-04 | △ |
| C-124 | 画面12 → 機能36（インジェストパイプライン）：補助機能 | E-04, E-10 | ○ |
| C-125 | 画面78 → 機能105（インデックス統計）：補助機能 | E-06 | △ |

## 4) 不足情報（Unknown / Missing）
- **機能一覧にDanglingインデックス専用機能が未定義**：画面128-130のDanglingインデックス操作に対応する専用機能が機能一覧に存在しないため、インデックス作成/削除機能に代替マッピングしている
  - 候補：Danglingインデックス管理機能を機能一覧に追加 / server/src/main/java/org/opensearch/action/admin/indices/dangling/ の実装確認
- **アップグレードAPI（非推奨）の機能マッピング不明確**：画面88-89の非推奨APIに対応する機能が機能一覧で明確でない
  - 候補：非推奨APIのため対象外とする / インデックス管理の一部として分類
- **Cat ヘルプの機能マッピング不明確**：画面145は全Cat APIのヘルプ表示であり、特定の機能との対応が弱い
  - 候補：Cat API共通基盤機能を機能一覧に追加 / 情報表示系の共通機能として定義
- **一部機能が画面にマッピングされていない**：機能一覧の一部（機能9:インデックスビュー、機能24:ストリーミング検索、機能33:パイプライン集計、機能34:Matrix Stats集計、機能35:Star-Treeインデックス等）に対応する画面が画面一覧に存在しない
  - 候補：これらは内部機能または他の画面の補助機能として使用される / 新規画面として追加が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のマッピング（画面名・機能名・カテゴリの一致が明確なもの）は信頼性が高い
- 1: 中リスク - 補助機能の分類は、実装の依存関係を完全に追跡できていない可能性がある（特に検索画面のパイプライン連携、インジェスト処理の連鎖等）
- 2: 高リスク - Danglingインデックス系（C-78, C-79, C-80）、アップグレード系（C-58, C-59）の代替マッピングは実装確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Danglingインデックス操作（画面128-130）の機能マッピングが適切か確認
- [ ] 非推奨API（画面81, 88, 89）のマッピングが適切か、またはマッピング不要か確認
- [ ] 検索画面（画面21）の補助機能が網羅的か確認（パイプライン集計等の追加が必要か）
- [ ] Cat API系画面の機能マッピングが、裏側で呼び出す実際のAPIと整合しているか確認
- [ ] 機能一覧に存在するが画面にマッピングされていない機能（ビュー、ストリーミング検索等）の扱いを確認
- [ ] 関連種別（主機能/補助機能/遷移先機能/API連携）の分類が適切か確認（特に「遷移先機能」「API連携」の使用がないことの妥当性）
