# 画面設計書 1-クラスタ情報

## 概要

OpenSearchクラスタの基本情報を取得するREST APIエンドポイント（GET /）の設計書である。クラスタ名、バージョン、ノード名などの基本的なメタ情報をJSON形式で返却する。

### 本画面の処理概要

本APIは、OpenSearchクラスタに対してGETリクエストを送信することで、クラスタの基本的なメタデータ情報を取得する機能を提供する。

**業務上の目的・背景**：OpenSearchクラスタの運用において、クラスタが正常に稼働しているか、どのバージョンが動作しているか、クラスタ名やノード名は何かなどの基本情報を迅速に確認する必要がある。本APIはクラスタへの初回接続時の疎通確認や、バージョン互換性の確認、監視ツールからのヘルスチェックなどに利用される。

**画面へのアクセス方法**：HTTPクライアント（curl、Kibana Dev Tools、各種プログラミング言語のHTTPライブラリ等）からOpenSearchクラスタのルートURL（`GET /`）にリクエストを送信する。

**主要な操作・処理内容**：
1. クライアントからGETリクエストを受信する
2. MainActionを実行し、クラスタのメタデータ情報を収集する
3. ノード名、クラスタ名、クラスタUUID、バージョン情報、ビルド情報をJSON形式で返却する

**画面遷移**：本APIは独立したエンドポイントであり、他のAPIへの直接的な遷移はない。クライアントは本APIの応答を確認した後、任意のAPIエンドポイントにアクセスできる。

**権限による表示制御**：特別な権限制御は適用されない。クラスタに接続可能な全てのクライアントがアクセスできる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 48 | クラスタ状態管理 | 主機能 | クラスタの基本情報（バージョン、名前等）を返す主処理 |
| 49 | ノード情報・統計 | 補助機能 | クラスタ情報取得時のノード関連情報の補助取得 |

## 画面種別

情報取得（参照系API）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/` | クラスタの基本情報を取得する |

## 入出力項目

### リクエストパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|-----|------|------|
| pretty | boolean | いいえ | レスポンスを整形して表示する（デフォルト: true） |

### レスポンスボディ

| フィールド名 | 型 | 説明 |
|-------------|-----|------|
| name | string | ノード名 |
| cluster_name | string | クラスタ名 |
| cluster_uuid | string | クラスタUUID |
| version | object | バージョン情報オブジェクト |
| version.distribution | string | ディストリビューション名（"opensearch"） |
| version.number | string | バージョン番号 |
| version.build_type | string | ビルドタイプ |
| version.build_hash | string | ビルドハッシュ |
| version.build_date | string | ビルド日時 |
| version.build_snapshot | boolean | スナップショットビルドかどうか |
| version.lucene_version | string | Luceneバージョン |
| version.minimum_wire_compatibility_version | string | 最小ワイヤ互換バージョン |
| version.minimum_index_compatibility_version | string | 最小インデックス互換バージョン |
| tagline | string | タグライン（"The OpenSearch Project: https://opensearch.org/"） |

## 表示項目

レスポンスのJSON全フィールドが表示項目となる（上記レスポンスボディの項目を参照）。

## イベント仕様

### 1-GETリクエスト受信

1. クライアントからGET `/` リクエストを受信する
2. `RestMainAction.prepareRequest()` がリクエストを処理する
3. `MainAction.INSTANCE` を実行し、`MainRequest` を送信する
4. `MainResponse` を受け取り、`convertMainResponse()` でJSON形式に変換する
5. HTTPステータス200（OK）でレスポンスを返却する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| GET / | なし | SELECT（メモリ内データ参照） | クラスタメタデータを参照するのみで、永続化データの変更は行わない |

### テーブル別更新項目詳細

本APIはデータベース（インデックス）の更新を行わない。クラスタの内部状態（ClusterState）からメタデータを読み取るのみである。

## メッセージ仕様

| メッセージ種別 | HTTPステータス | 条件 | メッセージ内容 |
|--------------|--------------|------|-------------|
| 成功 | 200 OK | 正常にクラスタ情報を取得できた場合 | JSON形式のクラスタ情報 |

## 例外処理

| 例外 | HTTPステータス | 条件 | レスポンス |
|------|--------------|------|----------|
| 接続エラー | N/A | クラスタに接続できない場合 | 接続タイムアウトまたは接続拒否 |

## 備考

- 本APIはサーキットブレーカーをトリップさせない（`canTripCircuitBreaker()` が `false` を返す）。これにより、クラスタが高負荷状態でも基本情報の取得が可能である。
- HEADメソッドでのアクセスも同じハンドラ（RestMainAction）で処理される。HEADの場合はPing APIとして機能し、レスポンスボディは返却されない。
- デフォルトでpretty printが有効化されている。`?pretty=false` で無効化可能。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、レスポンスとして返却されるデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MainResponse.java | `server/src/main/java/org/opensearch/action/main/MainResponse.java` | レスポンスのフィールド（nodeName, version, clusterName, clusterUuid, build）とJSON変換ロジックを理解する |
| 1-2 | MainRequest.java | `server/src/main/java/org/opensearch/action/main/MainRequest.java` | リクエストオブジェクトの構造を確認する（パラメータなし） |

**読解のコツ**: MainResponseの `toXContent()` メソッドでJSON出力の構造がわかる。TAGLINEフィールドが定数として定義されている（62行目）。

#### Step 2: エントリーポイントを理解する

RESTリクエストを受け取る入口となるハンドラを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestMainAction.java | `server/src/main/java/org/opensearch/rest/action/RestMainAction.java` | ルーティング定義（63行目）、リクエスト処理の起点（72-78行目）、レスポンス変換（81-88行目）を確認する |

**主要処理フロー**:
1. **63行目**: `routes()` でGET `/` とHEAD `/` のルーティングを定義
2. **72行目**: `prepareRequest()` でMainActionの実行を準備
3. **73行目**: `client.execute(MainAction.INSTANCE, new MainRequest(), ...)` でMainActionを実行
4. **81-88行目**: `convertMainResponse()` でMainResponseをJSON形式に変換しHTTP 200で返却

#### Step 3: トランスポート層を理解する

MainActionの実行ロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MainAction.java | `server/src/main/java/org/opensearch/action/main/MainAction.java` | アクション定義を確認する |
| 3-2 | TransportMainAction.java | `server/src/main/java/org/opensearch/action/main/TransportMainAction.java` | クラスタ状態からメタデータを取得し、MainResponseを構築するロジックを確認する |

**主要処理フロー**:
- TransportMainActionの `doExecute()` メソッドで、ClusterServiceからクラスタ名・UUID、Nodeからノード名、Version/Buildからバージョン情報を取得してMainResponseを構築する

### プログラム呼び出し階層図

```
RestMainAction.prepareRequest()
    |
    +-- client.execute(MainAction.INSTANCE, MainRequest)
            |
            +-- TransportMainAction.doExecute()
                    |
                    +-- clusterService.getClusterName()
                    +-- clusterService.state().metadata().clusterUUID()
                    +-- MainResponse を構築
                            |
                            +-- RestMainAction.convertMainResponse()
                                    |
                                    +-- MainResponse.toXContent()
                                    +-- BytesRestResponse(OK, builder)
```

### データフロー図

```
[入力]               [処理]                    [出力]

GET /  ------->  RestMainAction           -------> HTTP 200
                    |                              JSON Response:
                    v                              {
              TransportMainAction                    "name": "...",
                    |                                "cluster_name": "...",
                    v                                "cluster_uuid": "...",
              ClusterService                         "version": {...},
              (メモリ内メタデータ)                      "tagline": "..."
                                                   }
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestMainAction.java | `server/src/main/java/org/opensearch/rest/action/RestMainAction.java` | ソース | RESTハンドラ（エントリーポイント） |
| MainAction.java | `server/src/main/java/org/opensearch/action/main/MainAction.java` | ソース | アクション定義 |
| MainRequest.java | `server/src/main/java/org/opensearch/action/main/MainRequest.java` | ソース | リクエストオブジェクト |
| MainResponse.java | `server/src/main/java/org/opensearch/action/main/MainResponse.java` | ソース | レスポンスオブジェクト |
| TransportMainAction.java | `server/src/main/java/org/opensearch/action/main/TransportMainAction.java` | ソース | トランスポートアクション実装 |
| info.json | `rest-api-spec/src/main/resources/rest-api-spec/api/info.json` | 設定 | REST API仕様定義 |
| RestMainActionTests.java | `server/src/test/java/org/opensearch/rest/action/RestMainActionTests.java` | テスト | ユニットテスト |
