# 画面設計書 100-投票設定除外クリア

## 概要

本ドキュメントは、OpenSearchのDelete Voting Config Exclusions API（`DELETE /_cluster/voting_config_exclusions`）の画面設計書である。クラスタ投票設定除外をクリアするためのREST APIエンドポイントについて、入出力仕様・処理フロー・例外処理を定義する。

### 本画面の処理概要

本APIは、投票設定除外追加（No.99）で追加された投票設定除外をクリアするエンドポイントである。除外リストに含まれるノードがクラスタから離脱した後に、クリーンアップ目的で使用される。

**業務上の目的・背景**：ノードの退役やメンテナンスが完了した後、不要になった投票設定除外を削除する必要がある。投票設定除外が残ったままだと、将来のクラスタ構成変更に影響を与える可能性がある。本APIにより、投票設定除外リストをクリアし、クラスタの投票設定を正常な状態に戻すことができる。

**画面へのアクセス方法**：HTTPクライアントから `DELETE /_cluster/voting_config_exclusions` にリクエストを送信する。

**主要な操作・処理内容**：
1. 全ての投票設定除外をクリア
2. 除外されたノードが全てクラスタから離脱するまで待機するか否かの制御（`wait_for_removal` パラメータ）

**画面遷移**：投票設定除外追加（No.99）で除外を追加した後、対象ノードの退役が完了してから本APIで除外をクリアする。クラスタ状態（No.91）で投票設定の状態を確認する。

**権限による表示制御**：クラスタレベルの管理権限が必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 53 | クラスタマネージャ選出 | 主機能 | クラスタ投票設定除外をクリアする処理 |

## 画面種別

削除（REST API リクエスト/レスポンス）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| DELETE | `/_cluster/voting_config_exclusions` | 投票設定除外をクリア |

## 入出力項目

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| wait_for_removal | boolean | いいえ | true | 全ての除外ノードがクラスタから離脱するまで待機するかを指定。falseの場合、ノードがまだクラスタに存在していても除外リストをクリアする |

## 表示項目

### レスポンスフィールド

| フィールド | 型 | 説明 |
|-----------|------|------|
| （レスポンスボディ） | - | 成功時は空のJSONオブジェクトまたはacknowledgedレスポンス |

## イベント仕様

### 1-投票設定除外クリア

クライアントからDELETEリクエストを受信すると、以下の処理が実行される。

1. `RestClearVotingConfigExclusionsAction.prepareRequest()` でリクエストパラメータを解析
2. `ClearVotingConfigExclusionsRequest` を構築
3. `wait_for_removal` パラメータが指定されている場合、その値を設定（デフォルトtrue）
4. `ClearVotingConfigExclusionsAction.INSTANCE` トランスポートアクションを実行
5. 投票設定除外リストをクリアし、レスポンスを返却

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 投票設定除外クリア | クラスタメタデータ（VotingConfiguration） | DELETE | 投票設定除外リストから全ての除外エントリを削除 |

### テーブル別更新項目詳細

#### クラスタメタデータ（VotingConfiguration）

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| DELETE | voting_config_exclusions | 除外リストを空にする | クラスタ状態のメタデータとして永続化 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------|
| - | 成功 | 200 OK | 正常に投票設定除外がクリアされた場合 |
| - | エラー | 400 Bad Request | 除外ノードがまだクラスタに存在し、wait_for_removal=trueの場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|---------------|------|
| IllegalStateException | 400 | `wait_for_removal=true` で除外ノードがまだクラスタから離脱していない場合 |
| タイムアウト | 408 | 操作がタイムアウトした場合 |

## 備考

- `wait_for_removal` のデフォルト値は `true` であり、除外されたノードが全てクラスタから離脱するまで待機する。
- `wait_for_removal=false` を指定すると、除外されたノードがまだクラスタに存在していても強制的に除外リストをクリアする。この場合、該当ノードがまだ投票に参加できる状態になる。
- 投票設定除外が空の状態でクリアを実行しても、エラーにはならない。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ClearVotingConfigExclusionsRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/configuration/ClearVotingConfigExclusionsRequest.java` | リクエスト構成（waitForRemoval） |
| 1-2 | ClearVotingConfigExclusionsResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/configuration/ClearVotingConfigExclusionsResponse.java` | レスポンス構成 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestClearVotingConfigExclusionsAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestClearVotingConfigExclusionsAction.java` | RESTハンドラ。シンプルな実装 |

**主要処理フロー**:
1. **行57**: `routes()` で `DELETE /_cluster/voting_config_exclusions` を登録
2. **行66-72**: `prepareRequest()` でリクエスト解析
3. **行67**: `ClearVotingConfigExclusionsRequest` の構築
4. **行68-70**: `wait_for_removal` パラメータの処理
5. **行71**: `ClearVotingConfigExclusionsAction.INSTANCE` でトランスポートアクション実行

#### Step 3: トランスポートアクション層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportClearVotingConfigExclusionsAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/configuration/TransportClearVotingConfigExclusionsAction.java` | 投票設定除外のクリア処理 |

### プログラム呼び出し階層図

```
RestClearVotingConfigExclusionsAction.prepareRequest() [行66]
    |
    +-- ClearVotingConfigExclusionsRequest構築 [行67]
    |       +-- wait_for_removal設定 [行68-70]
    |
    +-- NodeClient.execute() [行71]
            +-- ClearVotingConfigExclusionsAction.INSTANCE
            |
            +-- TransportClearVotingConfigExclusionsAction
                    +-- 投票設定除外リストのクリア
                    +-- クラスタ状態の更新
                    +-- ClearVotingConfigExclusionsResponse構築
```

### データフロー図

```
[入力]                                              [処理]                                              [出力]

DELETE /_cluster/voting_config_exclusions      --> RestClearVotingConfigExclusionsAction          --> acknowledged
  ?wait_for_removal=true                            |
                                                    +-- ClearVotingConfigExclusionsRequest構築
                                                    +-- TransportAction実行
                                                    +-- 投票設定除外リストのクリア
                                                    +-- (wait_for_removal=true時) ノード離脱待機
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestClearVotingConfigExclusionsAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestClearVotingConfigExclusionsAction.java` | ソース | RESTハンドラ |
| ClearVotingConfigExclusionsAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/configuration/ClearVotingConfigExclusionsAction.java` | ソース | アクション定義 |
| ClearVotingConfigExclusionsRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/configuration/ClearVotingConfigExclusionsRequest.java` | ソース | リクエストデータモデル |
| TransportClearVotingConfigExclusionsAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/configuration/TransportClearVotingConfigExclusionsAction.java` | ソース | トランスポートアクション |
| cluster.delete_voting_config_exclusions.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.delete_voting_config_exclusions.json` | 設定 | REST API仕様定義 |
