# 画面設計書 103-重み付きルーティング削除

## 概要

本ドキュメントは、OpenSearchクラスタにおける重み付きシャードルーティングの重み設定を削除するREST APIエンドポイント `DELETE /_cluster/routing/awareness/weights` の設計を記述する。

### 本画面の処理概要

本APIは、Weighted Round-Robin方式のシャードルーティングポリシーの重み設定を削除し、デフォルトの均等分散に戻すためのエンドポイントである。

**業務上の目的・背景**：障害復旧後やメンテナンス完了後に、一時的に設定した重み付きルーティングを解除して通常の均等分散に戻す必要がある。本APIにより重み設定メタデータをクラスタ状態から削除し、全ゾーンへのトラフィックを均等化する。

**画面へのアクセス方法**：HTTPクライアントから `DELETE /_cluster/routing/awareness/weights` または `DELETE /_cluster/routing/awareness/{attribute}/weights` エンドポイントにDELETEリクエストを送信する。

**主要な操作・処理内容**：
1. クライアントからDELETEリクエストを受信する
2. オプションのリクエストボディからバージョン情報を解析する
3. クラスタマネージャノードでWeightedRoutingMetadataを削除する

**画面遷移**：関連するAPIとして、重みを取得する（No.101）、重みを設定する（No.102）がある。削除後は重みが未設定状態に戻り、No.101のGETでは空のレスポンスが返る。

**権限による表示制御**：クラスタレベルのメタデータ書き込み権限が必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 58 | 重み付きルーティング | 主機能 | 重み付きシャードルーティングの重みを削除する処理 |

## 画面種別

削除（DELETE）API

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| DELETE | `/_cluster/routing/awareness/weights` | 重み設定を削除（属性名省略） |
| DELETE | `/_cluster/routing/awareness/{attribute}/weights` | 指定属性の重み設定を削除 |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|-----|------|------|
| attribute | string | No | アウェアネス属性名（省略可） |

### リクエストボディ（オプション）

| フィールド | 型 | 必須 | 説明 |
|-----------|-----|------|------|
| _version | long | No | 楽観的排他制御用バージョン |

## 表示項目

### レスポンスボディ

| フィールド | 型 | 説明 |
|-----------|-----|------|
| acknowledged | boolean | リクエストが受理されたかどうか |

## イベント仕様

### 1-DELETEリクエスト受信

1. `RestClusterDeleteWeightedRoutingAction.prepareRequest()` がリクエストを受信する
2. `createRequest()` メソッドで `ClusterDeleteWeightedRoutingRequest` を生成する
3. オプションのリクエストボディを解析する
4. `NodeClient` 経由で `TransportDeleteWeightedRoutingAction` にリクエストを転送する
5. クラスタマネージャノードでWeightedRoutingMetadataが削除される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| DELETEリクエスト | ClusterState Metadata | DELETE | WeightedRoutingMetadataの削除 |

### テーブル別更新項目詳細

#### ClusterState Metadata

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | WeightedRoutingMetadata | メタデータから完全削除 | クラスタ状態のカスタムメタデータから除去 |

## メッセージ仕様

| 種別 | メッセージ | 条件 |
|------|----------|------|
| 成功 | 200 OK + `{"acknowledged": true}` | 正常に削除できた場合 |
| エラー | ClusterBlockException | クラスタがブロック中の場合 |

## 例外処理

| 例外条件 | HTTPステータス | レスポンス内容 |
|---------|---------------|---------------|
| クラスタブロック中 | 403 Forbidden | ClusterBlockException |
| クラスタマネージャノード未発見 | 503 Service Unavailable | MasterNotDiscoveredException |

## 備考

- 2つのエンドポイントパスが存在する。属性名付きのパスと省略可能なパスの両方が利用可能
- 重みが未設定の状態でDELETEを実行してもエラーにはならない
- リクエストボディは任意であり、省略可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ClusterDeleteWeightedRoutingRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/shards/routing/weighted/delete/ClusterDeleteWeightedRoutingRequest.java` | リクエスト構造とバリデーション |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestClusterDeleteWeightedRoutingAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestClusterDeleteWeightedRoutingAction.java` | 2つのルート定義（行39-44）と `createRequest()` メソッド（行60-66） |

**主要処理フロー**:
1. **行39-44**: DELETE用の2つのルートを登録
2. **行54**: `createRequest()` でリクエストオブジェクトを生成
3. **行61**: パスパラメータ `attribute` を取得（省略可）
4. **行64**: リクエストボディを解析

#### Step 3: Transport層の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportDeleteWeightedRoutingAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/shards/routing/weighted/delete/TransportDeleteWeightedRoutingAction.java` | メタデータ削除ロジック |

### プログラム呼び出し階層図

```
RestClusterDeleteWeightedRoutingAction.prepareRequest()
    |
    +-- createRequest(RestRequest)
    |       +-- Requests.deleteWeightedRoutingRequest(attribute)
    |       +-- request.applyContentParser()
    |
    +-- NodeClient.admin().cluster().deleteWeightedRouting()
            |
            +-- TransportDeleteWeightedRoutingAction.clusterManagerOperation()
                    +-- WeightedRoutingService.deleteWeightedRoutingMetadata()
```

### データフロー図

```
[入力]                        [処理]                              [出力]

DELETE request           --> RestClusterDeleteWeightedRoutingAction --> ClusterDeleteWeightedRoutingRequest
  (attribute param opt)      .createRequest()

                         --> TransportDeleteWeightedRoutingAction   --> ClusterStateUpdateResponse
                             .clusterManagerOperation()                  { acknowledged: true }
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestClusterDeleteWeightedRoutingAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestClusterDeleteWeightedRoutingAction.java` | ソース | RESTエンドポイント定義 |
| ClusterDeleteWeightedRoutingRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/shards/routing/weighted/delete/ClusterDeleteWeightedRoutingRequest.java` | ソース | リクエストオブジェクト定義 |
| ClusterDeleteWeightedRoutingAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/shards/routing/weighted/delete/ClusterDeleteWeightedRoutingAction.java` | ソース | アクション名定義 |
| TransportDeleteWeightedRoutingAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/shards/routing/weighted/delete/TransportDeleteWeightedRoutingAction.java` | ソース | Transport層ビジネスロジック |
| cluster.delete_weighted_routing.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.delete_weighted_routing.json` | 設定 | REST APIスペック定義 |
