# 画面設計書 104-デコミッション設定

## 概要

本ドキュメントは、OpenSearchクラスタにおけるアウェアネス属性のデコミッション（廃止）を設定するREST APIエンドポイント `PUT /_cluster/decommission/awareness/{awareness_attribute_name}/{awareness_attribute_value}` の設計を記述する。

### 本画面の処理概要

本APIは、特定のアウェアネス属性値（例: 特定のアベイラビリティゾーン）をデコミッション対象としてマークし、そのゾーン内のノードをクラスタから除外する処理を開始するためのエンドポイントである。

**業務上の目的・背景**：マルチゾーン構成のOpenSearchクラスタにおいて、特定のアベイラビリティゾーン全体が障害に見舞われた場合や、計画的なメンテナンスのためにゾーンを停止する必要がある場合に使用される。デコミッションにより、対象ゾーン内のノードがクラスタから安全に除外され、シャードの再配置が行われる。これはゾーン障害への対応を自動化し、手動でのノード個別除外の手間を省くための重要な運用機能である。

**画面へのアクセス方法**：HTTPクライアントから `PUT /_cluster/decommission/awareness/{awareness_attribute_name}/{awareness_attribute_value}` にPUTリクエストを送信する。

**主要な操作・処理内容**：
1. URLパスからアウェアネス属性名と属性値を抽出する
2. `DecommissionAttribute` オブジェクトを構築する
3. オプションパラメータ（`no_delay`, `delay_timeout`）を設定する
4. クラスタマネージャノードでデコミッション処理を開始する

**画面遷移**：関連するAPIとして、デコミッション状態を取得する（No.105）、デコミッションを削除する（No.106）がある。デコミッション設定後はNo.105で状態を確認し、復旧後はNo.106で解除する。

**権限による表示制御**：クラスタレベルの管理権限が必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 54 | ノードデコミッション | 主機能 | アウェアネス属性をデコミッションする処理 |

## 画面種別

設定（PUT）API

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| PUT | `/_cluster/decommission/awareness/{awareness_attribute_name}/{awareness_attribute_value}` | デコミッションの設定 |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|-----|------|------|
| awareness_attribute_name | string | Yes | アウェアネス属性名（例: `zone`） |
| awareness_attribute_value | string | Yes | デコミッション対象の属性値（例: `zone-a`） |

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|-----|------|-----------|------|
| no_delay | boolean | No | false | 遅延なしでデコミッションを実行するかどうか |
| delay_timeout | time | No | DecommissionRequest.DEFAULT_NODE_DRAINING_TIMEOUT | ノードドレイニングの遅延タイムアウト |

## 表示項目

### レスポンスボディ

| フィールド | 型 | 説明 |
|-----------|-----|------|
| acknowledged | boolean | リクエストが受理されたかどうか |

## イベント仕様

### 1-PUTリクエスト受信

1. `RestDecommissionAction.prepareRequest()` がリクエストを受信する
2. `createRequest()` メソッドで `DecommissionRequest` を生成する
3. パスパラメータから属性名と属性値を取得する
4. `no_delay` パラメータと `delay_timeout` パラメータを設定する
5. `DecommissionAttribute` オブジェクトを構築してリクエストに設定する
6. `NodeClient` 経由で `TransportDecommissionAction` にリクエストを転送する
7. デコミッション処理が非同期で開始される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| PUTリクエスト | ClusterState Metadata | INSERT/UPDATE | デコミッションメタデータの作成・更新 |

### テーブル別更新項目詳細

#### ClusterState Metadata - DecommissionAttributeMetadata

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | DecommissionAttribute | 属性名+属性値 | デコミッション対象のアウェアネス属性 |
| INSERT/UPDATE | DecommissionStatus | INIT -> DRAINING -> IN_PROGRESS -> SUCCESSFUL | デコミッションの進行状態 |

## メッセージ仕様

| 種別 | メッセージ | 条件 |
|------|----------|------|
| 成功 | 200 OK + `{"acknowledged": true}` | デコミッション処理が開始された場合 |
| エラー | バリデーションエラー | 属性名・属性値が不正な場合 |

## 例外処理

| 例外条件 | HTTPステータス | レスポンス内容 |
|---------|---------------|---------------|
| 属性名・属性値が空 | 400 Bad Request | バリデーションエラー |
| 既にデコミッション中 | 400 Bad Request | デコミッション重複エラー |
| クラスタブロック中 | 403 Forbidden | ClusterBlockException |

## 備考

- 本APIはexperimental（実験的）ステータスである
- デコミッション処理は非同期で実行され、複数のステージ（DRAINING -> IN_PROGRESS -> SUCCESSFUL）を経て完了する
- `no_delay` パラメータを `true` に設定すると、ノードドレイニングの遅延なしで即座にデコミッションが実行される
- `delay_timeout` パラメータでノードドレイニングの待機時間を調整できる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DecommissionAttribute.java | `server/src/main/java/org/opensearch/cluster/decommission/DecommissionAttribute.java` | デコミッション対象の属性名・属性値を保持するデータ構造 |
| 1-2 | DecommissionRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/decommission/awareness/put/DecommissionRequest.java` | リクエスト構造。DEFAULT_NODE_DRAINING_TIMEOUT等の定数 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestDecommissionAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestDecommissionAction.java` | ルート定義（行35）と `createRequest()` メソッド（行49-62） |

**主要処理フロー**:
1. **行35**: PUTルートを登録
2. **行51**: `awareness_attribute_name` パスパラメータを取得
3. **行52**: `awareness_attribute_value` パスパラメータを取得
4. **行54**: `no_delay` クエリパラメータを取得
5. **行57-59**: `delay_timeout` パラメータを取得
6. **行61**: `DecommissionAttribute` を構築してリクエストに設定

#### Step 3: Transport層の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportDecommissionAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/decommission/awareness/put/TransportDecommissionAction.java` | デコミッション処理の開始ロジック |

### プログラム呼び出し階層図

```
RestDecommissionAction.prepareRequest()
    |
    +-- createRequest(RestRequest)
    |       +-- Requests.decommissionRequest()
    |       +-- DecommissionAttribute(attributeName, attributeValue)
    |       +-- setNoDelay(boolean)
    |       +-- setDelayTimeout(TimeValue)
    |
    +-- NodeClient.admin().cluster().decommission()
            |
            +-- TransportDecommissionAction.clusterManagerOperation()
                    +-- DecommissionService.startDecommission()
```

### データフロー図

```
[入力]                              [処理]                         [出力]

PUT request                    --> RestDecommissionAction        --> DecommissionRequest
  awareness_attribute_name         .createRequest()
  awareness_attribute_value
  no_delay (opt)
  delay_timeout (opt)

                               --> TransportDecommissionAction   --> DecommissionResponse
                                   .clusterManagerOperation()         { acknowledged: true }
                                   DecommissionService
                                     .startDecommission()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestDecommissionAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestDecommissionAction.java` | ソース | RESTエンドポイント定義 |
| DecommissionRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/decommission/awareness/put/DecommissionRequest.java` | ソース | リクエストオブジェクト定義 |
| DecommissionAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/decommission/awareness/put/DecommissionAction.java` | ソース | アクション名定義 |
| TransportDecommissionAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/decommission/awareness/put/TransportDecommissionAction.java` | ソース | Transport層ビジネスロジック |
| DecommissionAttribute.java | `server/src/main/java/org/opensearch/cluster/decommission/DecommissionAttribute.java` | ソース | デコミッション属性データ構造 |
| cluster.put_decommission_awareness.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.put_decommission_awareness.json` | 設定 | REST APIスペック定義 |
