# 画面設計書 105-デコミッション状態取得

## 概要

本ドキュメントは、OpenSearchクラスタにおけるデコミッションされたアウェアネス属性の詳細とステータスを取得するREST APIエンドポイント `GET /_cluster/decommission/awareness/{awareness_attribute_name}/_status` の設計を記述する。

### 本画面の処理概要

本APIは、デコミッション処理の進行状況と対象属性の詳細情報を返すエンドポイントである。

**業務上の目的・背景**：デコミッション操作（No.104）を実行した後、その処理が正常に進行しているかを監視するために必要である。デコミッションは複数のステージ（INIT, DRAINING, IN_PROGRESS, SUCCESSFUL, FAILED）を経て完了するため、現在の状態を確認することで、運用者が適切なタイミングで次のアクション（復旧やデコミッション解除等）を判断できる。

**画面へのアクセス方法**：HTTPクライアントから `GET /_cluster/decommission/awareness/{awareness_attribute_name}/_status` にGETリクエストを送信する。

**主要な操作・処理内容**：
1. URLパスからアウェアネス属性名を抽出する
2. クラスタ状態メタデータからデコミッション状態情報を取得する
3. デコミッションの属性情報とステータスをJSONレスポンスとして返却する

**画面遷移**：関連するAPIとして、デコミッションを設定する（No.104）、デコミッションを削除する（No.106）がある。

**権限による表示制御**：クラスタレベルのメタデータ読み取り権限が必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 54 | ノードデコミッション | 主機能 | デコミッションされた属性の詳細とステータスを取得する処理 |

## 画面種別

情報取得（GET）API

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_cluster/decommission/awareness/{awareness_attribute_name}/_status` | デコミッション状態を取得 |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|-----|------|------|
| awareness_attribute_name | string | Yes | アウェアネス属性名（例: `zone`） |

## 表示項目

### レスポンスボディ

| フィールド | 型 | 説明 |
|-----------|-----|------|
| awareness_attribute_name | string | デコミッション対象の属性名 |
| awareness_attribute_value | string | デコミッション対象の属性値 |
| status | string | デコミッションのステータス（INIT / DRAINING / IN_PROGRESS / SUCCESSFUL / FAILED） |

### レスポンス例

```json
{
  "zone": {
    "value": "zone-a",
    "status": "SUCCESSFUL"
  }
}
```

## イベント仕様

### 1-GETリクエスト受信

1. `RestGetDecommissionStateAction.prepareRequest()` がリクエストを受信する
2. パスパラメータから `awareness_attribute_name` を取得する
3. `GetDecommissionStateRequest` を生成して属性名を設定する
4. `NodeClient` 経由で `TransportGetDecommissionStateAction` にリクエストを転送する
5. クラスタ状態からデコミッション情報を取得してレスポンスを返却する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| GETリクエスト | ClusterState（メモリ内） | SELECT | デコミッションメタデータの読み取り |

### テーブル別更新項目詳細

#### ClusterState Metadata

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | DecommissionAttributeMetadata | attributeNameで検索 | デコミッション属性・ステータス情報 |

## メッセージ仕様

| 種別 | メッセージ | 条件 |
|------|----------|------|
| 成功 | 200 OK + JSONレスポンス | 正常に状態を取得できた場合 |
| エラー | バリデーションエラー | 属性名が未指定の場合 |

## 例外処理

| 例外条件 | HTTPステータス | レスポンス内容 |
|---------|---------------|---------------|
| 属性名未指定 | 400 Bad Request | バリデーションエラー |
| デコミッション未設定 | 200 OK | ステータスなしのレスポンス |
| クラスタマネージャ未発見 | 503 Service Unavailable | MasterNotDiscoveredException |

## 備考

- 本APIはexperimental（実験的）ステータスである
- デコミッションが未設定の場合でも200レスポンスが返る
- ステータス値: INIT（初期化中）、DRAINING（ドレイニング中）、IN_PROGRESS（進行中）、SUCCESSFUL（成功）、FAILED（失敗）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GetDecommissionStateRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/decommission/awareness/get/GetDecommissionStateRequest.java` | リクエスト構造。`attributeName` フィールド |
| 1-2 | GetDecommissionStateResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/decommission/awareness/get/GetDecommissionStateResponse.java` | レスポンス構造。属性名・値・ステータス |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestGetDecommissionStateAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestGetDecommissionStateAction.java` | ルート定義（行33）と `prepareRequest()` メソッド（行42-47） |

**主要処理フロー**:
1. **行33**: GETルートを登録
2. **行43**: `GetDecommissionStateRequest` を生成
3. **行44**: `awareness_attribute_name` パスパラメータを取得
4. **行45**: リクエストに属性名を設定
5. **行46**: Transport層にリクエストを転送

#### Step 3: Transport層の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportGetDecommissionStateAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/decommission/awareness/get/TransportGetDecommissionStateAction.java` | クラスタ状態からデコミッション情報を取得するロジック |

### プログラム呼び出し階層図

```
RestGetDecommissionStateAction.prepareRequest()
    |
    +-- Requests.getDecommissionStateRequest()
    |
    +-- GetDecommissionStateRequest.attributeName(name)
    |
    +-- NodeClient.admin().cluster().getDecommissionState()
            |
            +-- TransportGetDecommissionStateAction.clusterManagerOperation()
                    +-- ClusterState.metadata().decommissionAttributeMetadata()
```

### データフロー図

```
[入力]                              [処理]                              [出力]

GET request                    --> RestGetDecommissionStateAction    --> GetDecommissionStateRequest
  awareness_attribute_name         .prepareRequest()

                               --> TransportGetDecommissionStateAction --> GetDecommissionStateResponse
                                   .clusterManagerOperation()               { attribute, value, status }
                                   ClusterState.metadata
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestGetDecommissionStateAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestGetDecommissionStateAction.java` | ソース | RESTエンドポイント定義 |
| GetDecommissionStateRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/decommission/awareness/get/GetDecommissionStateRequest.java` | ソース | リクエストオブジェクト |
| GetDecommissionStateResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/decommission/awareness/get/GetDecommissionStateResponse.java` | ソース | レスポンスオブジェクト |
| GetDecommissionStateAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/decommission/awareness/get/GetDecommissionStateAction.java` | ソース | アクション名定義 |
| TransportGetDecommissionStateAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/decommission/awareness/get/TransportGetDecommissionStateAction.java` | ソース | Transport層ロジック |
| cluster.get_decommission_awareness.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.get_decommission_awareness.json` | 設定 | REST APIスペック定義 |
