# 画面設計書 106-デコミッション削除

## 概要

本ドキュメントは、OpenSearchクラスタにおける既存のデコミッション設定を削除するREST APIエンドポイント `DELETE /_cluster/decommission/awareness` の設計を記述する。

### 本画面の処理概要

本APIは、以前に設定されたデコミッション（ゾーン廃止）メタデータをクラスタ状態から削除し、デコミッション状態を解除するためのエンドポイントである。

**業務上の目的・背景**：デコミッションしたゾーンの復旧が完了した後、またはデコミッション操作を取り消す必要がある場合に使用される。デコミッションメタデータを削除することで、対象ゾーンのノードがクラスタに再参加でき、通常運用に復帰する。障害復旧後の運用正常化において不可欠な操作である。

**画面へのアクセス方法**：HTTPクライアントから `DELETE /_cluster/decommission/awareness` にDELETEリクエストを送信する。

**主要な操作・処理内容**：
1. DELETEリクエストを受信する
2. `DeleteDecommissionStateRequest` を生成する
3. クラスタマネージャノードでデコミッションメタデータを削除する

**画面遷移**：関連するAPIとして、デコミッションを設定する（No.104）、デコミッション状態を取得する（No.105）がある。

**権限による表示制御**：クラスタレベルの管理権限が必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 54 | ノードデコミッション | 主機能 | 既存のデコミッションを削除する処理 |

## 画面種別

削除（DELETE）API

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| DELETE | `/_cluster/decommission/awareness` | デコミッションメタデータを削除 |

## 入出力項目

### パスパラメータ

なし

### クエリパラメータ

なし

## 表示項目

### レスポンスボディ

| フィールド | 型 | 説明 |
|-----------|-----|------|
| acknowledged | boolean | リクエストが受理されたかどうか |

## イベント仕様

### 1-DELETEリクエスト受信

1. `RestDeleteDecommissionStateAction.prepareRequest()` がリクエストを受信する
2. `createRequest()` メソッドで `DeleteDecommissionStateRequest` を生成する
3. `NodeClient` 経由で `TransportDeleteDecommissionStateAction` にリクエストを転送する
4. クラスタマネージャノードでデコミッションメタデータが削除される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| DELETEリクエスト | ClusterState Metadata | DELETE | デコミッションメタデータの削除 |

### テーブル別更新項目詳細

#### ClusterState Metadata

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | DecommissionAttributeMetadata | メタデータから完全削除 | デコミッション情報を除去 |

## メッセージ仕様

| 種別 | メッセージ | 条件 |
|------|----------|------|
| 成功 | 200 OK + `{"acknowledged": true}` | 正常に削除できた場合 |
| エラー | ClusterBlockException | クラスタがブロック中の場合 |

## 例外処理

| 例外条件 | HTTPステータス | レスポンス内容 |
|---------|---------------|---------------|
| クラスタブロック中 | 403 Forbidden | ClusterBlockException |
| クラスタマネージャ未発見 | 503 Service Unavailable | MasterNotDiscoveredException |

## 備考

- 本APIはexperimental（実験的）ステータスである
- パスパラメータなしの単一エンドポイントで、すべてのデコミッションメタデータを削除する
- デコミッションが未設定の状態でDELETEを実行してもエラーにはならない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DeleteDecommissionStateRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/decommission/awareness/delete/DeleteDecommissionStateRequest.java` | パラメータなしの単純なリクエスト構造 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestDeleteDecommissionStateAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestDeleteDecommissionStateAction.java` | ルート定義（行33）と `prepareRequest()`（行42-47） |

**主要処理フロー**:
1. **行33**: `DELETE /_cluster/decommission/awareness` のルートを登録
2. **行43**: `createRequest()` でリクエストオブジェクトを生成
3. **行44-46**: Transport層に処理を委譲

#### Step 3: Transport層の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportDeleteDecommissionStateAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/decommission/awareness/delete/TransportDeleteDecommissionStateAction.java` | メタデータ削除ロジック |

### プログラム呼び出し階層図

```
RestDeleteDecommissionStateAction.prepareRequest()
    |
    +-- createRequest()
    |       +-- Requests.deleteDecommissionStateRequest()
    |
    +-- NodeClient.admin().cluster().deleteDecommissionState()
            |
            +-- TransportDeleteDecommissionStateAction.clusterManagerOperation()
                    +-- DecommissionService.deleteDecommissionState()
```

### データフロー図

```
[入力]                        [処理]                                   [出力]

DELETE request           --> RestDeleteDecommissionStateAction       --> DeleteDecommissionStateRequest

                         --> TransportDeleteDecommissionStateAction  --> DeleteDecommissionStateResponse
                             .clusterManagerOperation()                    { acknowledged: true }
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestDeleteDecommissionStateAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestDeleteDecommissionStateAction.java` | ソース | RESTエンドポイント定義 |
| DeleteDecommissionStateRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/decommission/awareness/delete/DeleteDecommissionStateRequest.java` | ソース | リクエストオブジェクト |
| DeleteDecommissionStateAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/decommission/awareness/delete/DeleteDecommissionStateAction.java` | ソース | アクション名定義 |
| TransportDeleteDecommissionStateAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/decommission/awareness/delete/TransportDeleteDecommissionStateAction.java` | ソース | Transport層ロジック |
| cluster.delete_decommission_awareness.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.delete_decommission_awareness.json` | 設定 | REST APIスペック定義 |
