# 画面設計書 107-ノード情報

## 概要

本ドキュメントは、OpenSearchクラスタ内のノード情報を取得するREST APIエンドポイント `GET /_nodes` の設計を記述する。

### 本画面の処理概要

本APIは、クラスタ内の全ノードまたは指定ノードの静的な構成情報（設定、OS、JVM、プラグイン等）を返すエンドポイントである。

**業務上の目的・背景**：クラスタの構成管理・監視において、各ノードのハードウェア構成、JVM設定、インストール済みプラグイン、トランスポート・HTTP設定等の情報を把握するために必要である。障害調査時のノード構成確認、キャパシティプランニングのための情報収集、設定の整合性チェック等に利用される。クラスタ管理者が各ノードの構成を一覧できる基本的な情報取得APIである。

**画面へのアクセス方法**：HTTPクライアントから `GET /_nodes` またはフィルタ付きの `GET /_nodes/{nodeId}/{metrics}` にGETリクエストを送信する。

**主要な操作・処理内容**：
1. URLパスパラメータからノードID（省略可）とメトリクス（省略可）を取得する
2. メトリクスが既知のメトリクス名のみで構成されているか、ノードIDとして扱うかを判別する
3. 各ノードにリクエストを転送し、指定メトリクスの情報を収集する
4. 収集結果をJSON形式で返却する

**画面遷移**：関連するAPIとして、ノード統計（No.108）、ノード使用状況（No.109）、ホットスレッド（No.110）がある。ノード情報は静的な構成情報であり、動的な統計情報はNo.108で取得する。

**権限による表示制御**：クラスタレベルのモニタリング権限が必要である。`SettingsFilter` により、セキュリティ上隠すべき設定はフィルタリングされる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 49 | ノード情報・統計 | 主機能 | クラスタ内のノード情報を返す処理 |

## 画面種別

情報取得（GET）API

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_nodes` | 全ノードの全メトリクスを取得 |
| GET | `/_nodes/{nodeId}` | 指定ノードの全メトリクス、またはメトリクスフィルタ |
| GET | `/_nodes/{nodeId}/{metrics}` | 指定ノードの指定メトリクスを取得 |
| GET | `/_nodes/{nodeId}/info/{metrics}` | 指定ノードの指定メトリクスを取得（stats互換パス） |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|-----|------|------|
| nodeId | list(string) | No | ノードIDまたは名前のカンマ区切りリスト。`_local`で接続先ノード、`_all`で全ノード |
| metrics | list(string) | No | 取得メトリクスのカンマ区切りリスト |

### 利用可能なメトリクス

| メトリクス名 | 説明 |
|-------------|------|
| settings | ノード設定 |
| os | OS情報（名前、バージョン、CPU、メモリ等） |
| process | プロセス情報（PID等） |
| jvm | JVM情報（バージョン、メモリ設定、GC等） |
| thread_pool | スレッドプール設定 |
| transport | トランスポート設定 |
| http | HTTP設定 |
| plugins | インストール済みプラグイン |
| ingest | インジェストプロセッサ情報 |

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|-----|------|-----------|------|
| flat_settings | boolean | No | false | 設定をフラット形式で返すかどうか |
| timeout | time | No | - | 操作タイムアウト |

## 表示項目

### レスポンスボディ

| フィールド | 型 | 説明 |
|-----------|-----|------|
| _nodes | object | リクエスト結果のノード概要（total, successful, failed） |
| cluster_name | string | クラスタ名 |
| nodes | object | ノードIDをキー、各ノード情報を値とするマップ |
| nodes.{id}.name | string | ノード名 |
| nodes.{id}.transport_address | string | トランスポートアドレス |
| nodes.{id}.host | string | ホスト名 |
| nodes.{id}.ip | string | IPアドレス |
| nodes.{id}.version | string | OpenSearchバージョン |
| nodes.{id}.roles | array | ノードロール一覧 |
| nodes.{id}.settings | object | ノード設定（metricsにsettings指定時） |
| nodes.{id}.os | object | OS情報（metricsにos指定時） |
| nodes.{id}.jvm | object | JVM情報（metricsにjvm指定時） |
| nodes.{id}.plugins | array | プラグイン一覧（metricsにplugins指定時） |

## イベント仕様

### 1-GETリクエスト受信

1. `RestNodesInfoAction.prepareRequest()` がリクエストを受信する
2. `prepareRequest(RestRequest)` 静的メソッドでリクエストパラメータを解析する
3. `nodeId` パラメータがメトリクス名のみで構成されているかを判別する
4. メトリクスのみの場合はノードIDを `_all` に設定し、メトリクスとして扱う
5. `NodesInfoRequest` を構築し、メトリクスの設定を行う
6. `SettingsFilter` によるフィルタリング設定を適用する
7. Transport層経由で全対象ノードに情報取得リクエストを転送する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| GETリクエスト | 各ノードのメモリ内情報 | SELECT | ノードの静的構成情報を読み取り |

## メッセージ仕様

| 種別 | メッセージ | 条件 |
|------|----------|------|
| 成功 | 200 OK + JSONレスポンス | 正常にノード情報を取得できた場合 |
| 部分成功 | 200 OK + failures配列付きレスポンス | 一部ノードで情報取得に失敗した場合 |

## 例外処理

| 例外条件 | HTTPステータス | レスポンス内容 |
|---------|---------------|---------------|
| タイムアウト | 408 Request Timeout | タイムアウトエラー |
| ノード到達不能 | 200 OK | failures配列に失敗ノード情報を含む |

## 備考

- `nodeId` パラメータに既知メトリクス名のみを指定した場合、自動的にメトリクスフィルタとして扱われる（例: `GET /_nodes/jvm` は全ノードのJVM情報を返す）
- `canTripCircuitBreaker()` が `false` を返すため、サーキットブレーカーをトリップしない
- `SettingsFilter` により、セキュリティ関連の設定値は自動的にフィルタリングされる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | NodesInfoRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/info/NodesInfoRequest.java` | リクエスト構造。Metricの全列挙、`addMetrics()` メソッド |
| 1-2 | NodeInfo.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/info/NodeInfo.java` | 各ノードの情報構造体 |

**読解のコツ**: `NodesInfoRequest.Metric.allMetrics()` で利用可能なメトリクス名の全セットが取得できる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestNodesInfoAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestNodesInfoAction.java` | ルート定義（行68-78）と `prepareRequest()` 静的メソッド（行94-129） |

**主要処理フロー**:
1. **行59**: `ALLOWED_METRICS` に利用可能なメトリクス名セットを保持
2. **行94-129**: `prepareRequest()` でリクエスト解析。nodeIdとmetricsの判別ロジック
3. **行101-111**: `nodeId` がメトリクス名のみで構成されている場合の特別処理
4. **行120-127**: メトリクスが `_all` でない場合、不明メトリクスを無視してフィルタ
5. **行90**: `SettingsFilter` によるフィルタリング設定を適用

#### Step 3: Transport層の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportNodesInfoAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/info/TransportNodesInfoAction.java` | 各ノードへのリクエスト転送・レスポンス集約 |

### プログラム呼び出し階層図

```
RestNodesInfoAction.prepareRequest(RestRequest, NodeClient)
    |
    +-- prepareRequest(RestRequest) [static]
    |       +-- ALLOWED_METRICS.containsAll(metricsOrNodeIds)
    |       +-- NodesInfoRequest(nodeIds)
    |       +-- nodesInfoRequest.addMetrics(metrics)
    |
    +-- settingsFilter.addFilterSettingParams(request)
    |
    +-- NodeClient.admin().cluster().nodesInfo()
            |
            +-- TransportNodesInfoAction
                    +-- NodeService.info() [on each node]
                    +-- NodesInfoResponse [aggregated]
```

### データフロー図

```
[入力]                     [処理]                          [出力]

GET request           --> RestNodesInfoAction            --> NodesInfoRequest
  nodeId (opt)            .prepareRequest()
  metrics (opt)           メトリクス/ノードID判別
  timeout (opt)
  flat_settings (opt)

                      --> TransportNodesInfoAction       --> NodesInfoResponse
                          [各ノードに分散実行]                { _nodes, cluster_name,
                          NodeService.info()                   nodes: { ... } }
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestNodesInfoAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestNodesInfoAction.java` | ソース | RESTエンドポイント定義・メトリクス判別 |
| NodesInfoRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/info/NodesInfoRequest.java` | ソース | リクエストオブジェクト |
| NodeInfo.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/info/NodeInfo.java` | ソース | 個別ノード情報 |
| NodesInfoResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/info/NodesInfoResponse.java` | ソース | レスポンスオブジェクト |
| TransportNodesInfoAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/info/TransportNodesInfoAction.java` | ソース | Transport層ロジック |
| nodes.info.json | `rest-api-spec/src/main/resources/rest-api-spec/api/nodes.info.json` | 設定 | REST APIスペック定義 |
