# 画面設計書 108-ノード統計

## 概要

本ドキュメントは、OpenSearchクラスタ内のノード統計情報を取得するREST APIエンドポイント `GET /_nodes/stats` の設計を記述する。

### 本画面の処理概要

本APIは、クラスタ内の全ノードまたは指定ノードの動的な統計情報（インデックス操作数、JVMメモリ使用量、OS負荷等）を返すエンドポイントである。

**業務上の目的・背景**：クラスタの性能監視・トラブルシューティングにおいて、各ノードのリアルタイム統計を収集するために必要である。JVMヒープ使用量、GC統計、ディスクI/O、検索・インデキシングのスループット、スレッドプールのキューサイズ等、ノードの健全性と性能を評価するための広範な情報を提供する。監視ツール（Prometheus exporter等）がこのAPIをポーリングしてメトリクスを収集する用途が一般的である。

**画面へのアクセス方法**：HTTPクライアントから `GET /_nodes/stats` または `GET /_nodes/{nodeId}/stats/{metric}/{index_metric}` にGETリクエストを送信する。

**主要な操作・処理内容**：
1. URLパスパラメータからノードID、メトリクス、インデックスメトリクスを取得する
2. メトリクスフィルタに基づいて `NodesStatsRequest` を構築する
3. 各ノードにリクエストを転送し、統計情報を収集する
4. 収集結果をJSON形式で返却する

**画面遷移**：関連するAPIとして、ノード情報（No.107）、ノード使用状況（No.109）がある。No.107は静的構成、No.108は動的統計を返す。

**権限による表示制御**：クラスタレベルのモニタリング権限が必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 49 | ノード情報・統計 | 主機能 | クラスタ内のノード統計情報を返す処理 |

## 画面種別

情報取得（GET）API

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_nodes/stats` | 全ノードの全統計を取得 |
| GET | `/_nodes/{nodeId}/stats` | 指定ノードの全統計を取得 |
| GET | `/_nodes/stats/{metric}` | 全ノードの指定メトリクスを取得 |
| GET | `/_nodes/{nodeId}/stats/{metric}` | 指定ノードの指定メトリクスを取得 |
| GET | `/_nodes/stats/{metric}/{index_metric}` | 全ノードの指定メトリクス・インデックスメトリクスを取得 |
| GET | `/_nodes/{nodeId}/stats/{metric}/{index_metric}` | 指定ノード・メトリクス・インデックスメトリクスを取得 |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|-----|------|------|
| nodeId | list(string) | No | ノードIDのカンマ区切りリスト |
| metric | list(string) | No | メトリクスのカンマ区切りリスト |
| index_metric | list(string) | No | インデックスメトリクスのカンマ区切りリスト |

### 利用可能なメトリクス

| メトリクス名 | 説明 |
|-------------|------|
| _all | 全メトリクス |
| breaker | サーキットブレーカー統計 |
| fs | ファイルシステム統計 |
| http | HTTP接続統計 |
| indices | インデックス操作統計 |
| jvm | JVM統計（ヒープ、GC等） |
| os | OS統計（CPU、メモリ等） |
| process | プロセス統計 |
| thread_pool | スレッドプール統計 |
| transport | トランスポート統計 |
| discovery | ディスカバリ統計 |
| indexing_pressure | インデキシングプレッシャー統計 |

### 利用可能なインデックスメトリクス

| メトリクス名 | 説明 |
|-------------|------|
| _all | 全インデックスメトリクス |
| completion | 補完統計 |
| docs | ドキュメント統計 |
| fielddata | フィールドデータ統計 |
| query_cache | クエリキャッシュ統計 |
| flush | フラッシュ統計 |
| get | GET操作統計 |
| indexing | インデキシング統計 |
| merge | マージ統計 |
| request_cache | リクエストキャッシュ統計 |
| refresh | リフレッシュ統計 |
| search | 検索統計 |
| segments | セグメント統計 |
| store | ストア統計 |
| warmer | ウォーマー統計 |
| suggest | サジェスト統計 |

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|-----|------|-----------|------|
| completion_fields | list | No | - | completionメトリクス対象フィールド |
| fielddata_fields | list | No | - | fielddataメトリクス対象フィールド |
| fields | list | No | - | fielddata/completionメトリクス対象フィールド |
| groups | boolean | No | - | searchメトリクスのグループ |
| level | enum | No | node | 集約レベル（indices/node/shards） |
| types | list | No | - | indexingメトリクスのドキュメントタイプ |
| timeout | time | No | - | 操作タイムアウト |
| include_segment_file_sizes | boolean | No | false | セグメントファイルサイズを含めるか |

## 表示項目

### レスポンスボディ

| フィールド | 型 | 説明 |
|-----------|-----|------|
| _nodes | object | リクエスト結果概要 |
| cluster_name | string | クラスタ名 |
| nodes | object | ノードIDをキー、統計情報を値とするマップ |
| nodes.{id}.indices | object | インデックス操作統計 |
| nodes.{id}.os | object | OS統計（CPU使用率、メモリ使用量等） |
| nodes.{id}.jvm | object | JVM統計（ヒープ使用量、GC統計等） |
| nodes.{id}.fs | object | ファイルシステム統計 |
| nodes.{id}.thread_pool | object | スレッドプール統計 |

## イベント仕様

### 1-GETリクエスト受信

1. `RestNodesStatsAction.prepareRequest()` がリクエストを受信する
2. `nodeId` と `metric` パラメータを解析する
3. `_all` の場合は全メトリクスを有効化、個別指定の場合は `METRICS` マップから該当ハンドラを適用する
4. `indices` メトリクスが含まれる場合、`index_metric` を解析して `CommonStatsFlags` を構築する
5. フィールドフィルタ（fielddata_fields, completion_fields, fields）を適用する
6. レベル設定（indices/node/shards）を適用する
7. Transport層経由で各ノードに統計情報取得を実行する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| GETリクエスト | 各ノードのメモリ内統計 | SELECT | ノードの動的統計情報を読み取り |

## メッセージ仕様

| 種別 | メッセージ | 条件 |
|------|----------|------|
| 成功 | 200 OK + JSONレスポンス | 正常に統計を取得できた場合 |
| エラー | "request [...] contains _all and individual metrics [...]" | `_all` と個別メトリクスが混在指定された場合 |
| エラー | "request [...] contains index metrics [...] but all stats requested" | `_all` とindex_metricが同時指定された場合 |
| エラー | "request [...] contains index metrics [...] but indices stats not requested" | indicesメトリクス未指定でindex_metricが指定された場合 |

## 例外処理

| 例外条件 | HTTPステータス | レスポンス内容 |
|---------|---------------|---------------|
| 不明メトリクス指定 | 400 Bad Request | unrecognizedエラーメッセージ |
| _allと個別メトリクス混在 | 400 Bad Request | IllegalArgumentException |
| インデックスメトリクス不整合 | 400 Bad Request | IllegalArgumentException |

## 備考

- `METRICS` マップと `FLAGS` マップで利用可能なメトリクスが静的に定義されている
- `canTripCircuitBreaker()` が `false` を返すため、サーキットブレーカーをトリップしない
- `level` パラメータにより、統計の集約粒度を制御できる（ノードレベル、インデックスレベル、シャードレベル）
- `caches` メトリクスが指定された場合、`CacheType` に基づくキャッシュ別統計が返される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | NodesStatsRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/stats/NodesStatsRequest.java` | リクエスト構造。`Metric` enum |
| 1-2 | CommonStatsFlags.java | `server/src/main/java/org/opensearch/action/admin/indices/stats/CommonStatsFlags.java` | インデックスメトリクスフラグ。`Flag` enum |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestNodesStatsAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestNodesStatsAction.java` | ルート定義（行67-78）、METRICS/FLAGSマップ（行80-99）、`prepareRequest()`（行107-238） |

**主要処理フロー**:
1. **行80-89**: `METRICS` マップで利用可能なメトリクスとハンドラを定義
2. **行91-99**: `FLAGS` マップでインデックスメトリクスフラグを定義
3. **行108-109**: nodeIdとmetricを解析
4. **行114-126**: `_all` メトリクスの処理
5. **行136-148**: 個別メトリクスの処理とバリデーション
6. **行155-207**: インデックスメトリクス・キャッシュメトリクスの処理
7. **行210-236**: フィールドフィルタ、レベル設定の適用

#### Step 3: Transport層の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportNodesStatsAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/stats/TransportNodesStatsAction.java` | 各ノードへの統計収集リクエスト転送 |

### プログラム呼び出し階層図

```
RestNodesStatsAction.prepareRequest()
    |
    +-- NodesStatsRequest(nodesIds)
    |       +-- METRICS handlers (metric -> request.addMetric())
    |       +-- FLAGS handlers (index_metric -> flags.set())
    |       +-- CommonStatsFlags configuration
    |
    +-- NodeClient.admin().cluster().nodesStats()
            |
            +-- TransportNodesStatsAction
                    +-- NodeService.stats() [on each node]
                    +-- NodesStatsResponse [aggregated]
```

### データフロー図

```
[入力]                        [処理]                             [出力]

GET request              --> RestNodesStatsAction              --> NodesStatsRequest
  nodeId (opt)               .prepareRequest()
  metric (opt)               METRICS/FLAGS解析
  index_metric (opt)         CommonStatsFlags構築
  query params

                         --> TransportNodesStatsAction         --> NodesStatsResponse
                             [各ノードに分散実行]                    { _nodes, cluster_name,
                             NodeService.stats()                     nodes: { ... } }
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestNodesStatsAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestNodesStatsAction.java` | ソース | RESTエンドポイント定義・メトリクス解析 |
| NodesStatsRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/stats/NodesStatsRequest.java` | ソース | リクエストオブジェクト |
| NodesStatsResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/stats/NodesStatsResponse.java` | ソース | レスポンスオブジェクト |
| TransportNodesStatsAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/stats/TransportNodesStatsAction.java` | ソース | Transport層ロジック |
| CommonStatsFlags.java | `server/src/main/java/org/opensearch/action/admin/indices/stats/CommonStatsFlags.java` | ソース | インデックスメトリクスフラグ |
| nodes.stats.json | `rest-api-spec/src/main/resources/rest-api-spec/api/nodes.stats.json` | 設定 | REST APIスペック定義 |
