# 画面設計書 112-タスク一覧

## 概要

本ドキュメントは、OpenSearchのタスク一覧API（`GET /_tasks`）の画面設計書である。本APIは、クラスタ内で現在実行中のタスクの一覧を返す。

### 本画面の処理概要

本APIは、OpenSearchクラスタ内の全ノードまたは指定ノードで実行中のタスクを一覧表示するREST APIエンドポイントである。

**業務上の目的・背景**：長時間実行されるタスク（reindex、delete_by_query、update_by_query等）の進捗監視や、クラスタのリソース使用状況の把握のためにこのAPIが必要である。実行中タスクの確認により、パフォーマンス問題の原因調査や、不要なタスクのキャンセル判断に利用される。

**画面へのアクセス方法**：HTTPクライアント（curl等）から `GET /_tasks` にリクエストを送信する。各種フィルタリングパラメータで結果を絞り込むことができる。

**主要な操作・処理内容**：
1. クライアントからGETリクエストを受信し、フィルタリングパラメータをパースする
2. 指定されたノード（または全ノード）に対してタスク情報を収集する
3. group_byパラメータに応じて結果をグルーピング（nodes/parents/none）する
4. JSON形式でレスポンスを返す

**画面遷移**：タスク一覧で確認したタスクIDを用いて、タスク取得API（`GET /_tasks/{task_id}`）で詳細を確認したり、タスクキャンセルAPI（`POST /_tasks/{task_id}/_cancel`）でキャンセルしたりする。

**権限による表示制御**：クラスタ管理権限が必要。ノードフィルタリングにより閲覧対象を制限可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 51 | タスク管理 | 主機能 | クラスタ内で実行中のタスク一覧を返す処理 |

## 画面種別

一覧（タスク情報一覧表示）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_tasks` | 実行中タスクの一覧を返す |

## 入出力項目

### クエリパラメータ

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|-----|------|-----------|------|
| nodes | list | いいえ | - | カンマ区切りのノードIDまたは名前。`_local`でローカルノードのみ |
| actions | list | いいえ | - | カンマ区切りのアクション名フィルタ |
| detailed | boolean | いいえ | false | 詳細なタスク情報を返すかどうか |
| parent_task_id | string | いいえ | - | 指定した親タスクIDのサブタスクのみ返す（node_id:task_number形式）。-1で全タスク |
| wait_for_completion | boolean | いいえ | false | マッチするタスクの完了を待つかどうか |
| group_by | enum | いいえ | nodes | グルーピング方法（nodes/parents/none） |
| timeout | time | いいえ | - | 明示的な操作タイムアウト |

## 表示項目

### レスポンス（group_by=nodes の場合）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| nodes | object | ノードID別のタスク情報 |
| nodes.{node_id}.name | string | ノード名 |
| nodes.{node_id}.transport_address | string | トランスポートアドレス |
| nodes.{node_id}.host | string | ホスト名 |
| nodes.{node_id}.ip | string | IPアドレス |
| nodes.{node_id}.tasks | object | タスクID別のタスク情報 |
| nodes.{node_id}.tasks.{task_id}.node | string | タスク実行ノードID |
| nodes.{node_id}.tasks.{task_id}.id | long | タスクID |
| nodes.{node_id}.tasks.{task_id}.type | string | タスクタイプ |
| nodes.{node_id}.tasks.{task_id}.action | string | タスクアクション名 |
| nodes.{node_id}.tasks.{task_id}.start_time_in_millis | long | 開始時刻（ミリ秒） |
| nodes.{node_id}.tasks.{task_id}.running_time_in_nanos | long | 実行時間（ナノ秒） |
| nodes.{node_id}.tasks.{task_id}.cancellable | boolean | キャンセル可能か |

## イベント仕様

### 1-タスク一覧取得リクエスト

1. クライアントがGETリクエストを送信する
2. `RestListTasksAction.prepareRequest`がリクエストをパースし、`ListTasksRequest`を生成する（行番号84-88）
3. `generateListTasksRequest`で各パラメータを設定する（行番号90-106）
4. `listTasksResponseListener`でgroup_byに応じたレスポンスフォーマットを決定する（行番号111-141）
5. ノード別/親子別/フラットのいずれかの形式でJSON結果を返す

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| タスク一覧取得 | なし | SELECT（インメモリ） | 各ノードのTaskManagerからタスク情報を収集 |

### テーブル別更新項目詳細

本APIはデータベースを使用しない。各ノードのインメモリTaskManagerから実行中タスク情報を収集する。

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 条件 |
|-------------|------|----------|------|
| - | 成功 | HTTP 200 OK + タスク一覧 | 正常取得完了 |
| - | エラー | "[group_by] must be one of [nodes], [parents] or [none] but was [{value}]" | 不正なgroup_by値 |

## 例外処理

| 例外条件 | HTTPステータス | 処理内容 |
|---------|--------------|---------|
| 不正なgroup_by値 | 400 | IllegalArgumentExceptionがスローされる |
| ノード通信タイムアウト | 200 | 部分的な結果が返される |

## 備考

- 本APIの安定性は「experimental」であり、将来のバージョンで変更される可能性がある
- CircuitBreakerをトリップしない設計（`canTripCircuitBreaker`が`false`を返す）
- `wait_for_completion=true`の場合、マッチするタスクが完了するまでリクエストがブロックされる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | tasks.list.json | `rest-api-spec/src/main/resources/rest-api-spec/api/tasks.list.json` | APIのURL、パラメータ定義を確認 |
| 1-2 | ListTasksRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/list/ListTasksRequest.java` | リクエストの構造 |
| 1-3 | ListTasksResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/list/ListTasksResponse.java` | レスポンスの構造とグルーピング方法 |

**読解のコツ**: `ListTasksResponse`には`toXContentGroupedByNode`と`toXContentGroupedByParents`の2つのシリアライズ方法がある点に注意。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestListTasksAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestListTasksAction.java` | RESTリクエストの受付とパラメータ解析 |

**主要処理フロー**:
1. **行番号75**: ルート定義（GET /_tasks）
2. **行番号84-88**: リクエストパース処理とlistTasks呼び出し
3. **行番号90-106**: `generateListTasksRequest` - 全パラメータの設定
4. **行番号111-141**: `listTasksResponseListener` - group_byに応じたレスポンスリスナー生成

#### Step 3: Transport層の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportListTasksAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/list/TransportListTasksAction.java` | タスク情報の収集処理 |
| 3-2 | TaskManager.java | `server/src/main/java/org/opensearch/tasks/TaskManager.java` | タスクの登録・管理メカニズム |

### プログラム呼び出し階層図

```
RestListTasksAction.prepareRequest (行番号84)
    |
    +-- generateListTasksRequest (行番号90) -- パラメータ解析
    |
    +-- client.admin().cluster().listTasks (行番号87)
    |       |
    |       +-- TransportListTasksAction.execute
    |               |
    |               +-- TaskManager.getTasks -- 各ノードのタスク収集
    |
    +-- listTasksResponseListener (行番号87)
            |
            +-- group_by=nodes: toXContentGroupedByNode (行番号121)
            +-- group_by=parents: toXContentGroupedByParents (行番号131)
            +-- group_by=none: RestToXContentListener (行番号137)
```

### データフロー図

```
[入力]                   [処理]                         [出力]

GET /_tasks         RestListTasksAction              JSON レスポンス
  nodes (query)  ----->  generateListTasksRequest      nodes別タスク or
  actions (query)        |                             parents別タスク or
  detailed (query)       v                             フラットリスト
  group_by (query)  TransportListTasksAction
                         |
                         v (各ノード)
                    TaskManager.getTasks -------> タスク情報集約
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| tasks.list.json | `rest-api-spec/src/main/resources/rest-api-spec/api/tasks.list.json` | API定義 | REST APIスペック定義 |
| RestListTasksAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestListTasksAction.java` | ソース | RESTリクエストハンドラ |
| TransportListTasksAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/list/TransportListTasksAction.java` | ソース | Transport層のタスク一覧処理 |
| ListTasksRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/list/ListTasksRequest.java` | ソース | リクエストモデル |
| ListTasksResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/list/ListTasksResponse.java` | ソース | レスポンスモデル |
| TaskManager.java | `server/src/main/java/org/opensearch/tasks/TaskManager.java` | ソース | タスク管理 |
| TaskInfo.java | `libs/core/src/main/java/org/opensearch/core/tasks/TaskInfo.java` | ソース | タスク情報モデル |
