# 画面設計書 113-タスク取得

## 概要

本ドキュメントは、OpenSearchのタスク取得API（`GET /_tasks/{task_id}`）の画面設計書である。本APIは、指定されたタスクIDのタスク情報を返す。

### 本画面の処理概要

本APIは、特定のタスクIDを指定してそのタスクの詳細情報を取得するREST APIエンドポイントである。

**業務上の目的・背景**：reindexやdelete_by_queryなどの長時間実行タスクの進捗を個別に監視する必要がある場合にこのAPIが使用される。タスク一覧APIで全体を確認した後、特定のタスクに絞った詳細情報を取得する運用フローで利用される。また、タスクが完了した場合でも`.tasks`インデックスに保存された結果を取得できる。

**画面へのアクセス方法**：HTTPクライアントから `GET /_tasks/{task_id}` にリクエストを送信する。task_idは`node_id:task_number`形式で指定する。

**主要な操作・処理内容**：
1. クライアントからGETリクエストを受信し、タスクIDをパースする
2. 指定タスクが実行中の場合はTaskManagerから情報を取得する
3. 指定タスクが完了済みの場合は`.tasks`インデックスから結果を取得する
4. `wait_for_completion`が`true`の場合はタスク完了まで待機する

**画面遷移**：タスク一覧API（`GET /_tasks`）で取得したタスクIDを本APIに渡して詳細を確認する。必要に応じてタスクキャンセルAPI（`POST /_tasks/{task_id}/_cancel`）を呼び出す。

**権限による表示制御**：クラスタ管理権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 51 | タスク管理 | 主機能 | 特定タスクの情報を返す処理 |

## 画面種別

詳細（タスク情報詳細表示）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_tasks/{task_id}` | 指定タスクの情報を返す |

## 入出力項目

### パスパラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| task_id | string | はい | タスクID（node_id:task_number形式） |

### クエリパラメータ

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|-----|------|-----------|------|
| wait_for_completion | boolean | いいえ | false | タスク完了を待つかどうか |
| timeout | time | いいえ | - | 明示的な操作タイムアウト |

## 表示項目

### レスポンス

| 項目名 | 型 | 説明 |
|--------|-----|------|
| completed | boolean | タスクが完了したかどうか |
| task.node | string | タスク実行ノードID |
| task.id | long | タスクID |
| task.type | string | タスクタイプ |
| task.action | string | タスクアクション名 |
| task.status | object | タスクの状態（アクション固有） |
| task.description | string | タスクの説明 |
| task.start_time_in_millis | long | 開始時刻（ミリ秒） |
| task.running_time_in_nanos | long | 実行時間（ナノ秒） |
| task.cancellable | boolean | キャンセル可能か |
| task.parent_task_id | string | 親タスクID |
| response | object | 完了時のレスポンス（完了済みタスクの場合） |
| error | object | エラー情報（エラー終了したタスクの場合） |

## イベント仕様

### 1-タスク取得リクエスト

1. クライアントがGETリクエストを送信する
2. `RestGetTaskAction.prepareRequest`がリクエストをパースし、`GetTaskRequest`を生成する（行番号67-76）
3. `TaskId`がパスパラメータから生成される（行番号68）
4. `wait_for_completion`と`timeout`が設定される（行番号69-70）
5. `client.admin().cluster().getTask`が呼び出される（行番号76）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| タスク取得 | .tasks インデックス | SELECT | 完了済みタスクの結果を取得（該当する場合） |
| タスク取得 | なし（インメモリ） | SELECT | 実行中タスクの情報をTaskManagerから取得 |

### テーブル別更新項目詳細

完了済みタスクの場合、`.tasks`システムインデックスからタスク結果が読み取られる。実行中タスクの場合はインメモリのTaskManagerから情報が取得される。

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 条件 |
|-------------|------|----------|------|
| - | 成功 | HTTP 200 OK + タスク情報 | 正常取得完了 |
| - | エラー | タスクが見つからない | 指定IDのタスクが存在しない場合 |

## 例外処理

| 例外条件 | HTTPステータス | 処理内容 |
|---------|--------------|---------|
| タスクIDが不正 | 400 | 不正なTaskId形式のエラー |
| タスクが見つからない | 404 | ResourceNotFoundException |
| タイムアウト | 408 | wait_for_completion時のタイムアウトエラー |

## 備考

- 本APIの安定性は「experimental」であり、将来のバージョンで変更される可能性がある
- `wait_for_completion=true`と`timeout`を組み合わせることで、タスク完了をポーリングなしで待機できる
- 完了済みタスクは`.tasks`インデックスに自動保存される（`store_result`が有効な場合）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | tasks.get.json | `rest-api-spec/src/main/resources/rest-api-spec/api/tasks.get.json` | APIのURL、パラメータ定義を確認 |
| 1-2 | GetTaskRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/get/GetTaskRequest.java` | リクエストの構造 |
| 1-3 | GetTaskResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/get/GetTaskResponse.java` | レスポンスの構造 |

**読解のコツ**: `TaskId`は`node_id:task_number`形式の文字列をパースする。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestGetTaskAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestGetTaskAction.java` | RESTリクエストの受付 |

**主要処理フロー**:
1. **行番号58**: ルート定義（GET /_tasks/{task_id}）
2. **行番号67-76**: リクエストパース処理 - TaskId生成、パラメータ設定、getTask呼び出し

#### Step 3: Transport層の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportGetTaskAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/get/TransportGetTaskAction.java` | タスク情報取得のロジック |

### プログラム呼び出し階層図

```
RestGetTaskAction.prepareRequest (行番号67)
    |
    +-- new TaskId(request.param("task_id")) (行番号68)
    +-- new GetTaskRequest() (行番号72)
    |
    +-- client.admin().cluster().getTask (行番号76)
            |
            +-- TransportGetTaskAction.execute
                    |
                    +-- TaskManager.getTask -- 実行中タスク検索
                    +-- .tasks インデックス検索 -- 完了済みタスク検索
```

### データフロー図

```
[入力]                    [処理]                        [出力]

GET /_tasks/{id}     RestGetTaskAction              JSON レスポンス
  task_id (path)  ----->  パラメータ解析                completed
  wait_for (query)       |                            task (タスク情報)
  timeout (query)        v                            response / error
                   TransportGetTaskAction
                         |
                   +-----+-----+
                   |           |
                   v           v
             TaskManager   .tasks index
             (実行中)      (完了済み)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| tasks.get.json | `rest-api-spec/src/main/resources/rest-api-spec/api/tasks.get.json` | API定義 | REST APIスペック定義 |
| RestGetTaskAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestGetTaskAction.java` | ソース | RESTリクエストハンドラ |
| TransportGetTaskAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/get/TransportGetTaskAction.java` | ソース | Transport層のタスク取得処理 |
| GetTaskRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/get/GetTaskRequest.java` | ソース | リクエストモデル |
| GetTaskResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/get/GetTaskResponse.java` | ソース | レスポンスモデル |
| TaskManager.java | `server/src/main/java/org/opensearch/tasks/TaskManager.java` | ソース | タスク管理 |
