# 画面設計書 114-タスクキャンセル

## 概要

本ドキュメントは、OpenSearchのタスクキャンセルAPI（`POST /_tasks/{task_id}/_cancel`）の画面設計書である。本APIは、実行中のタスクをキャンセルする。

### 本画面の処理概要

本APIは、クラスタ内で実行中のタスクに対してキャンセルリクエストを送信するREST APIエンドポイントである。

**業務上の目的・背景**：長時間実行されるタスク（reindex、delete_by_query、update_by_query等）がクラスタのパフォーマンスに悪影響を与えている場合や、誤って開始されたタスクを停止する必要がある場合にこのAPIが使用される。管理者がリソース管理の一環としてタスクを制御できるようにするために必要である。

**画面へのアクセス方法**：HTTPクライアントから `POST /_tasks/{task_id}/_cancel` または `POST /_tasks/_cancel` にリクエストを送信する。特定タスクIDの指定や、ノード・アクション名によるフィルタリングが可能。

**主要な操作・処理内容**：
1. クライアントからPOSTリクエストを受信し、キャンセル対象のパラメータをパースする
2. タスクIDまたはフィルタ条件に一致するタスクに対してキャンセル要求を発行する
3. キャンセル要求が各ノードに伝搬される
4. タスクのキャンセル結果を集約してレスポンスを返す

**画面遷移**：タスク一覧API（`GET /_tasks`）またはタスク取得API（`GET /_tasks/{task_id}`）でタスクを確認した後、本APIでキャンセルする。キャンセル後はタスク取得APIで完了状態を確認する。

**権限による表示制御**：クラスタ管理権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 51 | タスク管理 | 主機能 | 実行中タスクをキャンセルする処理 |

## 画面種別

実行（タスクキャンセル操作）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| POST | `/_tasks/_cancel` | 条件に一致する全タスクをキャンセル |
| POST | `/_tasks/{task_id}/_cancel` | 指定タスクをキャンセル |

## 入出力項目

### パスパラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| task_id | string | いいえ | キャンセル対象のタスクID（node_id:task_number形式） |

### クエリパラメータ

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|-----|------|-----------|------|
| nodes | list | いいえ | - | カンマ区切りのノードIDまたは名前 |
| actions | list | いいえ | - | カンマ区切りのアクション名フィルタ |
| parent_task_id | string | いいえ | - | 親タスクIDフィルタ（node_id:task_number形式）。-1で全タスク |
| wait_for_completion | boolean | いいえ | false | キャンセルと子孫タスクの完了を待つかどうか |

## 表示項目

### レスポンス

| 項目名 | 型 | 説明 |
|--------|-----|------|
| nodes | object | ノードID別のキャンセル結果（group_by=nodesの場合） |
| node_failures | array | ノード通信失敗情報 |
| task_failures | array | タスクキャンセル失敗情報 |

## イベント仕様

### 1-タスクキャンセルリクエスト

1. クライアントがPOSTリクエストを送信する
2. `RestCancelTasksAction.prepareRequest`がリクエストをパースし、`CancelTasksRequest`を生成する（行番号75-91）
3. ノードID、タスクID、アクション名、親タスクIDのフィルタを設定する（行番号76-87）
4. `client.admin().cluster().cancelTasks`が呼び出される（行番号88-90）
5. `listTasksResponseListener`を再利用してレスポンスをフォーマットする（行番号90）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| タスクキャンセル | なし（インメモリ） | UPDATE | TaskManagerのタスク状態をキャンセルに変更 |

### テーブル別更新項目詳細

本APIはデータベースを直接更新しない。各ノードのインメモリTaskManagerに対してキャンセルフラグを設定する。タスクの実際の停止はタスク実装側の協調的キャンセルメカニズムに依存する。

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 条件 |
|-------------|------|----------|------|
| - | 成功 | HTTP 200 OK + キャンセル結果 | 正常にキャンセル要求完了 |
| - | エラー | タスクが見つからない | 指定IDのタスクが存在しない場合 |

## 例外処理

| 例外条件 | HTTPステータス | 処理内容 |
|---------|--------------|---------|
| タスクIDが不正 | 400 | 不正なTaskId形式のエラー |
| タスクがキャンセル不可 | 400 | キャンセルをサポートしないタスクの場合 |
| ノード通信エラー | 200 | node_failuresに含まれる |

## 備考

- タスクのキャンセルは「協調的」（cooperative）であり、即座に停止されるとは限らない
- CircuitBreakerをトリップしない設計（`canTripCircuitBreaker`が`false`を返す）
- `RestListTasksAction.listTasksResponseListener`を再利用しており、group_byパラメータもサポートする
- 本APIの安定性は「experimental」であり、将来のバージョンで変更される可能性がある

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | tasks.cancel.json | `rest-api-spec/src/main/resources/rest-api-spec/api/tasks.cancel.json` | APIのURL、パラメータ定義を確認 |
| 1-2 | CancelTasksRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/cancel/CancelTasksRequest.java` | リクエストの構造 |
| 1-3 | CancelTasksResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/cancel/CancelTasksResponse.java` | レスポンスの構造 |

**読解のコツ**: `CancelTasksResponse`は`ListTasksResponse`を継承しており、同じフォーマットで結果が返される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestCancelTasksAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestCancelTasksAction.java` | RESTリクエストの受付とパラメータ解析 |

**主要処理フロー**:
1. **行番号71**: ルート定義（POST /_tasks/_cancel, POST /_tasks/{task_id}/_cancel）
2. **行番号75-91**: リクエストパース処理 - フィルタ条件の設定とcancelTasks呼び出し
3. **行番号90**: `listTasksResponseListener`の再利用

#### Step 3: Transport層の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportCancelTasksAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/cancel/TransportCancelTasksAction.java` | キャンセル処理のロジック |

### プログラム呼び出し階層図

```
RestCancelTasksAction.prepareRequest (行番号75)
    |
    +-- new CancelTasksRequest() (行番号82)
    +-- パラメータ設定 (行番号83-87)
    |
    +-- client.admin().cluster().cancelTasks (行番号88)
    |       |
    |       +-- TransportCancelTasksAction.execute
    |               |
    |               +-- TaskManager.cancelTaskAndDescendants
    |
    +-- listTasksResponseListener (行番号90) -- RestListTasksActionから再利用
```

### データフロー図

```
[入力]                         [処理]                          [出力]

POST /_tasks/{id}/_cancel  RestCancelTasksAction          JSON レスポンス
  task_id (path)   -------->  CancelTasksRequest生成        nodes (キャンセル結果)
  nodes (query)               |                            node_failures
  actions (query)             v                            task_failures
  parent_task_id     TransportCancelTasksAction
                              |
                              v (各ノード)
                        TaskManager.cancel --------> キャンセルフラグ設定
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| tasks.cancel.json | `rest-api-spec/src/main/resources/rest-api-spec/api/tasks.cancel.json` | API定義 | REST APIスペック定義 |
| RestCancelTasksAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestCancelTasksAction.java` | ソース | RESTリクエストハンドラ |
| TransportCancelTasksAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/cancel/TransportCancelTasksAction.java` | ソース | Transport層のキャンセル処理 |
| CancelTasksRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/cancel/CancelTasksRequest.java` | ソース | リクエストモデル |
| CancelTasksResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/cancel/CancelTasksResponse.java` | ソース | レスポンスモデル |
| RestListTasksAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestListTasksAction.java` | ソース | レスポンスリスナーの再利用元 |
| TaskManager.java | `server/src/main/java/org/opensearch/tasks/TaskManager.java` | ソース | タスク管理 |
