# 画面設計書 115-リポジトリ作成

## 概要

本ドキュメントは、OpenSearchのスナップショットリポジトリ作成API（`PUT /_snapshot/{repository}`）の画面設計書である。本APIは、スナップショットを保存するリポジトリを作成する。

### 本画面の処理概要

本APIは、スナップショットの保存先となるリポジトリを登録するREST APIエンドポイントである。

**業務上の目的・背景**：OpenSearchのデータバックアップ・リストア機能の基盤として、スナップショットリポジトリの作成が必要である。リポジトリは共有ファイルシステムやAmazon S3などのオブジェクトストレージを指定でき、クラスタ全体のデータ保護戦略の第一歩となる。災害復旧（DR）計画やデータマイグレーションにおいて重要な役割を果たす。

**画面へのアクセス方法**：HTTPクライアントから `PUT /_snapshot/{repository}` または `POST /_snapshot/{repository}` にリクエストを送信する。リクエストボディにリポジトリのタイプと設定を含める。

**主要な操作・処理内容**：
1. クライアントからPUT/POSTリクエストを受信し、リポジトリ名と定義をパースする
2. リポジトリの定義（type、settings）をバリデーションする
3. クラスタ状態にリポジトリメタデータを登録する
4. verify=trueの場合、全ノードでリポジトリへのアクセスを検証する
5. 登録結果をレスポンスとして返す

**画面遷移**：リポジトリ作成後、スナップショット作成API（`PUT /_snapshot/{repository}/{snapshot}`）でバックアップを取得する。リポジトリ検証API（`POST /_snapshot/{repository}/_verify`）で接続確認を行う。リポジトリ取得API（`GET /_snapshot/{repository}`）で設定を確認する。

**権限による表示制御**：クラスタ管理権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 65 | リポジトリ管理 | 主機能 | スナップショットリポジトリを作成する処理 |

## 画面種別

登録（リポジトリ作成）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| PUT | `/_snapshot/{repository}` | リポジトリを作成 |
| POST | `/_snapshot/{repository}` | リポジトリを作成 |

## 入出力項目

### パスパラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| repository | string | はい | リポジトリ名 |

### クエリパラメータ

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|-----|------|-----------|------|
| cluster_manager_timeout | time | いいえ | - | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | いいえ | - | （非推奨）cluster_manager_timeoutを使用 |
| timeout | time | いいえ | - | 明示的な操作タイムアウト |
| verify | boolean | いいえ | true | 作成後にリポジトリを検証するかどうか |

### リクエストボディ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| type | string | はい | リポジトリタイプ（fs, s3等） |
| settings | object | はい | リポジトリ設定（タイプにより異なる） |
| settings.location | string | 条件付き | fsタイプの場合の保存先パス |
| settings.compress | boolean | いいえ | スナップショットの圧縮有無 |

## 表示項目

### レスポンス

| 項目名 | 型 | 説明 |
|--------|-----|------|
| acknowledged | boolean | リクエストが承認されたかどうか |

## イベント仕様

### 1-リポジトリ作成リクエスト

1. クライアントがPUT/POSTリクエストを送信する
2. `RestPutRepositoryAction.prepareRequest`がリクエストをパースし、`PutRepositoryRequest`を生成する（行番号72-83）
3. リポジトリ名の設定（行番号73）
4. リクエストボディのパース（行番号74-76）
5. verify、タイムアウト値の設定（行番号77-82）
6. `client.admin().cluster().putRepository`が呼び出される（行番号83）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| リポジトリ作成 | ClusterState（メタデータ） | INSERT | クラスタ状態にリポジトリメタデータを追加 |

### テーブル別更新項目詳細

#### ClusterState メタデータ

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|----------------|------|
| INSERT | RepositoryMetadata | type, settings | クラスタ状態のリポジトリ一覧に追加 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 条件 |
|-------------|------|----------|------|
| - | 成功 | HTTP 200 OK + {"acknowledged": true} | 正常に作成完了 |
| - | エラー | リポジトリ検証失敗 | verify=trueでノードがアクセスできない場合 |
| - | エラー | 不正なリポジトリタイプ | サポートされないタイプが指定された場合 |

## 例外処理

| 例外条件 | HTTPステータス | 処理内容 |
|---------|--------------|---------|
| リポジトリ名が空 | 400 | バリデーションエラー |
| リクエストボディが空 | 400 | ボディ必須エラー |
| リポジトリタイプが不正 | 400 | サポートされないタイプ |
| 検証失敗（verify=true） | 500 | リポジトリアクセスエラー |
| クラスタマネージャ接続タイムアウト | 500 | タイムアウトエラー |

## 備考

- `master_timeout`パラメータはv2.0.0で非推奨となり、`cluster_manager_timeout`に置き換えられた
- リポジトリは同名で再作成すると上書きされる
- verify=trueの場合、全ノードがリポジトリにアクセスできることが検証される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | snapshot.create_repository.json | `rest-api-spec/src/main/resources/rest-api-spec/api/snapshot.create_repository.json` | APIのURL、パラメータ、ボディの定義を確認 |
| 1-2 | PutRepositoryRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/repositories/put/PutRepositoryRequest.java` | リクエストの構造 |

**読解のコツ**: リクエストボディは`source(Map)`メソッドでパースされ、`type`と`settings`が抽出される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestPutRepositoryAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestPutRepositoryAction.java` | RESTリクエストの受付 |

**主要処理フロー**:
1. **行番号63**: ルート定義（POST/PUT /_snapshot/{repository}）
2. **行番号72-83**: リクエストパース処理とputRepository呼び出し

#### Step 3: Transport層の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportPutRepositoryAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/repositories/put/TransportPutRepositoryAction.java` | リポジトリ登録処理 |
| 3-2 | RepositoriesService.java | `server/src/main/java/org/opensearch/repositories/RepositoriesService.java` | リポジトリ管理サービス |

### プログラム呼び出し階層図

```
RestPutRepositoryAction.prepareRequest (行番号72)
    |
    +-- putRepositoryRequest(repository) (行番号73)
    +-- source(parser.mapOrdered()) (行番号74-76) -- ボディパース
    +-- verify/timeout設定 (行番号77-82)
    |
    +-- client.admin().cluster().putRepository (行番号83)
            |
            +-- TransportPutRepositoryAction.execute
                    |
                    +-- RepositoriesService.registerRepository
                            |
                            +-- ClusterState更新
                            +-- Repository.verify（verify=trueの場合）
```

### データフロー図

```
[入力]                       [処理]                           [出力]

PUT /_snapshot/{repo}    RestPutRepositoryAction          JSON レスポンス
  repository (path) ----->  PutRepositoryRequest生成        acknowledged: true/false
  type (body)               |
  settings (body)           v
  verify (query)      TransportPutRepositoryAction
                            |
                            v
                      RepositoriesService
                            |
                      +-----+-----+
                      |           |
                      v           v
                ClusterState   Repository.verify
                  更新         （verify=trueの場合）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| snapshot.create_repository.json | `rest-api-spec/src/main/resources/rest-api-spec/api/snapshot.create_repository.json` | API定義 | REST APIスペック定義 |
| RestPutRepositoryAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestPutRepositoryAction.java` | ソース | RESTリクエストハンドラ |
| TransportPutRepositoryAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/repositories/put/TransportPutRepositoryAction.java` | ソース | Transport層の登録処理 |
| PutRepositoryRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/repositories/put/PutRepositoryRequest.java` | ソース | リクエストモデル |
| RepositoriesService.java | `server/src/main/java/org/opensearch/repositories/RepositoriesService.java` | ソース | リポジトリ管理サービス |
