# 画面設計書 116-リポジトリ取得

## 概要

本ドキュメントは、OpenSearchのスナップショットリポジトリ取得API（`GET /_snapshot/{repository}`）の画面設計書である。本APIは、登録済みのスナップショットリポジトリの情報を返す。

### 本画面の処理概要

本APIは、クラスタに登録されたスナップショットリポジトリの設定情報を取得するREST APIエンドポイントである。

**業務上の目的・背景**：スナップショットの作成・リストア操作の前に、リポジトリの設定状態を確認する必要がある。リポジトリのタイプ、保存先、圧縮設定などを確認し、バックアップ運用の正確性を担保するためにこのAPIが使用される。また、リポジトリ設定の棚卸しや監査にも利用される。

**画面へのアクセス方法**：HTTPクライアントから `GET /_snapshot/{repository}` または `GET /_snapshot` にリクエストを送信する。リポジトリ名を省略すると全リポジトリの情報が返される。

**主要な操作・処理内容**：
1. クライアントからGETリクエストを受信し、リポジトリ名をパースする
2. クラスタ状態からリポジトリメタデータを取得する
3. SettingsFilterにより機密設定を除外する
4. リポジトリ情報をJSON形式で返す

**画面遷移**：リポジトリ取得で確認した後、スナップショット作成API（`PUT /_snapshot/{repository}/{snapshot}`）でバックアップを取得する。リポジトリ削除API（`DELETE /_snapshot/{repository}`）で不要なリポジトリを削除する。

**権限による表示制御**：クラスタ管理権限が必要。SettingsFilterにより機密設定値がマスクされる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 65 | リポジトリ管理 | 主機能 | スナップショットリポジトリの情報を返す処理 |

## 画面種別

一覧 / 詳細（リポジトリ情報表示）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_snapshot` | 全リポジトリ情報を返す |
| GET | `/_snapshot/{repository}` | 指定リポジトリの情報を返す |

## 入出力項目

### パスパラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| repository | list | いいえ | カンマ区切りのリポジトリ名。省略時は全リポジトリ |

### クエリパラメータ

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|-----|------|-----------|------|
| cluster_manager_timeout | time | いいえ | - | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | いいえ | - | （非推奨）cluster_manager_timeoutを使用 |
| local | boolean | いいえ | false | ローカルノードの情報のみ返すかどうか |

## 表示項目

### レスポンス

| 項目名 | 型 | 説明 |
|--------|-----|------|
| {repository_name}.type | string | リポジトリタイプ（fs, s3等） |
| {repository_name}.settings | object | リポジトリ設定 |
| {repository_name}.settings.location | string | 保存先パス（fsタイプの場合） |
| {repository_name}.settings.compress | string | 圧縮設定 |

## イベント仕様

### 1-リポジトリ取得リクエスト

1. クライアントがGETリクエストを送信する
2. `RestGetRepositoriesAction.prepareRequest`がリクエストをパースし、`GetRepositoriesRequest`を生成する（行番号80-89）
3. リポジトリ名の配列を取得する（行番号81-82）
4. `local`フラグとタイムアウト値を設定する（行番号83-87）
5. `settingsFilter.addFilterSettingParams`で機密設定のフィルタを適用する（行番号88）
6. `client.admin().cluster().getRepositories`が呼び出される（行番号89）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| リポジトリ取得 | ClusterState（メタデータ） | SELECT | クラスタ状態からリポジトリメタデータを取得 |

### テーブル別更新項目詳細

本APIはデータの読み取りのみを行う。クラスタ状態のリポジトリメタデータを参照する。

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 条件 |
|-------------|------|----------|------|
| - | 成功 | HTTP 200 OK + リポジトリ情報 | 正常取得完了 |
| - | エラー | リポジトリが見つからない | 指定名のリポジトリが存在しない場合 |

## 例外処理

| 例外条件 | HTTPステータス | 処理内容 |
|---------|--------------|---------|
| リポジトリが存在しない | 404 | RepositoryMissingException |
| クラスタマネージャ接続タイムアウト | 500 | タイムアウトエラー |

## 備考

- `master_timeout`パラメータはv2.0.0で非推奨となり、`cluster_manager_timeout`に置き換えられた
- `local=true`の場合、クラスタマネージャに問い合わせずローカルのクラスタ状態から情報を取得する
- `responseParams`で`Settings.FORMAT_PARAMS`を返し、設定のフォーマットパラメータをサポートする

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | snapshot.get_repository.json | `rest-api-spec/src/main/resources/rest-api-spec/api/snapshot.get_repository.json` | APIのURL、パラメータ定義を確認 |
| 1-2 | GetRepositoriesRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/repositories/get/GetRepositoriesRequest.java` | リクエストの構造 |
| 1-3 | GetRepositoriesResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/repositories/get/GetRepositoriesResponse.java` | レスポンスの構造 |

**読解のコツ**: `SettingsFilter`がレスポンス内の機密設定値を除外する点に注意。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestGetRepositoriesAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestGetRepositoriesAction.java` | RESTリクエストの受付 |

**主要処理フロー**:
1. **行番号76**: ルート定義（GET /_snapshot, GET /_snapshot/{repository}）
2. **行番号80-89**: リクエストパース処理とgetRepositories呼び出し
3. **行番号88**: SettingsFilterによるフィルタ適用

#### Step 3: Transport層の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportGetRepositoriesAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/repositories/get/TransportGetRepositoriesAction.java` | リポジトリ情報取得処理 |

### プログラム呼び出し階層図

```
RestGetRepositoriesAction.prepareRequest (行番号80)
    |
    +-- getRepositoryRequest(repositories) (行番号82)
    +-- settingsFilter.addFilterSettingParams (行番号88)
    |
    +-- client.admin().cluster().getRepositories (行番号89)
            |
            +-- TransportGetRepositoriesAction.execute
                    |
                    +-- ClusterState.metadata().custom(RepositoriesMetadata.TYPE)
```

### データフロー図

```
[入力]                       [処理]                          [出力]

GET /_snapshot/{repo}    RestGetRepositoriesAction       JSON レスポンス
  repository (path) ----->  GetRepositoriesRequest生成    {repo}.type
  local (query)             |                            {repo}.settings
                            v
                      TransportGetRepositoriesAction
                            |
                            v
                      ClusterState.metadata
                            |
                            v
                      SettingsFilter -------> フィルタ済みレスポンス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| snapshot.get_repository.json | `rest-api-spec/src/main/resources/rest-api-spec/api/snapshot.get_repository.json` | API定義 | REST APIスペック定義 |
| RestGetRepositoriesAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestGetRepositoriesAction.java` | ソース | RESTリクエストハンドラ |
| TransportGetRepositoriesAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/repositories/get/TransportGetRepositoriesAction.java` | ソース | Transport層の取得処理 |
| GetRepositoriesRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/repositories/get/GetRepositoriesRequest.java` | ソース | リクエストモデル |
| GetRepositoriesResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/repositories/get/GetRepositoriesResponse.java` | ソース | レスポンスモデル |
| SettingsFilter.java | `server/src/main/java/org/opensearch/common/settings/SettingsFilter.java` | ソース | 設定フィルタリング |
