# 画面設計書 117-リポジトリ削除

## 概要

本ドキュメントは、OpenSearchのスナップショットリポジトリ削除API（`DELETE /_snapshot/{repository}`）の画面設計書である。本APIは、登録済みのスナップショットリポジトリを削除（登録解除）する。

### 本画面の処理概要

本APIは、クラスタからスナップショットリポジトリの登録を解除するREST APIエンドポイントである。

**業務上の目的・背景**：使用しなくなったリポジトリの登録を解除し、クラスタ状態をクリーンに保つために必要である。リポジトリの移行や、テスト用リポジトリの後片付けなどの運用シナリオで使用される。なお、リポジトリの削除（登録解除）は、リポジトリ内のスナップショットデータ自体を削除するものではない。

**画面へのアクセス方法**：HTTPクライアントから `DELETE /_snapshot/{repository}` にリクエストを送信する。ワイルドカード（`*`）パターンもサポートされる。

**主要な操作・処理内容**：
1. クライアントからDELETEリクエストを受信し、リポジトリ名をパースする
2. クラスタ状態からリポジトリメタデータを削除する
3. 削除結果をレスポンスとして返す

**画面遷移**：リポジトリ取得API（`GET /_snapshot/{repository}`）で現在の登録状態を確認した後、本APIで削除する。削除後はリポジトリ取得APIで削除が反映されたことを確認する。

**権限による表示制御**：クラスタ管理権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 65 | リポジトリ管理 | 主機能 | スナップショットリポジトリを削除する処理 |

## 画面種別

実行（リポジトリ削除）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| DELETE | `/_snapshot/{repository}` | リポジトリを削除（登録解除） |

## 入出力項目

### パスパラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| repository | list | はい | リポジトリ名。ワイルドカード（*）パターンをサポート |

### クエリパラメータ

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|-----|------|-----------|------|
| cluster_manager_timeout | time | いいえ | - | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | いいえ | - | （非推奨）cluster_manager_timeoutを使用 |
| timeout | time | いいえ | - | 明示的な操作タイムアウト |

## 表示項目

### レスポンス

| 項目名 | 型 | 説明 |
|--------|-----|------|
| acknowledged | boolean | リクエストが承認されたかどうか |

## イベント仕様

### 1-リポジトリ削除リクエスト

1. クライアントがDELETEリクエストを送信する
2. `RestDeleteRepositoryAction.prepareRequest`がリクエストをパースし、`DeleteRepositoryRequest`を生成する（行番号69-76）
3. リポジトリ名、タイムアウト値を設定する（行番号70-75）
4. `client.admin().cluster().deleteRepository`が呼び出される（行番号76）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| リポジトリ削除 | ClusterState（メタデータ） | DELETE | クラスタ状態からリポジトリメタデータを削除 |

### テーブル別更新項目詳細

#### ClusterState メタデータ

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|----------------|------|
| DELETE | RepositoryMetadata | リポジトリ名で特定 | スナップショットデータ自体は削除しない |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 条件 |
|-------------|------|----------|------|
| - | 成功 | HTTP 200 OK + {"acknowledged": true} | 正常に削除完了 |
| - | エラー | リポジトリが見つからない | 指定名のリポジトリが存在しない場合 |

## 例外処理

| 例外条件 | HTTPステータス | 処理内容 |
|---------|--------------|---------|
| リポジトリが存在しない | 404 | RepositoryMissingException |
| リポジトリ名が空 | 400 | バリデーションエラー |
| クラスタマネージャ接続タイムアウト | 500 | タイムアウトエラー |

## 備考

- リポジトリの削除はクラスタ状態からの登録解除であり、リモートストレージ上のスナップショットデータは削除されない
- `master_timeout`パラメータはv2.0.0で非推奨となり、`cluster_manager_timeout`に置き換えられた
- ワイルドカードパターンによる複数リポジトリの一括削除が可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | snapshot.delete_repository.json | `rest-api-spec/src/main/resources/rest-api-spec/api/snapshot.delete_repository.json` | APIのURL、パラメータ定義を確認 |
| 1-2 | DeleteRepositoryRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/repositories/delete/DeleteRepositoryRequest.java` | リクエストの構造 |

**読解のコツ**: repositoryパラメータはlist型であり、ワイルドカードもサポートされる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestDeleteRepositoryAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestDeleteRepositoryAction.java` | RESTリクエストの受付 |

**主要処理フロー**:
1. **行番号60**: ルート定義（DELETE /_snapshot/{repository}）
2. **行番号69-76**: リクエストパース処理とdeleteRepository呼び出し

#### Step 3: Transport層の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportDeleteRepositoryAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/repositories/delete/TransportDeleteRepositoryAction.java` | リポジトリ削除処理 |
| 3-2 | RepositoriesService.java | `server/src/main/java/org/opensearch/repositories/RepositoriesService.java` | リポジトリ管理サービス |

### プログラム呼び出し階層図

```
RestDeleteRepositoryAction.prepareRequest (行番号69)
    |
    +-- deleteRepositoryRequest(repository) (行番号70)
    +-- timeout/clusterManagerTimeout設定 (行番号71-75)
    |
    +-- client.admin().cluster().deleteRepository (行番号76)
            |
            +-- TransportDeleteRepositoryAction.execute
                    |
                    +-- RepositoriesService.unregisterRepository
                            |
                            +-- ClusterState メタデータ更新
```

### データフロー図

```
[入力]                          [処理]                           [出力]

DELETE /_snapshot/{repo}    RestDeleteRepositoryAction       JSON レスポンス
  repository (path) -------->  DeleteRepositoryRequest生成    acknowledged: true/false
  timeout (query)              |
                               v
                         TransportDeleteRepositoryAction
                               |
                               v
                         RepositoriesService.unregisterRepository
                               |
                               v
                         ClusterState メタデータ削除
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| snapshot.delete_repository.json | `rest-api-spec/src/main/resources/rest-api-spec/api/snapshot.delete_repository.json` | API定義 | REST APIスペック定義 |
| RestDeleteRepositoryAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestDeleteRepositoryAction.java` | ソース | RESTリクエストハンドラ |
| TransportDeleteRepositoryAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/repositories/delete/TransportDeleteRepositoryAction.java` | ソース | Transport層の削除処理 |
| DeleteRepositoryRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/repositories/delete/DeleteRepositoryRequest.java` | ソース | リクエストモデル |
| RepositoriesService.java | `server/src/main/java/org/opensearch/repositories/RepositoriesService.java` | ソース | リポジトリ管理サービス |
