# 画面設計書 118-リポジトリ検証

## 概要

本ドキュメントは、OpenSearchのスナップショットリポジトリ検証API（`POST /_snapshot/{repository}/_verify`）の画面設計書である。本APIは、登録済みリポジトリが全ノードからアクセス可能かを検証する。

### 本画面の処理概要

本APIは、クラスタ内の全ノードがスナップショットリポジトリに正しくアクセスできるかを検証するREST APIエンドポイントである。

**業務上の目的・背景**：スナップショット操作は全ノードがリポジトリにアクセスできる必要がある。リポジトリの作成後やネットワーク設定変更後に、アクセス可能性を事前検証することで、スナップショット作成時の失敗を防止する。本番環境でのバックアップ運用の信頼性を担保するために重要なAPIである。

**画面へのアクセス方法**：HTTPクライアントから `POST /_snapshot/{repository}/_verify` にリクエストを送信する。

**主要な操作・処理内容**：
1. クライアントからPOSTリクエストを受信し、リポジトリ名をパースする
2. クラスタ内の全ノードに対してリポジトリアクセス検証を実行する
3. 各ノードの検証結果を集約する
4. 検証結果をレスポンスとして返す

**画面遷移**：リポジトリ作成API（`PUT /_snapshot/{repository}`）の後に呼び出される。検証成功後にスナップショット作成API（`PUT /_snapshot/{repository}/{snapshot}`）を呼び出す。

**権限による表示制御**：クラスタ管理権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 65 | リポジトリ管理 | 主機能 | スナップショットリポジトリを検証する処理 |

## 画面種別

実行（リポジトリ検証）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| POST | `/_snapshot/{repository}/_verify` | リポジトリを検証 |

## 入出力項目

### パスパラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| repository | string | はい | リポジトリ名 |

### クエリパラメータ

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|-----|------|-----------|------|
| cluster_manager_timeout | time | いいえ | - | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | いいえ | - | （非推奨）cluster_manager_timeoutを使用 |
| timeout | time | いいえ | - | 明示的な操作タイムアウト |

## 表示項目

### レスポンス

| 項目名 | 型 | 説明 |
|--------|-----|------|
| nodes | object | 検証成功したノードの情報 |
| nodes.{node_id}.name | string | ノード名 |

## イベント仕様

### 1-リポジトリ検証リクエスト

1. クライアントがPOSTリクエストを送信する
2. `RestVerifyRepositoryAction.prepareRequest`がリクエストをパースし、`VerifyRepositoryRequest`を生成する（行番号69-76）
3. リポジトリ名、タイムアウト値を設定する（行番号70-75）
4. `client.admin().cluster().verifyRepository`が呼び出される（行番号76）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| リポジトリ検証 | なし | SELECT | リポジトリへの読み書きテストを実行 |

### テーブル別更新項目詳細

本APIはクラスタ状態を更新しない。各ノードがリポジトリストレージに対して検証用データの読み書きテストを行う。

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 条件 |
|-------------|------|----------|------|
| - | 成功 | HTTP 200 OK + 検証成功ノード一覧 | 全ノードで検証成功 |
| - | エラー | リポジトリが見つからない | 指定名のリポジトリが存在しない場合 |
| - | エラー | 検証失敗 | ノードがリポジトリにアクセスできない場合 |

## 例外処理

| 例外条件 | HTTPステータス | 処理内容 |
|---------|--------------|---------|
| リポジトリが存在しない | 404 | RepositoryMissingException |
| リポジトリアクセス不可 | 500 | RepositoryVerificationException |
| タイムアウト | 500 | タイムアウトエラー |

## 備考

- リポジトリ作成時に`verify=true`（デフォルト）とすると、作成時に自動的に検証が実行される
- `master_timeout`パラメータはv2.0.0で非推奨となり、`cluster_manager_timeout`に置き換えられた
- 検証では各ノードがリポジトリに小さなデータファイルを書き込み・読み取りすることでアクセスを確認する

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | snapshot.verify_repository.json | `rest-api-spec/src/main/resources/rest-api-spec/api/snapshot.verify_repository.json` | APIのURL、パラメータ定義を確認 |
| 1-2 | VerifyRepositoryRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/repositories/verify/VerifyRepositoryRequest.java` | リクエストの構造 |
| 1-3 | VerifyRepositoryResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/repositories/verify/VerifyRepositoryResponse.java` | レスポンスの構造 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestVerifyRepositoryAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestVerifyRepositoryAction.java` | RESTリクエストの受付 |

**主要処理フロー**:
1. **行番号60**: ルート定義（POST /_snapshot/{repository}/_verify）
2. **行番号69-76**: リクエストパース処理とverifyRepository呼び出し

#### Step 3: Transport層の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportVerifyRepositoryAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/repositories/verify/TransportVerifyRepositoryAction.java` | リポジトリ検証処理 |
| 3-2 | RepositoriesService.java | `server/src/main/java/org/opensearch/repositories/RepositoriesService.java` | リポジトリ管理サービス |

### プログラム呼び出し階層図

```
RestVerifyRepositoryAction.prepareRequest (行番号69)
    |
    +-- verifyRepositoryRequest(repository) (行番号70)
    +-- clusterManagerTimeout/timeout設定 (行番号71-75)
    |
    +-- client.admin().cluster().verifyRepository (行番号76)
            |
            +-- TransportVerifyRepositoryAction.execute
                    |
                    +-- RepositoriesService.verifyRepository
                            |
                            +-- 各ノードでリポジトリ読み書きテスト
```

### データフロー図

```
[入力]                             [処理]                          [出力]

POST /_snapshot/{repo}/_verify  RestVerifyRepositoryAction     JSON レスポンス
  repository (path) ---------->  VerifyRepositoryRequest生成    nodes (検証成功ノード)
  timeout (query)                |
                                 v
                           TransportVerifyRepositoryAction
                                 |
                                 v
                           RepositoriesService.verifyRepository
                                 |
                                 v (各ノード)
                           Repository読み書きテスト ----------> 結果集約
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| snapshot.verify_repository.json | `rest-api-spec/src/main/resources/rest-api-spec/api/snapshot.verify_repository.json` | API定義 | REST APIスペック定義 |
| RestVerifyRepositoryAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestVerifyRepositoryAction.java` | ソース | RESTリクエストハンドラ |
| TransportVerifyRepositoryAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/repositories/verify/TransportVerifyRepositoryAction.java` | ソース | Transport層の検証処理 |
| VerifyRepositoryRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/repositories/verify/VerifyRepositoryRequest.java` | ソース | リクエストモデル |
| VerifyRepositoryResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/repositories/verify/VerifyRepositoryResponse.java` | ソース | レスポンスモデル |
| RepositoriesService.java | `server/src/main/java/org/opensearch/repositories/RepositoriesService.java` | ソース | リポジトリ管理サービス |
