# 画面設計書 119-リポジトリクリーンアップ

## 概要

本ドキュメントは、OpenSearchのスナップショットリポジトリクリーンアップAPI（`POST /_snapshot/{repository}/_cleanup`）の画面設計書である。本APIは、リポジトリから古い不要データを削除する。

### 本画面の処理概要

本APIは、スナップショットリポジトリ内の不整合データや孤立したデータを検出・削除するREST APIエンドポイントである。

**業務上の目的・背景**：スナップショットの作成・削除を繰り返すと、リポジトリ内に孤立したデータ（どのスナップショットからも参照されないBLOBやインデックスファイル）が蓄積される場合がある。特にスナップショット操作が中断された場合に発生しやすい。クリーンアップにより、ストレージの無駄を削減し、リポジトリの整合性を維持することが目的である。

**画面へのアクセス方法**：HTTPクライアントから `POST /_snapshot/{repository}/_cleanup` にリクエストを送信する。

**主要な操作・処理内容**：
1. クライアントからPOSTリクエストを受信し、リポジトリ名をパースする
2. リポジトリ内のスナップショットメタデータと実際のデータファイルを比較する
3. どのスナップショットからも参照されない孤立ファイルを特定する
4. 孤立ファイルを削除する
5. クリーンアップ結果（削除バイト数等）をレスポンスとして返す

**画面遷移**：リポジトリ取得API（`GET /_snapshot/{repository}`）でリポジトリの状態を確認した後に呼び出す。定期的なメンテナンス作業の一環として実行される。

**権限による表示制御**：クラスタ管理権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 65 | リポジトリ管理 | 主機能 | リポジトリから古いデータを削除するクリーンアップ処理 |

## 画面種別

実行（リポジトリクリーンアップ）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| POST | `/_snapshot/{repository}/_cleanup` | リポジトリのクリーンアップを実行 |

## 入出力項目

### パスパラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| repository | string | はい | リポジトリ名 |

### クエリパラメータ

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|-----|------|-----------|------|
| cluster_manager_timeout | time | いいえ | - | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | いいえ | - | （非推奨）cluster_manager_timeoutを使用 |
| timeout | time | いいえ | - | 明示的な操作タイムアウト |

## 表示項目

### レスポンス

| 項目名 | 型 | 説明 |
|--------|-----|------|
| results.deleted_bytes | long | 削除されたデータのバイト数 |
| results.deleted_blobs | long | 削除されたBLOB数 |

## イベント仕様

### 1-リポジトリクリーンアップリクエスト

1. クライアントがPOSTリクエストを送信する
2. `RestCleanupRepositoryAction.prepareRequest`がリクエストをパースし、`CleanupRepositoryRequest`を生成する（行番号69-76）
3. リポジトリ名、タイムアウト値を設定する（行番号70-75）
4. `client.admin().cluster().cleanupRepository`が呼び出される（行番号76）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| リポジトリクリーンアップ | リポジトリストレージ | DELETE | 孤立データファイルの削除 |

### テーブル別更新項目詳細

本APIはクラスタ状態を更新しない。リポジトリストレージ（共有ファイルシステムやS3等）上の孤立データファイルを直接削除する。

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 条件 |
|-------------|------|----------|------|
| - | 成功 | HTTP 200 OK + クリーンアップ結果 | 正常にクリーンアップ完了 |
| - | エラー | リポジトリが見つからない | 指定名のリポジトリが存在しない場合 |

## 例外処理

| 例外条件 | HTTPステータス | 処理内容 |
|---------|--------------|---------|
| リポジトリが存在しない | 404 | RepositoryMissingException |
| リポジトリアクセス不可 | 500 | リポジトリI/Oエラー |
| タイムアウト | 500 | タイムアウトエラー |
| 他のスナップショット操作が進行中 | 500 | ConcurrentSnapshotExecutionException |

## 備考

- クリーンアップは排他的操作であり、他のスナップショット操作（作成、削除等）が進行中の場合は実行できない
- `master_timeout`パラメータはv2.0.0で非推奨となり、`cluster_manager_timeout`に置き換えられた
- 大規模リポジトリの場合、クリーンアップに時間がかかる可能性がある

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | snapshot.cleanup_repository.json | `rest-api-spec/src/main/resources/rest-api-spec/api/snapshot.cleanup_repository.json` | APIのURL、パラメータ定義を確認 |
| 1-2 | CleanupRepositoryRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/repositories/cleanup/CleanupRepositoryRequest.java` | リクエストの構造 |
| 1-3 | CleanupRepositoryResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/repositories/cleanup/CleanupRepositoryResponse.java` | レスポンスの構造 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestCleanupRepositoryAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestCleanupRepositoryAction.java` | RESTリクエストの受付 |

**主要処理フロー**:
1. **行番号60**: ルート定義（POST /_snapshot/{repository}/_cleanup）
2. **行番号69-76**: リクエストパース処理とcleanupRepository呼び出し

#### Step 3: Transport層の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportCleanupRepositoryAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/repositories/cleanup/TransportCleanupRepositoryAction.java` | クリーンアップ処理 |
| 3-2 | RepositoriesService.java | `server/src/main/java/org/opensearch/repositories/RepositoriesService.java` | リポジトリ管理サービス |
| 3-3 | BlobStoreRepository.java | `server/src/main/java/org/opensearch/repositories/blobstore/BlobStoreRepository.java` | BlobStoreリポジトリの実装 |

### プログラム呼び出し階層図

```
RestCleanupRepositoryAction.prepareRequest (行番号69)
    |
    +-- cleanupRepositoryRequest(repository) (行番号70)
    +-- timeout/clusterManagerTimeout設定 (行番号71-75)
    |
    +-- client.admin().cluster().cleanupRepository (行番号76)
            |
            +-- TransportCleanupRepositoryAction.execute
                    |
                    +-- RepositoriesService.cleanup
                            |
                            +-- BlobStoreRepository.cleanup
                                    |
                                    +-- 孤立BLOB検出・削除
```

### データフロー図

```
[入力]                             [処理]                             [出力]

POST /_snapshot/{repo}/_cleanup  RestCleanupRepositoryAction      JSON レスポンス
  repository (path) ---------->  CleanupRepositoryRequest生成      results.deleted_bytes
  timeout (query)                |                                 results.deleted_blobs
                                 v
                           TransportCleanupRepositoryAction
                                 |
                                 v
                           BlobStoreRepository.cleanup
                                 |
                           +-----+-----+
                           |           |
                           v           v
                    メタデータ比較   孤立BLOB削除 ---------> 結果返却
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| snapshot.cleanup_repository.json | `rest-api-spec/src/main/resources/rest-api-spec/api/snapshot.cleanup_repository.json` | API定義 | REST APIスペック定義 |
| RestCleanupRepositoryAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestCleanupRepositoryAction.java` | ソース | RESTリクエストハンドラ |
| TransportCleanupRepositoryAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/repositories/cleanup/TransportCleanupRepositoryAction.java` | ソース | Transport層のクリーンアップ処理 |
| CleanupRepositoryRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/repositories/cleanup/CleanupRepositoryRequest.java` | ソース | リクエストモデル |
| CleanupRepositoryResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/repositories/cleanup/CleanupRepositoryResponse.java` | ソース | レスポンスモデル |
| RepositoriesService.java | `server/src/main/java/org/opensearch/repositories/RepositoriesService.java` | ソース | リポジトリ管理サービス |
| BlobStoreRepository.java | `server/src/main/java/org/opensearch/repositories/blobstore/BlobStoreRepository.java` | ソース | BlobStoreリポジトリ実装 |
