# 画面設計書 121-スナップショット取得

## 概要

本ドキュメントは、OpenSearchのスナップショット取得API（GET /_snapshot/{repository}/{snapshot}）の画面設計書である。指定されたリポジトリ内のスナップショットの詳細情報を取得するREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：スナップショットはOpenSearchクラスタのインデックスデータのバックアップとして利用される。クラスタ運用においてバックアップの状態を確認する必要があり、スナップショットのメタデータ（作成日時、含まれるインデックス、状態、シャード情報等）を取得することは、バックアップの健全性確認やリストア計画の立案に不可欠である。本APIはスナップショットの詳細情報を返すことで、運用者がバックアップの管理・監視を行えるようにする。

**画面へのアクセス方法**：REST APIクライアント（curl、OpenSearch Dashboards Dev Tools、各種SDKなど）から `GET /_snapshot/{repository}/{snapshot}` エンドポイントにHTTP GETリクエストを送信してアクセスする。

**主要な操作・処理内容**：
1. クライアントがリポジトリ名とスナップショット名（カンマ区切りで複数指定可能）を指定してGETリクエストを送信する
2. クラスタマネージャノードがリポジトリからスナップショットのメタデータを読み取る
3. 進行中のスナップショット（SnapshotsInProgress）とリポジトリに保存済みのスナップショット情報を統合して返却する
4. ワイルドカードによるスナップショット名のパターンマッチングに対応する
5. `_all` 指定でリポジトリ内の全スナップショットを取得できる

**画面遷移**：本APIの結果を基に、スナップショットリストア（POST /_snapshot/{repository}/{snapshot}/_restore）やスナップショット削除（DELETE /_snapshot/{repository}/{snapshot}）、スナップショットステータス（GET /_snapshot/{repository}/{snapshot}/_status）へ遷移できる。スナップショット作成（PUT /_snapshot/{repository}/{snapshot}）の後続操作として利用される。

**権限による表示制御**：クラスタレベルの管理権限が必要。セキュリティプラグイン有効時はスナップショット管理の権限を持つユーザーのみアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | スナップショット作成・管理 | 主機能 | スナップショットの情報を返す処理 |

## 画面種別

詳細（REST API - 情報取得）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_snapshot/{repository}/{snapshot}` | 指定リポジトリ内のスナップショット情報を取得 |

## 入出力項目

### パスパラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|------|------|------|
| repository | string | Yes | リポジトリ名 |
| snapshot | list | Yes | カンマ区切りのスナップショット名リスト。`_all` で全件取得。ワイルドカード対応 |

### クエリパラメータ

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|------|------|-----------|------|
| cluster_manager_timeout | time | No | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | No | 30s | （非推奨）cluster_manager_timeout を使用すること |
| ignore_unavailable | boolean | No | false | 利用不可能なスナップショットを無視するかどうか。falseの場合SnapshotMissingExceptionがスローされる |
| verbose | boolean | No | true | 詳細なスナップショット情報を表示するか。falseの場合リポジトリインデックスblobの基本情報のみ返す |

## 表示項目

### レスポンスボディ

| 項目名 | 型 | 説明 |
|--------|------|------|
| snapshots | array | スナップショット情報の配列 |
| snapshots[].snapshot | string | スナップショット名 |
| snapshots[].uuid | string | スナップショットのUUID |
| snapshots[].version_id | integer | スナップショットを作成したOpenSearchのバージョンID |
| snapshots[].version | string | スナップショットを作成したOpenSearchのバージョン |
| snapshots[].indices | array | スナップショットに含まれるインデックス名の配列 |
| snapshots[].data_streams | array | スナップショットに含まれるデータストリームの配列 |
| snapshots[].include_global_state | boolean | グローバルステートを含むかどうか |
| snapshots[].state | string | スナップショットの状態（SUCCESS, FAILED, PARTIAL, IN_PROGRESS等） |
| snapshots[].start_time | string | 開始日時（ISO 8601形式） |
| snapshots[].start_time_in_millis | long | 開始日時（エポックミリ秒） |
| snapshots[].end_time | string | 終了日時（ISO 8601形式） |
| snapshots[].end_time_in_millis | long | 終了日時（エポックミリ秒） |
| snapshots[].duration_in_millis | long | 所要時間（ミリ秒） |
| snapshots[].failures | array | 失敗情報の配列 |
| snapshots[].shards | object | シャード統計 |
| snapshots[].shards.total | integer | 総シャード数 |
| snapshots[].shards.successful | integer | 成功シャード数 |
| snapshots[].shards.failed | integer | 失敗シャード数 |

## イベント仕様

### 1-スナップショット情報取得リクエスト

クライアントからGETリクエストを受信すると以下の処理が実行される：

1. RestGetSnapshotsActionがリクエストパラメータを解析し、GetSnapshotsRequestを生成する
2. TransportGetSnapshotsActionがクラスタマネージャノードで実行される
3. クラスタ状態からSnapshotsInProgress（進行中のスナップショット）を確認する
4. RepositoriesServiceからリポジトリを取得し、RepositoryDataからスナップショット一覧を読み取る
5. スナップショット名のパターンマッチング（ワイルドカード対応）を行う
6. verboseモードの場合は各スナップショットのSnapshotInfoを個別に読み取る
7. 結果をGetSnapshotsResponseとしてJSON形式で返却する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| GET リクエスト | - | SELECT（読み取り専用） | スナップショットメタデータの読み取りのみ。データ変更なし |

本APIは読み取り専用であり、クラスタ状態やリポジトリデータへの書き込みは発生しない。

## メッセージ仕様

| HTTPステータス | 条件 | メッセージ例 |
|---------------|------|-------------|
| 200 OK | 正常取得 | スナップショット情報のJSONレスポンス |
| 404 Not Found | スナップショットが存在しない（ignore_unavailable=false） | `SnapshotMissingException[[{repository}:{snapshot}] is missing]` |
| 404 Not Found | リポジトリが存在しない | `RepositoryMissingException[[{repository}] missing]` |
| 503 Service Unavailable | クラスタマネージャノードに接続できない | クラスタマネージャノードタイムアウト |

## 例外処理

| 例外 | 条件 | 対処 |
|------|------|------|
| SnapshotMissingException | 指定スナップショットが存在せず、ignore_unavailable=false | 404を返却 |
| RepositoryMissingException | 指定リポジトリが存在しない | 404を返却 |
| ClusterBlockException | クラスタにMETADATA_READブロックが設定されている | 処理をブロックし例外を返却 |
| SnapshotException | その他スナップショット関連エラー | 500を返却 |

## 備考

- ワイルドカード（`*`）を使用してスナップショット名をパターンマッチできる
- `_all` を指定するとリポジトリ内のすべてのスナップショットを取得する
- `verbose=false` を指定するとリポジトリインデックスblobの基本情報のみ返すため高速
- `master_timeout` パラメータはバージョン2.0.0で非推奨。`cluster_manager_timeout` を使用すること

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、スナップショット情報のデータ構造を把握することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GetSnapshotsRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/snapshots/get/GetSnapshotsRequest.java` | リクエストパラメータ（repository, snapshots, ignoreUnavailable, verbose）の定義 |
| 1-2 | GetSnapshotsResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/snapshots/get/GetSnapshotsResponse.java` | レスポンス構造（SnapshotInfoのリスト）の定義 |
| 1-3 | SnapshotInfo.java | `server/src/main/java/org/opensearch/snapshots/SnapshotInfo.java` | スナップショットのメタデータ構造（名前、UUID、状態、インデックス一覧、シャード統計等） |

**読解のコツ**: GetSnapshotsRequestのsnapshots配列がカンマ区切りリストに対応し、SnapshotInfoがレスポンスJSONの各フィールドに対応する。

#### Step 2: エントリーポイントを理解する

RESTハンドラが処理の起点となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestGetSnapshotsAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestGetSnapshotsAction.java` | ルーティング定義（61行目）とリクエストパラメータの解析（70-81行目） |

**主要処理フロー**:
1. **61行目**: `GET /_snapshot/{repository}/{snapshot}` のルーティング定義
2. **71行目**: リクエストからrepositoryパラメータを取得
3. **72行目**: snapshotパラメータをカンマ区切りで配列化
4. **74行目**: GetSnapshotsRequestオブジェクトを生成
5. **75-76行目**: ignore_unavailableとverboseパラメータを設定
6. **77-78行目**: cluster_manager_timeoutを設定
7. **81行目**: NodeClient経由でTransportアクションに委譲

#### Step 3: Transport層の処理を理解する

クラスタマネージャノードで実行されるコアロジック。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportGetSnapshotsAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/snapshots/get/TransportGetSnapshotsAction.java` | クラスタ状態のSnapshotsInProgressとリポジトリデータからスナップショット情報を収集する処理 |

**主要処理フロー**:
- TransportClusterManagerNodeActionを継承し、clusterManagerOperation()でコアロジックを実行
- RepositoriesServiceからリポジトリを取得
- SnapshotsInProgress（進行中スナップショット）の確認
- RepositoryDataからスナップショットID一覧を取得しパターンマッチング
- verboseモードではSnapshotInfoを個別に読み取り

#### Step 4: リポジトリ層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | RepositoriesService.java | `server/src/main/java/org/opensearch/repositories/RepositoriesService.java` | リポジトリの登録・取得管理 |
| 4-2 | Repository.java | `server/src/main/java/org/opensearch/repositories/Repository.java` | リポジトリインターフェース（getRepositoryData, getSnapshotInfo） |

### プログラム呼び出し階層図

```
RestGetSnapshotsAction#prepareRequest()
    |
    +-- NodeClient#admin().cluster().getSnapshots()
            |
            +-- TransportGetSnapshotsAction#clusterManagerOperation()
                    |
                    +-- ClusterState#custom(SnapshotsInProgress.TYPE)
                    |       (進行中スナップショットの確認)
                    |
                    +-- RepositoriesService#repository()
                    |       |
                    |       +-- Repository#getRepositoryData()
                    |       |       (リポジトリインデックスblobの読み取り)
                    |       |
                    |       +-- Repository#getSnapshotInfo()
                    |               (verbose時の詳細情報読み取り)
                    |
                    +-- GetSnapshotsResponse (結果構築)
```

### データフロー図

```
[入力]                     [処理]                         [出力]

GET /_snapshot/          RestGetSnapshotsAction        GetSnapshotsResponse
  /{repository}/         (パラメータ解析)                (JSON)
  /{snapshot}                  |
  ?verbose=true                v
  &ignore_unavailable    TransportGetSnapshotsAction
  =false                 (クラスタマネージャノード)
                               |
                    +----------+----------+
                    |                     |
              SnapshotsInProgress    RepositoryData
              (クラスタ状態)          (リポジトリBLOB)
                    |                     |
                    +----------+----------+
                               |
                          SnapshotInfo[]
                          (統合結果)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestGetSnapshotsAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestGetSnapshotsAction.java` | ソース | RESTハンドラ。リクエスト解析とルーティング |
| TransportGetSnapshotsAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/snapshots/get/TransportGetSnapshotsAction.java` | ソース | Transportアクション。スナップショット情報取得のコアロジック |
| GetSnapshotsRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/snapshots/get/GetSnapshotsRequest.java` | ソース | リクエストモデル |
| GetSnapshotsResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/snapshots/get/GetSnapshotsResponse.java` | ソース | レスポンスモデル |
| SnapshotInfo.java | `server/src/main/java/org/opensearch/snapshots/SnapshotInfo.java` | ソース | スナップショット情報データクラス |
| SnapshotsService.java | `server/src/main/java/org/opensearch/snapshots/SnapshotsService.java` | ソース | スナップショット管理サービス |
| RepositoriesService.java | `server/src/main/java/org/opensearch/repositories/RepositoriesService.java` | ソース | リポジトリ管理サービス |
| snapshot.get.json | `rest-api-spec/src/main/resources/rest-api-spec/api/snapshot.get.json` | API定義 | REST API仕様定義 |
