# 画面設計書 122-スナップショット削除

## 概要

本ドキュメントは、OpenSearchのスナップショット削除API（DELETE /_snapshot/{repository}/{snapshot}）の画面設計書である。指定されたリポジトリ内のスナップショットを削除するREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：スナップショットはストレージリソースを消費するため、不要になったバックアップを適切に削除することがクラスタ運用において重要である。古いスナップショットの削除はディスク容量の管理、コスト削減、リポジトリの整理に不可欠な操作である。本APIはスナップショットをリポジトリから安全に削除し、関連するデータファイルをクリーンアップする機能を提供する。

**画面へのアクセス方法**：REST APIクライアント（curl、OpenSearch Dashboards Dev Tools、各種SDKなど）から `DELETE /_snapshot/{repository}/{snapshot}` エンドポイントにHTTP DELETEリクエストを送信してアクセスする。

**主要な操作・処理内容**：
1. クライアントがリポジトリ名とスナップショット名を指定してDELETEリクエストを送信する
2. クラスタマネージャノードがスナップショット削除処理を開始する
3. SnapshotsServiceがクラスタ状態を更新し、スナップショットメタデータを削除する
4. リポジトリからスナップショットのデータファイルを削除する
5. カンマ区切りで複数のスナップショットを一度に削除可能
6. 進行中のスナップショットも中止して削除できる

**画面遷移**：スナップショット取得（GET /_snapshot/{repository}/{snapshot}）で対象を確認した後に本APIを呼び出す。スナップショット作成（PUT /_snapshot/{repository}/{snapshot}）のライフサイクル終了操作として位置づけられる。

**権限による表示制御**：クラスタレベルの管理権限が必要。セキュリティプラグイン有効時はスナップショット管理の書き込み権限を持つユーザーのみアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | スナップショット作成・管理 | 主機能 | スナップショットを削除する処理 |

## 画面種別

削除（REST API - データ削除）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| DELETE | `/_snapshot/{repository}/{snapshot}` | 指定リポジトリ内のスナップショットを削除 |

## 入出力項目

### パスパラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|------|------|------|
| repository | string | Yes | リポジトリ名 |
| snapshot | string | Yes | スナップショット名。カンマ区切りで複数指定可能 |

### クエリパラメータ

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|------|------|-----------|------|
| cluster_manager_timeout | time | No | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | No | 30s | （非推奨）cluster_manager_timeout を使用すること |

## 表示項目

### レスポンスボディ

| 項目名 | 型 | 説明 |
|--------|------|------|
| acknowledged | boolean | リクエストが受理されたかどうか |

## イベント仕様

### 1-スナップショット削除リクエスト

クライアントからDELETEリクエストを受信すると以下の処理が実行される：

1. RestDeleteSnapshotActionがリクエストパラメータを解析し、DeleteSnapshotRequestを生成する
2. snapshotパラメータをカンマで分割して複数スナップショット名の配列を生成する
3. TransportDeleteSnapshotActionがクラスタマネージャノードで実行される
4. SnapshotsService#deleteSnapshots()が呼び出され、クラスタ状態の更新タスクが投入される
5. 進行中のスナップショットの場合は中止処理が先に実行される
6. リポジトリからスナップショットのメタデータとデータファイルが削除される
7. AcknowledgedResponseとして結果を返却する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| DELETE リクエスト | クラスタ状態（SnapshotsInProgress/SnapshotDeletionsInProgress） | UPDATE | スナップショット削除中の状態をクラスタ状態に記録 |
| DELETE リクエスト | リポジトリメタデータ（RepositoryData） | DELETE | スナップショットのメタデータをリポジトリインデックスから削除 |
| DELETE リクエスト | リポジトリデータファイル | DELETE | スナップショットのデータBLOBを削除 |

### テーブル別更新項目詳細

#### クラスタ状態

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| UPDATE | SnapshotDeletionsInProgress | 削除中のスナップショットエントリを追加 | 削除完了後に除去 |

## メッセージ仕様

| HTTPステータス | 条件 | メッセージ例 |
|---------------|------|-------------|
| 200 OK | 正常削除完了 | `{"acknowledged": true}` |
| 404 Not Found | スナップショットが存在しない | `SnapshotMissingException[[{repository}:{snapshot}] is missing]` |
| 404 Not Found | リポジトリが存在しない | `RepositoryMissingException[[{repository}] missing]` |
| 409 Conflict | 同時削除による競合 | `ConcurrentSnapshotExecutionException` |

## 例外処理

| 例外 | 条件 | 対処 |
|------|------|------|
| SnapshotMissingException | 指定スナップショットが存在しない | 404を返却 |
| RepositoryMissingException | 指定リポジトリが存在しない | 404を返却 |
| ConcurrentSnapshotExecutionException | 同時にスナップショット操作が実行されている | 409を返却。リトライが必要 |
| ClusterBlockException | クラスタにMETADATA_WRITEブロックが設定されている | 処理をブロックし例外を返却 |

## 備考

- カンマ区切りで複数のスナップショット名を指定して一括削除が可能
- 進行中のスナップショットを削除すると、まずスナップショット作成処理が中止され、その後に部分的に作成されたデータが削除される
- 削除操作は非同期的にリポジトリのクリーンアップを行う場合がある
- `master_timeout` パラメータはバージョン2.0.0で非推奨。`cluster_manager_timeout` を使用すること

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DeleteSnapshotRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/snapshots/delete/DeleteSnapshotRequest.java` | リクエストパラメータ（repository, snapshots配列）の定義 |

**読解のコツ**: DeleteSnapshotRequestのsnapshots配列がカンマ区切りで分割された結果を保持する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestDeleteSnapshotAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestDeleteSnapshotAction.java` | ルーティング定義（61行目）とリクエスト解析（70-79行目） |

**主要処理フロー**:
1. **61行目**: `DELETE /_snapshot/{repository}/{snapshot}` のルーティング定義
2. **71-74行目**: DeleteSnapshotRequestを生成。snapshotパラメータをカンマで分割
3. **75-76行目**: cluster_manager_timeoutを設定
4. **79行目**: NodeClient経由でdeleteSnapshotアクションを実行

#### Step 3: Transport層の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportDeleteSnapshotAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/snapshots/delete/TransportDeleteSnapshotAction.java` | SnapshotsService#deleteSnapshots()への委譲 |
| 3-2 | SnapshotsService.java | `server/src/main/java/org/opensearch/snapshots/SnapshotsService.java` | 削除処理のコアロジック（クラスタ状態更新、リポジトリクリーンアップ） |

### プログラム呼び出し階層図

```
RestDeleteSnapshotAction#prepareRequest()
    |
    +-- Strings.splitStringByCommaToArray() (スナップショット名分割)
    |
    +-- NodeClient#admin().cluster().deleteSnapshot()
            |
            +-- TransportDeleteSnapshotAction#clusterManagerOperation()
                    |
                    +-- SnapshotsService#deleteSnapshots()
                            |
                            +-- ClusterState更新タスク投入
                            |       (SnapshotDeletionsInProgress追加)
                            |
                            +-- Repository#deleteSnapshots()
                                    (データファイル削除)
```

### データフロー図

```
[入力]                    [処理]                          [出力]

DELETE /_snapshot/       RestDeleteSnapshotAction        AcknowledgedResponse
  /{repository}/        (パラメータ解析)                  {"acknowledged": true}
  /{snapshot}                  |
                               v
                        TransportDeleteSnapshotAction
                        (クラスタマネージャノード)
                               |
                               v
                        SnapshotsService
                        (削除処理)
                               |
                    +----------+----------+
                    |                     |
              ClusterState更新       Repository削除
              (メタデータ除去)       (データBLOB削除)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestDeleteSnapshotAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestDeleteSnapshotAction.java` | ソース | RESTハンドラ |
| TransportDeleteSnapshotAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/snapshots/delete/TransportDeleteSnapshotAction.java` | ソース | Transportアクション |
| DeleteSnapshotRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/snapshots/delete/DeleteSnapshotRequest.java` | ソース | リクエストモデル |
| SnapshotsService.java | `server/src/main/java/org/opensearch/snapshots/SnapshotsService.java` | ソース | スナップショット削除コアロジック |
| snapshot.delete.json | `rest-api-spec/src/main/resources/rest-api-spec/api/snapshot.delete.json` | API定義 | REST API仕様定義 |
