# 画面設計書 125-スナップショットステータス

## 概要

本ドキュメントは、OpenSearchのスナップショットステータスAPI（GET /_snapshot/_status 等）の画面設計書である。スナップショットの詳細なステータス情報（進行中・完了済み）を取得するREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：スナップショットの作成は大規模なインデックスの場合に長時間かかることがある。運用者はスナップショットの進捗状況（シャードレベルの転送バイト数、ファイル数等）をリアルタイムに監視する必要がある。本APIはスナップショットの詳細なステータス情報を提供し、進行中のスナップショットの進捗監視や完了済みスナップショットの品質確認を可能にする。

**画面へのアクセス方法**：REST APIクライアントから以下のいずれかのエンドポイントにHTTP GETリクエストを送信してアクセスする。スコープに応じて4種類のパスパターンが利用可能。

**主要な操作・処理内容**：
1. 全リポジトリの全スナップショットのステータスを取得（GET /_snapshot/_status）
2. 特定リポジトリの全スナップショットのステータスを取得（GET /_snapshot/{repository}/_status）
3. 特定リポジトリの特定スナップショットのステータスを取得（GET /_snapshot/{repository}/{snapshot}/_status）
4. 特定スナップショット内の特定インデックスのステータスを取得（GET /_snapshot/{repository}/{snapshot}/{index}/_status）
5. シャードレベルの転送進捗情報（バイト数、ファイル数）を返却する

**画面遷移**：スナップショット作成（PUT /_snapshot/{repository}/{snapshot}）の実行後に本APIで進捗を監視する。スナップショット取得（GET /_snapshot/{repository}/{snapshot}）の補完情報として利用される。

**権限による表示制御**：クラスタレベルの管理権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | スナップショット作成・管理 | 主機能 | スナップショットのステータス情報を返す処理 |

## 画面種別

詳細（REST API - ステータス情報取得）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_snapshot/_status` | 全スナップショットのステータス |
| GET | `/_snapshot/{repository}/_status` | 特定リポジトリのスナップショットステータス |
| GET | `/_snapshot/{repository}/{snapshot}/_status` | 特定スナップショットのステータス |
| GET | `/_snapshot/{repository}/{snapshot}/{index}/_status` | 特定インデックスのステータス |

## 入出力項目

### パスパラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|------|------|------|
| repository | string | No | リポジトリ名。省略時は全リポジトリ |
| snapshot | list | No | カンマ区切りのスナップショット名リスト |
| index | list | No | カンマ区切りのインデックス名リスト |

### クエリパラメータ

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|------|------|-----------|------|
| cluster_manager_timeout | time | No | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | No | 30s | （非推奨）cluster_manager_timeout を使用すること |
| ignore_unavailable | boolean | No | false | 利用不可能なスナップショット・インデックスを無視するか |

## 表示項目

### レスポンスボディ

| 項目名 | 型 | 説明 |
|--------|------|------|
| snapshots | array | スナップショットステータスの配列 |
| snapshots[].snapshot | string | スナップショット名 |
| snapshots[].repository | string | リポジトリ名 |
| snapshots[].uuid | string | スナップショットUUID |
| snapshots[].state | string | スナップショット状態 |
| snapshots[].include_global_state | boolean | グローバルステートを含むか |
| snapshots[].shards_stats | object | シャード統計サマリー |
| snapshots[].shards_stats.initializing | integer | 初期化中のシャード数 |
| snapshots[].shards_stats.started | integer | 開始済みのシャード数 |
| snapshots[].shards_stats.finalizing | integer | 最終処理中のシャード数 |
| snapshots[].shards_stats.done | integer | 完了したシャード数 |
| snapshots[].shards_stats.failed | integer | 失敗したシャード数 |
| snapshots[].shards_stats.total | integer | 総シャード数 |
| snapshots[].stats | object | 転送統計 |
| snapshots[].stats.incremental | object | 増分転送統計 |
| snapshots[].stats.total | object | 総転送統計 |
| snapshots[].indices | object | インデックス別ステータス |

## イベント仕様

### 1-スナップショットステータス取得リクエスト

クライアントからGETリクエストを受信すると以下の処理が実行される：

1. RestSnapshotsStatusActionがリクエストパラメータを解析し、SnapshotsStatusRequestを生成する
2. repositoryパラメータのデフォルトは `_all`
3. snapshot, indexパラメータが `_all` の場合は空配列に変換される
4. TransportSnapshotsStatusActionがクラスタマネージャノードで実行される
5. クラスタ状態のSnapshotsInProgressから進行中スナップショットのステータスを収集する
6. SnapshotShardsServiceから各シャードの転送進捗を取得する
7. 完了済みスナップショットの場合はリポジトリからステータス情報を読み取る
8. SnapshotsStatusResponseとしてJSON形式で返却する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| GET リクエスト | - | SELECT（読み取り専用） | ステータス情報の読み取りのみ。データ変更なし |

## メッセージ仕様

| HTTPステータス | 条件 | メッセージ例 |
|---------------|------|-------------|
| 200 OK | 正常取得 | ステータス情報のJSONレスポンス |
| 404 Not Found | スナップショットが存在しない | `SnapshotMissingException` |
| 404 Not Found | インデックスが存在しない | `IndexNotFoundException` |

## 例外処理

| 例外 | 条件 | 対処 |
|------|------|------|
| SnapshotMissingException | 指定スナップショットが存在しない（ignore_unavailable=false） | 404を返却 |
| IndexNotFoundException | 指定インデックスが存在しない（ignore_unavailable=false） | 404を返却 |
| ClusterBlockException | METADATA_READブロックが設定されている | 処理をブロック |
| CircuitBreakingException | ステータス情報がサーキットブレーカーの閾値を超えた | 429を返却 |

## 備考

- 進行中のスナップショットではリアルタイムの転送進捗（バイト数、ファイル数）が取得可能
- 大量のスナップショットステータスを取得する場合、サーキットブレーカーによりリクエストが拒否される場合がある
- `_all` を指定すると全スナップショットのステータスを取得する
- インデックス指定（4番目のパスパターン）で特定インデックスのみのステータスに絞り込み可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SnapshotsStatusRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/snapshots/status/SnapshotsStatusRequest.java` | リクエストパラメータ（repository, snapshots, indices, ignoreUnavailable）の定義 |
| 1-2 | SnapshotsStatusResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/snapshots/status/SnapshotsStatusResponse.java` | レスポンス構造 |
| 1-3 | SnapshotStatus.java | `server/src/main/java/org/opensearch/action/admin/cluster/snapshots/status/SnapshotStatus.java` | 個々のスナップショットステータスデータ |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestSnapshotsStatusAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestSnapshotsStatusAction.java` | 4つのルーティングパターン定義（62-69行目）とパラメータ解析（78-95行目） |

**主要処理フロー**:
1. **62-69行目**: 4つのルーティングパターン定義
2. **79行目**: repositoryパラメータ取得（デフォルト `_all`）
3. **80-83行目**: snapshotパラメータを配列化。`_all` の場合は空配列に
4. **84-87行目**: indexパラメータを配列化。`_all` の場合は空配列に
5. **88行目**: SnapshotsStatusRequestを生成
6. **89行目**: ignore_unavailableを設定
7. **95行目**: NodeClient経由でsnapshotsStatusアクションを実行

#### Step 3: Transport層の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportSnapshotsStatusAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/snapshots/status/TransportSnapshotsStatusAction.java` | 進行中/完了済みスナップショットのステータス収集ロジック |

### プログラム呼び出し階層図

```
RestSnapshotsStatusAction#prepareRequest()
    |
    +-- NodeClient#admin().cluster().snapshotsStatus()
            |
            +-- TransportSnapshotsStatusAction#clusterManagerOperation()
                    |
                    +-- SnapshotsInProgress (進行中スナップショット確認)
                    |       |
                    |       +-- SnapshotShardsService
                    |               (シャードレベル転送進捗)
                    |
                    +-- RepositoriesService (完了済みスナップショット)
                    |       |
                    |       +-- Repository#getSnapshotShardGenerations()
                    |
                    +-- SnapshotsStatusResponse (結果構築)
```

### データフロー図

```
[入力]                        [処理]                           [出力]

GET /_snapshot/              RestSnapshotsStatusAction        SnapshotsStatusResponse
  {repository}/              (パラメータ解析)                    (JSON)
  {snapshot}/_status               |
                                   v
                        TransportSnapshotsStatusAction
                        (クラスタマネージャノード)
                                   |
                    +--------------+-------------+
                    |                            |
              進行中スナップショット          完了済みスナップショット
              (ClusterState +                (Repository +
               SnapshotShardsService)         RepositoryData)
                    |                            |
                    +-------------+--------------+
                                  |
                          SnapshotStatus[]
                          (統合結果)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestSnapshotsStatusAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestSnapshotsStatusAction.java` | ソース | RESTハンドラ |
| TransportSnapshotsStatusAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/snapshots/status/TransportSnapshotsStatusAction.java` | ソース | Transportアクション |
| SnapshotsStatusRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/snapshots/status/SnapshotsStatusRequest.java` | ソース | リクエストモデル |
| SnapshotsStatusResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/snapshots/status/SnapshotsStatusResponse.java` | ソース | レスポンスモデル |
| SnapshotStatus.java | `server/src/main/java/org/opensearch/action/admin/cluster/snapshots/status/SnapshotStatus.java` | ソース | スナップショットステータスデータ |
| SnapshotShardsService.java | `server/src/main/java/org/opensearch/snapshots/SnapshotShardsService.java` | ソース | シャードレベルステータス提供 |
| snapshot.status.json | `rest-api-spec/src/main/resources/rest-api-spec/api/snapshot.status.json` | API定義 | REST API仕様定義 |
