# 画面設計書 126-リモートストアリストア

## 概要

本ドキュメントは、OpenSearchのリモートストアリストアAPI（POST /_remotestore/_restore）の画面設計書である。リモートストアからインデックスデータをリストアするREST APIエンドポイントの仕様を定義する。本APIはexperimental（実験的）ステータスである。

### 本画面の処理概要

**業務上の目的・背景**：リモートストア機能は、OpenSearchのセグメントデータやトランスログをリモートストレージ（S3等）に保存する機能である。ノード障害やクラスタ障害が発生した場合、リモートストアに保存されたデータからインデックスを復元する必要がある。本APIはリモートストアからのデータ復旧を可能にし、高可用性・災害復旧（DR）シナリオを支援する。スナップショットリストアとは異なり、リモートストアに直接保存されたデータからの復元を行う。

**画面へのアクセス方法**：REST APIクライアントから `POST /_remotestore/_restore` エンドポイントにHTTP POSTリクエストを送信してアクセスする。リクエストボディにリストア対象のインデックスIDを指定する。

**主要な操作・処理内容**：
1. クライアントがリストア対象のインデックスIDリストをリクエストボディに指定してPOSTリクエストを送信する
2. クラスタマネージャノードがリモートストアリストア処理を開始する
3. RemoteStoreRestoreServiceがリモートストアからメタデータとセグメントデータを復元する
4. wait_for_completionオプションにより同期/非同期動作を選択可能
5. restore_all_shardsオプションにより全シャードの復元を制御可能

**画面遷移**：本APIはリモートストア有効なインデックスの障害復旧時に使用される。リストア後はインデックス情報取得（GET /{index}）やクラスタヘルス（GET /_cluster/health）でリストア結果を確認する。

**権限による表示制御**：クラスタレベルの管理権限およびインデックス作成・書き込み権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 61 | リモートストア | 主機能 | リモートストアからリストアする処理 |

## 画面種別

登録（REST API - データ復元）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| POST | `/_remotestore/_restore` | リモートストアからリストア |

## 入出力項目

### クエリパラメータ

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|------|------|-----------|------|
| cluster_manager_timeout | time | No | 30s | クラスタマネージャノードへの接続タイムアウト |
| wait_for_completion | boolean | No | false | リストア完了まで待機するかどうか |
| restore_all_shards | boolean | No | false | 全シャードを復元するかどうか |

### リクエストボディ（必須）

| 項目名 | 型 | 必須 | 説明 |
|--------|------|------|------|
| indices | list | Yes | リストア対象のインデックスIDのカンマ区切りリスト |

## 表示項目

### レスポンスボディ

| 項目名 | 型 | 説明 |
|--------|------|------|
| accepted | boolean | リクエストが受理されたか（wait_for_completion=falseの場合） |
| remote_store | object | リストア情報（wait_for_completion=trueの場合） |
| remote_store.snapshot | object | リストアスナップショット情報 |
| remote_store.indices | array | リストアされたインデックス名の配列 |
| remote_store.shards | object | シャード統計 |

## イベント仕様

### 1-リモートストアリストアリクエスト

クライアントからPOSTリクエストを受信すると以下の処理が実行される：

1. RestRestoreRemoteStoreActionがリクエストパラメータとボディを解析し、RestoreRemoteStoreRequestを生成する
2. cluster_manager_timeout、wait_for_completion、restore_all_shardsパラメータを設定する
3. リクエストボディからインデックスIDリストを読み取る（source()メソッド）
4. TransportRestoreRemoteStoreActionがクラスタマネージャノードで実行される
5. RemoteStoreRestoreServiceがリモートストアからデータを復元する
6. クラスタ状態を更新してインデックスメタデータとルーティング情報を作成する
7. wait_for_completion=trueの場合はリストア完了後にレスポンスを返却

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| POST リクエスト | クラスタ状態（Metadata） | INSERT/UPDATE | リストアされるインデックスメタデータを追加・更新 |
| POST リクエスト | クラスタ状態（RoutingTable） | INSERT/UPDATE | シャードルーティング情報を追加・更新 |
| POST リクエスト | データノード（シャードデータ） | INSERT | リモートストアからシャードデータを復元 |

## メッセージ仕様

| HTTPステータス | 条件 | メッセージ例 |
|---------------|------|-------------|
| 200 OK | リストア完了/受理 | リストア情報のJSONレスポンス |
| 400 Bad Request | リクエストボディ不正 | パースエラー |
| 500 Internal Server Error | リストア処理中のエラー | リモートストア接続エラー等 |

## 例外処理

| 例外 | 条件 | 対処 |
|------|------|------|
| ClusterBlockException | METADATA_WRITEまたはWRITEブロックが設定されている | 処理をブロック |
| IllegalArgumentException | リクエストボディが不正 | 400を返却 |
| RemoteStoreException | リモートストアへのアクセスに失敗 | 500を返却 |

## 備考

- 本APIはexperimental（実験的）ステータスであり、将来のバージョンで仕様が変更される可能性がある
- リモートストア機能が有効なクラスタでのみ利用可能
- restore_all_shards=trueを指定すると全シャードをリモートストアから完全復元する
- リクエストボディは必須であり、リストア対象のインデックスIDを指定する必要がある

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | RestoreRemoteStoreRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/remotestore/restore/RestoreRemoteStoreRequest.java` | リクエストパラメータ（indices, waitForCompletion, restoreAllShards）の定義 |
| 1-2 | RestoreRemoteStoreResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/remotestore/restore/RestoreRemoteStoreResponse.java` | レスポンス構造 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestRestoreRemoteStoreAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestRestoreRemoteStoreAction.java` | ルーティング定義（32行目）とリクエスト解析（41-49行目） |

**主要処理フロー**:
1. **32行目**: `POST /_remotestore/_restore` のルーティング定義
2. **42行目**: RestoreRemoteStoreRequestを生成
3. **43-44行目**: cluster_manager_timeoutを設定
4. **46行目**: wait_for_completionを設定（デフォルトfalse）
5. **47行目**: restore_all_shardsを設定（デフォルトfalse）
6. **48行目**: リクエストボディからsource情報を読み取り
7. **49行目**: NodeClient経由でrestoreRemoteStoreアクションを実行

#### Step 3: Transport層・サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportRestoreRemoteStoreAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/remotestore/restore/TransportRestoreRemoteStoreAction.java` | RemoteStoreRestoreServiceへの委譲。METADATA_WRITEとWRITEブロックチェック（70-77行目） |
| 3-2 | RemoteStoreRestoreService.java | `server/src/main/java/org/opensearch/index/recovery/RemoteStoreRestoreService.java` | リモートストアからのリストアコアロジック |

### プログラム呼び出し階層図

```
RestRestoreRemoteStoreAction#prepareRequest()
    |
    +-- NodeClient#admin().cluster().restoreRemoteStore()
            |
            +-- TransportRestoreRemoteStoreAction#clusterManagerOperation()
                    |
                    +-- checkBlock() (METADATA_WRITE + WRITEブロック確認)
                    |
                    +-- RemoteStoreRestoreService#restore()
                            |
                            +-- リモートストアからメタデータ読み取り
                            |
                            +-- ClusterState更新
                            |       (IndexMetadata/RoutingTable作成)
                            |
                            +-- RestoreClusterStateListener
                                    (リストア完了監視)
```

### データフロー図

```
[入力]                    [処理]                              [出力]

POST /_remotestore/     RestRestoreRemoteStoreAction        RestoreRemoteStoreResponse
  _restore              (パラメータ+ボディ解析)                (JSON)
                               |
Body: {                        v
  "indices": [...]     TransportRestoreRemoteStoreAction
}                       (クラスタマネージャノード)
                               |
                               v
                        RemoteStoreRestoreService
                        (リストアロジック)
                               |
                    +----------+----------+
                    |                     |
              リモートストア          ClusterState更新
              (メタデータ+            (IndexMetadata/
               セグメントデータ)       RoutingTable)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestRestoreRemoteStoreAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestRestoreRemoteStoreAction.java` | ソース | RESTハンドラ |
| TransportRestoreRemoteStoreAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/remotestore/restore/TransportRestoreRemoteStoreAction.java` | ソース | Transportアクション |
| RestoreRemoteStoreRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/remotestore/restore/RestoreRemoteStoreRequest.java` | ソース | リクエストモデル |
| RestoreRemoteStoreResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/remotestore/restore/RestoreRemoteStoreResponse.java` | ソース | レスポンスモデル |
| RemoteStoreRestoreService.java | `server/src/main/java/org/opensearch/index/recovery/RemoteStoreRestoreService.java` | ソース | リモートストアリストアコアロジック |
| remote_store.restore.json | `rest-api-spec/src/main/resources/rest-api-spec/api/remote_store.restore.json` | API定義 | REST API仕様定義 |
