# 画面設計書 127-リモートストア統計

## 概要

本ドキュメントは、OpenSearchのリモートストア統計API（GET /_remotestore/stats/{index} 等）の画面設計書である。リモートストアの統計情報（セグメント転送、トランスログ転送の統計）を取得するREST APIエンドポイントの仕様を定義する。本APIはexperimental（実験的）ステータスである。

### 本画面の処理概要

**業務上の目的・背景**：リモートストア機能を使用するクラスタでは、セグメントデータやトランスログのリモートストレージへの転送状況を監視することが重要である。転送の遅延や失敗はデータの耐久性やリカバリ時間に影響するため、運用者はリアルタイムに転送統計を把握する必要がある。本APIはインデックスレベルおよびシャードレベルのリモートストア転送統計を提供し、パフォーマンス監視やトラブルシューティングを支援する。

**画面へのアクセス方法**：REST APIクライアントから `GET /_remotestore/stats/{index}` または `GET /_remotestore/stats/{index}/{shard_id}` エンドポイントにHTTP GETリクエストを送信してアクセスする。

**主要な操作・処理内容**：
1. インデックス名を指定してインデックスレベルのリモートストア統計を取得する
2. インデックス名とシャードIDを指定してシャードレベルの詳細統計を取得する
3. セグメント転送統計（アップロードバイト数、ファイル数、レイテンシ等）を返却する
4. トランスログ転送統計（アップロード/ダウンロードバイト数等）を返却する
5. localパラメータでローカルノードのみの統計に限定可能

**画面遷移**：インデックス統計（GET /{index}/_stats）の補完情報としてリモートストア固有の統計を提供する。インデックス情報取得（GET /{index}）と併用してインデックスの状態を総合的に確認する。

**権限による表示制御**：インデックスレベルの読み取り権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 61 | リモートストア | 主機能 | リモートストアの統計情報を返す処理 |

## 画面種別

詳細（REST API - 統計情報取得）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_remotestore/stats/{index}` | インデックスレベルのリモートストア統計 |
| GET | `/_remotestore/stats/{index}/{shard_id}` | シャードレベルのリモートストア統計 |

## 入出力項目

### パスパラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|------|------|------|
| index | string | Yes | インデックス名 |
| shard_id | string | No | シャードID（特定シャードの統計を取得する場合） |

### クエリパラメータ

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|------|------|-----------|------|
| timeout | time | No | 10s | 各ノードへの統計リクエストのタイムアウト |
| local | boolean | No | false | ローカルノードのみの統計を取得するか |

## 表示項目

### レスポンスボディ

| 項目名 | 型 | 説明 |
|--------|------|------|
| _shards | object | シャード統計サマリー |
| _shards.total | integer | 総シャード数 |
| _shards.successful | integer | 成功シャード数 |
| _shards.failed | integer | 失敗シャード数 |
| stats | array | シャード別のリモートストア統計 |
| stats[].shard_id | object | シャード識別情報 |
| stats[].routing | object | シャードルーティング情報 |
| stats[].segment | object | セグメント転送統計 |
| stats[].translog | object | トランスログ転送統計 |

## イベント仕様

### 1-リモートストア統計取得リクエスト

クライアントからGETリクエストを受信すると以下の処理が実行される：

1. RestRemoteStoreStatsActionがリクエストパラメータを解析し、RemoteStoreStatsRequestを生成する
2. indexパラメータとshard_idパラメータを設定する
3. localパラメータの値を確認する
4. TransportRemoteStoreStatsActionが各データノードにブロードキャストされる（TransportBroadcastByNodeAction）
5. 各ノードでRemoteStoreStatsTrackerFactoryからセグメント転送統計とトランスログ転送統計を取得する
6. RemoteSegmentTransferTrackerとRemoteTranslogTransferTrackerから詳細統計を収集する
7. RemoteStoreStatsResponseとして結果を集約して返却する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| GET リクエスト | - | SELECT（読み取り専用） | 統計情報の読み取りのみ。データ変更なし |

## メッセージ仕様

| HTTPステータス | 条件 | メッセージ例 |
|---------------|------|-------------|
| 200 OK | 正常取得 | 統計情報のJSONレスポンス |
| 404 Not Found | インデックスが存在しない | `IndexNotFoundException` |
| 400 Bad Request | シャードが存在しない | `ShardNotFoundException` |

## 例外処理

| 例外 | 条件 | 対処 |
|------|------|------|
| IndexNotFoundException | 指定インデックスが存在しない | 404を返却 |
| ShardNotFoundException | 指定シャードが存在しない | 400を返却 |
| ClusterBlockException | READ/METADATA_READブロックが設定されている | 処理をブロック |

## 備考

- 本APIはexperimental（実験的）ステータスであり、将来のバージョンで仕様が変更される可能性がある
- TransportBroadcastByNodeActionを使用しており、全ノードにリクエストがブロードキャストされる
- リモートストア機能が有効なインデックスでのみ意味のある統計が返される
- local=trueを指定するとローカルノードのみの統計に限定される
- タイムアウトのデフォルトは10秒

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | RemoteStoreStatsRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/remotestore/stats/RemoteStoreStatsRequest.java` | リクエストパラメータ（indices, shards, local）の定義 |
| 1-2 | RemoteStoreStatsResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/remotestore/stats/RemoteStoreStatsResponse.java` | レスポンス構造 |
| 1-3 | RemoteStoreStats.java | `server/src/main/java/org/opensearch/action/admin/cluster/remotestore/stats/RemoteStoreStats.java` | 個別シャードの統計データ |

**読解のコツ**: RemoteStoreStatsはRemoteSegmentTransferTrackerとRemoteTranslogTransferTrackerの統計を保持する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestRemoteStoreStatsAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestRemoteStoreStatsAction.java` | ルーティング定義（34-35行目）とパラメータ解析（45-57行目） |

**主要処理フロー**:
1. **34-35行目**: 2つのルーティングパターン定義（index指定、index+shard_id指定）
2. **46行目**: indexパラメータを取得
3. **47行目**: shard_idパラメータを取得
4. **48行目**: localパラメータを取得
5. **49行目**: RemoteStoreStatsRequestを生成
6. **50-56行目**: index, shard, localの各パラメータを設定
7. **57行目**: NodeClient経由でremoteStoreStatsアクションを実行

#### Step 3: Transport層の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportRemoteStoreStatsAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/remotestore/stats/TransportRemoteStoreStatsAction.java` | TransportBroadcastByNodeActionによる全ノードへのブロードキャスト。RemoteStoreStatsTrackerFactoryからの統計収集 |

#### Step 4: 統計トラッカーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | RemoteSegmentTransferTracker.java | `server/src/main/java/org/opensearch/index/remote/RemoteSegmentTransferTracker.java` | セグメント転送統計の収集・提供 |
| 4-2 | RemoteTranslogTransferTracker.java | `server/src/main/java/org/opensearch/index/remote/RemoteTranslogTransferTracker.java` | トランスログ転送統計の収集・提供 |

### プログラム呼び出し階層図

```
RestRemoteStoreStatsAction#prepareRequest()
    |
    +-- NodeClient#admin().cluster().remoteStoreStats()
            |
            +-- TransportRemoteStoreStatsAction (TransportBroadcastByNodeAction)
                    |
                    +-- 各ノードで shardOperation() 実行
                    |       |
                    |       +-- IndicesService#indexServiceSafe()
                    |       |       |
                    |       |       +-- IndexShard取得
                    |       |
                    |       +-- RemoteStoreStatsTrackerFactory
                    |               |
                    |               +-- RemoteSegmentTransferTracker
                    |               |
                    |               +-- RemoteTranslogTransferTracker
                    |
                    +-- RemoteStoreStatsResponse (結果集約)
```

### データフロー図

```
[入力]                         [処理]                           [出力]

GET /_remotestore/           RestRemoteStoreStatsAction       RemoteStoreStatsResponse
  stats/{index}              (パラメータ解析)                    (JSON)
  /{shard_id}                       |
                                    v
                        TransportRemoteStoreStatsAction
                        (全ノードにブロードキャスト)
                                    |
                    +---------------+---------------+
                    |               |               |
                Node1           Node2           Node3
                (シャード統計)   (シャード統計)   (シャード統計)
                    |               |               |
                    +-------+-------+-------+-------+
                            |
                    RemoteStoreStatsResponse
                    (集約結果)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestRemoteStoreStatsAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestRemoteStoreStatsAction.java` | ソース | RESTハンドラ |
| TransportRemoteStoreStatsAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/remotestore/stats/TransportRemoteStoreStatsAction.java` | ソース | Transportアクション（ブロードキャスト型） |
| RemoteStoreStatsRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/remotestore/stats/RemoteStoreStatsRequest.java` | ソース | リクエストモデル |
| RemoteStoreStatsResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/remotestore/stats/RemoteStoreStatsResponse.java` | ソース | レスポンスモデル |
| RemoteStoreStats.java | `server/src/main/java/org/opensearch/action/admin/cluster/remotestore/stats/RemoteStoreStats.java` | ソース | シャード別統計データ |
| RemoteSegmentTransferTracker.java | `server/src/main/java/org/opensearch/index/remote/RemoteSegmentTransferTracker.java` | ソース | セグメント転送統計トラッカー |
| RemoteTranslogTransferTracker.java | `server/src/main/java/org/opensearch/index/remote/RemoteTranslogTransferTracker.java` | ソース | トランスログ転送統計トラッカー |
| RemoteStoreStatsTrackerFactory.java | `server/src/main/java/org/opensearch/index/remote/RemoteStoreStatsTrackerFactory.java` | ソース | 統計トラッカーファクトリ |
| remote_store.stats.json | `rest-api-spec/src/main/resources/rest-api-spec/api/remote_store.stats.json` | API定義 | REST API仕様定義 |
