# 画面設計書 128-Danglingインデックス一覧

## 概要

本ドキュメントは、OpenSearchのDanglingインデックス一覧API（GET /_dangling）の画面設計書である。クラスタ内のすべてのDanglingインデックスを返すREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：Danglingインデックスとは、ノードのローカルデータディレクトリに存在するが、クラスタ状態（ClusterState）には登録されていないインデックスのことである。これはノードの参加・離脱、クラスタ状態の不整合、ノード間のデータ移行時に発生する場合がある。Danglingインデックスの存在はデータロスのリスクを示す可能性があるため、運用者はDanglingインデックスを検出し、必要に応じてインポート（復旧）または削除する判断を行う必要がある。本APIはクラスタ全体のDanglingインデックスを一覧表示し、データ復旧の判断材料を提供する。

**画面へのアクセス方法**：REST APIクライアントから `GET /_dangling` エンドポイントにHTTP GETリクエストを送信してアクセスする。パラメータは不要。

**主要な操作・処理内容**：
1. クライアントがGETリクエストを送信する
2. 全ノードにDanglingインデックスの問い合わせがブロードキャストされる（TransportNodesAction）
3. 各ノードがDanglingIndicesStateからローカルのDanglingインデックス情報を収集する
4. 全ノードの応答を集約し、Danglingインデックス一覧として返却する
5. 各Danglingインデックスについてインデックス名、UUID、作成日時、ノード情報が返される

**画面遷移**：本APIでDanglingインデックスを発見した後、Danglingインデックスインポート（POST /_dangling/{index_uuid}）でクラスタに復旧するか、Danglingインデックス削除（DELETE /_dangling/{index_uuid}）で完全に削除する。

**権限による表示制御**：クラスタレベルの管理権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | インデックス作成 | 主機能 | すべてのDanglingインデックスを返す処理 |

## 画面種別

一覧（REST API - 情報一覧取得）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_dangling` | 全Danglingインデックスの一覧を取得 |

## 入出力項目

### パスパラメータ

なし

### クエリパラメータ

なし（API specではparamsが空オブジェクト）

## 表示項目

### レスポンスボディ

| 項目名 | 型 | 説明 |
|--------|------|------|
| _nodes | object | ノード統計 |
| _nodes.total | integer | 問い合わせた総ノード数 |
| _nodes.successful | integer | 応答に成功したノード数 |
| _nodes.failed | integer | 応答に失敗したノード数 |
| cluster_name | string | クラスタ名 |
| dangling_indices | array | Danglingインデックスの配列 |
| dangling_indices[].index_name | string | インデックス名 |
| dangling_indices[].index_uuid | string | インデックスUUID |
| dangling_indices[].creation_date_millis | long | 作成日時（エポックミリ秒） |
| dangling_indices[].node_ids | array | Danglingインデックスが存在するノードIDの配列 |

## イベント仕様

### 1-Danglingインデックス一覧取得リクエスト

クライアントからGETリクエストを受信すると以下の処理が実行される：

1. RestListDanglingIndicesActionがListDanglingIndicesRequestを生成する（パラメータなし）
2. TransportListDanglingIndicesAction（TransportNodesAction）が全ノードにリクエストをブロードキャストする
3. 各ノードのnodeOperation()が実行される
4. DanglingIndicesStateからローカルのDanglingインデックスメタデータを取得する
5. 各Danglingインデックスについてインデックス名、UUID、作成日時をDanglingIndexInfoとして収集する
6. 全ノードの結果をListDanglingIndicesResponseに集約する
7. NodesResponseRestListenerを通じてJSON形式で返却する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| GET リクエスト | - | SELECT（読み取り専用） | Danglingインデックス情報の読み取りのみ。データ変更なし |

## メッセージ仕様

| HTTPステータス | 条件 | メッセージ例 |
|---------------|------|-------------|
| 200 OK | 正常取得（Danglingインデックスあり） | Danglingインデックス一覧のJSONレスポンス |
| 200 OK | 正常取得（Danglingインデックスなし） | 空のdangling_indices配列 |

## 例外処理

| 例外 | 条件 | 対処 |
|------|------|------|
| FailedNodeException | 特定ノードからの応答失敗 | 失敗ノード情報を_nodesに記録し、成功ノードの結果のみ返却 |

## 備考

- パラメータが一切不要なシンプルなAPIである
- TransportNodesActionを使用しており、全ノードにブロードキャストされる
- DanglingインデックスはDanglingIndicesStateクラスが管理しており、ノードのローカルデータディレクトリのインデックスとクラスタ状態のインデックスの差分を検出する
- レスポンスはNodesResponseRestListenerを使用してノード応答を集約する

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ListDanglingIndicesRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/dangling/list/ListDanglingIndicesRequest.java` | リクエスト定義（パラメータなし） |
| 1-2 | ListDanglingIndicesResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/dangling/list/ListDanglingIndicesResponse.java` | レスポンス構造（ノード応答の集約） |
| 1-3 | DanglingIndexInfo.java | `server/src/main/java/org/opensearch/action/admin/indices/dangling/DanglingIndexInfo.java` | Danglingインデックスの情報構造（indexName, indexUUID, creationDateMillis） |

**読解のコツ**: DanglingIndexInfoがレスポンスJSONのdangling_indices配列の各要素に対応する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestListDanglingIndicesAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/dangling/RestListDanglingIndicesAction.java` | ルーティング定義（55行目）とリクエスト生成（64-68行目） |

**主要処理フロー**:
1. **55行目**: `GET /_dangling` のルーティング定義
2. **65行目**: ListDanglingIndicesRequestを生成（パラメータなし）
3. **66-68行目**: NodeClient経由でlistDanglingIndicesアクションを実行。NodesResponseRestListenerで応答

#### Step 3: Transport層の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportListDanglingIndicesAction.java | `server/src/main/java/org/opensearch/action/admin/indices/dangling/list/TransportListDanglingIndicesAction.java` | TransportNodesActionによる全ノードブロードキャスト。DanglingIndicesStateからの情報収集 |

#### Step 4: Danglingインデックス検出メカニズムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | DanglingIndicesState.java | `server/src/main/java/org/opensearch/gateway/DanglingIndicesState.java` | Danglingインデックスの検出ロジック。ローカルデータディレクトリとクラスタ状態の差分検出 |

### プログラム呼び出し階層図

```
RestListDanglingIndicesAction#prepareRequest()
    |
    +-- NodeClient#admin().cluster().listDanglingIndices()
            |
            +-- TransportListDanglingIndicesAction (TransportNodesAction)
                    |
                    +-- 各ノードで nodeOperation() 実行
                    |       |
                    |       +-- DanglingIndicesState#getDanglingIndices()
                    |       |       (ローカルDanglingインデックス検出)
                    |       |
                    |       +-- DanglingIndexInfo 生成
                    |               (indexName, indexUUID, creationDate)
                    |
                    +-- ListDanglingIndicesResponse (全ノード結果集約)
```

### データフロー図

```
[入力]                  [処理]                              [出力]

GET /_dangling         RestListDanglingIndicesAction       ListDanglingIndicesResponse
(パラメータなし)        (リクエスト生成)                      (JSON)
                              |
                              v
                    TransportListDanglingIndicesAction
                    (全ノードにブロードキャスト)
                              |
                +-------------+-------------+
                |             |             |
            Node1          Node2         Node3
            DanglingState  DanglingState  DanglingState
                |             |             |
            DanglingIndex  DanglingIndex  (なし)
            Info[]         Info[]
                |             |
                +------+------+
                       |
                ListDanglingIndicesResponse
                (集約結果)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestListDanglingIndicesAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/dangling/RestListDanglingIndicesAction.java` | ソース | RESTハンドラ |
| TransportListDanglingIndicesAction.java | `server/src/main/java/org/opensearch/action/admin/indices/dangling/list/TransportListDanglingIndicesAction.java` | ソース | Transportアクション（ノードブロードキャスト型） |
| ListDanglingIndicesRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/dangling/list/ListDanglingIndicesRequest.java` | ソース | リクエストモデル |
| ListDanglingIndicesResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/dangling/list/ListDanglingIndicesResponse.java` | ソース | レスポンスモデル |
| DanglingIndexInfo.java | `server/src/main/java/org/opensearch/action/admin/indices/dangling/DanglingIndexInfo.java` | ソース | Danglingインデックス情報データ |
| DanglingIndicesState.java | `server/src/main/java/org/opensearch/gateway/DanglingIndicesState.java` | ソース | Danglingインデックス検出・管理 |
| dangling_indices.list_dangling_indices.json | `rest-api-spec/src/main/resources/rest-api-spec/api/dangling_indices.list_dangling_indices.json` | API定義 | REST API仕様定義 |
