# 画面設計書 131-パイプライン取得

## 概要

本ドキュメントは、OpenSearchのIngestパイプライン取得API（`GET /_ingest/pipeline/{id}`）の画面設計書である。登録済みのインジェストパイプラインの定義情報を取得するためのREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIは、OpenSearchクラスタに登録されているインジェストパイプラインの定義情報をJSON形式で返却するエンドポイントである。

**業務上の目的・背景**：インジェストパイプラインはドキュメント登録時にデータを前処理する仕組みであり、運用者がパイプラインの現在の設定内容を確認することは、データ取り込みフローの管理・トラブルシューティングにおいて不可欠である。パイプラインの構成が意図通りであるかの検証や、既存パイプラインの確認後の更新判断に利用される。

**画面へのアクセス方法**：HTTPクライアント（curl、OpenSearch Dashboards Dev Toolsなど）から `GET /_ingest/pipeline` または `GET /_ingest/pipeline/{id}` へリクエストを送信する。

**主要な操作・処理内容**：
1. クライアントがパイプラインIDを指定（またはワイルドカード/省略）してGETリクエストを送信する
2. RestGetPipelineActionがリクエストを受け取り、GetPipelineRequestを構築する
3. クラスタマネージャノードからクラスタ状態に格納されたパイプライン定義を取得する
4. パイプライン定義をJSON形式でレスポンスとして返却する

**画面遷移**：本APIで取得したパイプライン定義を基に、パイプライン作成・更新API（132）で更新、パイプライン削除API（133）で削除、パイプラインシミュレーションAPI（134）でテストを行う流れが一般的である。

**権限による表示制御**：クラスタのメタデータ読み取り権限（cluster:admin/ingest/pipeline/get）が必要。権限不足の場合は403エラーが返却される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 36 | インジェストパイプライン | 主機能 | インジェストパイプラインの定義を返す処理 |

## 画面種別

詳細（REST API GETエンドポイント）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_ingest/pipeline` | 全パイプラインの定義を返す |
| GET | `/_ingest/pipeline/{id}` | 指定IDのパイプライン定義を返す |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|-----|------|------|
| id | string | いいえ | パイプラインID（カンマ区切りで複数指定可能、ワイルドカード対応） |

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|-----|------|-----------|------|
| cluster_manager_timeout | time | いいえ | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | いいえ | 30s | （非推奨）cluster_manager_timeoutを使用すること |

## 表示項目

### レスポンスボディ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| {pipeline_id} | object | パイプラインIDをキーとしたパイプライン定義 |
| {pipeline_id}.description | string | パイプラインの説明 |
| {pipeline_id}.processors | array | プロセッサ定義の配列 |
| {pipeline_id}.version | integer | パイプラインのバージョン番号 |
| {pipeline_id}.on_failure | array | 失敗時のプロセッサ定義 |

## イベント仕様

### 1-パイプライン取得リクエスト

クライアントからGETリクエストを受信すると、RestGetPipelineActionの`prepareRequest`メソッドが呼び出される。パスパラメータ`id`をカンマ区切りで分割し、GetPipelineRequestオブジェクトを生成する。クラスタマネージャノードのタイムアウト設定を適用した後、`client.admin().cluster().getPipeline()`を呼び出してクラスタ状態からパイプライン定義を取得する。取得結果はRestStatusToXContentListenerを通じてJSON形式でレスポンスに変換される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| パイプライン取得 | ClusterState（IngestMetadata） | SELECT | クラスタ状態からパイプライン定義を読み取り |

### テーブル別更新項目詳細

#### ClusterState - IngestMetadata

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | pipelines | 指定IDに一致するパイプライン定義を取得 | ワイルドカードパターンマッチング対応 |

## メッセージ仕様

| メッセージID | メッセージ内容 | 種別 | 発生条件 |
|-------------|--------------|------|---------|
| 200 | パイプライン定義のJSONレスポンス | 成功 | パイプラインが存在する場合 |
| 404 | パイプラインが見つからない | エラー | 指定IDのパイプラインが存在しない場合 |
| 403 | 権限不足 | エラー | 必要な権限がない場合 |

## 例外処理

- **パイプラインが存在しない場合**: 指定したIDのパイプラインが見つからない場合、ResourceNotFoundExceptionがスローされ、HTTPステータス404が返却される
- **クラスタマネージャノードへの接続タイムアウト**: 指定したタイムアウト時間内にクラスタマネージャノードから応答がない場合、タイムアウトエラーが返却される
- **クラスタブロック**: クラスタ全体にメタデータ読み取りブロックが設定されている場合、ClusterBlockExceptionが返却される

## 備考

- `master_timeout` パラメータはバージョン2.0.0で非推奨となり、`cluster_manager_timeout` の使用が推奨される
- IDを省略した場合は、全パイプラインの定義が返却される
- ワイルドカード（`*`）を使用したパターンマッチングによるパイプライン取得が可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、パイプライン取得リクエスト・レスポンスに関わるデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GetPipelineRequest.java | `server/src/main/java/org/opensearch/action/ingest/GetPipelineRequest.java` | パイプライン取得リクエストのデータ構造。id配列の保持方法を確認 |
| 1-2 | GetPipelineResponse.java | `server/src/main/java/org/opensearch/action/ingest/GetPipelineResponse.java` | レスポンスのシリアライズ方法、XContent変換ロジックを確認 |
| 1-3 | IngestMetadata.java | `server/src/main/java/org/opensearch/ingest/IngestMetadata.java` | クラスタ状態に格納されるパイプラインメタデータの構造 |

**読解のコツ**: GetPipelineRequestは`ClusterManagerNodeReadRequest`を継承しており、クラスタマネージャノードで処理されるリードオンリーリクエストであることに注意。

#### Step 2: エントリーポイントを理解する

REST層のエントリーポイントを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestGetPipelineAction.java | `server/src/main/java/org/opensearch/rest/action/ingest/RestGetPipelineAction.java` | RESTリクエストからGetPipelineRequestへの変換処理 |

**主要処理フロー**:
1. **行61**: ルート定義 - `GET /_ingest/pipeline` と `GET /_ingest/pipeline/{id}` の2パスを登録
2. **行71**: `prepareRequest` - IDパラメータをカンマ区切りで分割しGetPipelineRequestを生成
3. **行72-73**: クラスタマネージャタイムアウトの設定（非推奨パラメータの互換処理含む）
4. **行74**: `client.admin().cluster().getPipeline()` を呼び出し、RestStatusToXContentListenerでレスポンス変換

#### Step 3: トランスポート層を理解する

クラスタマネージャノードでのパイプライン取得処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | IngestService.java | `server/src/main/java/org/opensearch/ingest/IngestService.java` | `getPipelines()`メソッドでクラスタ状態からパイプライン定義を取得するロジック |

**主要処理フロー**:
- クラスタ状態の`IngestMetadata`からIDパターンに一致するパイプラインを検索
- ワイルドカードマッチングは`Regex.simpleMatch()`を使用

### プログラム呼び出し階層図

```
RestGetPipelineAction.prepareRequest()
    |
    +-- GetPipelineRequest(ids[])
    |
    +-- client.admin().cluster().getPipeline()
            |
            +-- TransportClusterManagerNodeReadAction
                    |
                    +-- IngestService.getPipelines(ClusterState, ids[])
                            |
                            +-- ClusterState.metadata().custom(IngestMetadata.TYPE)
                            |
                            +-- Regex.simpleMatch() (ワイルドカード対応)
                    |
                    +-- GetPipelineResponse(pipelines)
                            |
                            +-- RestStatusToXContentListener -> JSONレスポンス
```

### データフロー図

```
[入力]                    [処理]                              [出力]

GET /_ingest/pipeline/{id}
    |
    +-- id (パスパラメータ) --> RestGetPipelineAction          --> GetPipelineRequest
    +-- cluster_manager_timeout      |                              |
                                     v                              v
                              NodeClient.getPipeline()     ClusterState読み取り
                                     |                              |
                                     v                              v
                              IngestMetadata検索            GetPipelineResponse
                                                                    |
                                                                    v
                                                           JSON レスポンス (200/404)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestGetPipelineAction.java | `server/src/main/java/org/opensearch/rest/action/ingest/RestGetPipelineAction.java` | ソース | RESTエントリーポイント |
| GetPipelineRequest.java | `server/src/main/java/org/opensearch/action/ingest/GetPipelineRequest.java` | ソース | リクエストデータ構造 |
| GetPipelineResponse.java | `server/src/main/java/org/opensearch/action/ingest/GetPipelineResponse.java` | ソース | レスポンスデータ構造 |
| GetPipelineAction.java | `server/src/main/java/org/opensearch/action/ingest/GetPipelineAction.java` | ソース | アクション定義 |
| IngestMetadata.java | `server/src/main/java/org/opensearch/ingest/IngestMetadata.java` | ソース | パイプラインメタデータ管理 |
| IngestService.java | `server/src/main/java/org/opensearch/ingest/IngestService.java` | ソース | パイプライン管理サービス |
| ingest.get_pipeline.json | `rest-api-spec/src/main/resources/rest-api-spec/api/ingest.get_pipeline.json` | API仕様 | REST API仕様定義 |
