# 画面設計書 133-パイプライン削除

## 概要

本ドキュメントは、OpenSearchのIngestパイプライン削除API（`DELETE /_ingest/pipeline/{id}`）の画面設計書である。登録済みのインジェストパイプラインをクラスタ状態から削除するためのREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIは、OpenSearchクラスタに登録されているインジェストパイプラインを削除するエンドポイントである。削除操作はクラスタ状態の更新を伴い、全ノードに伝播される。

**業務上の目的・背景**：不要になったインジェストパイプラインの整理や、誤って作成されたパイプラインの削除に使用される。パイプラインが参照されているインデックス設定を事前に確認し、影響範囲を把握した上で削除操作を行うことが運用上重要である。

**画面へのアクセス方法**：HTTPクライアントから `DELETE /_ingest/pipeline/{id}` へリクエストを送信する。

**主要な操作・処理内容**：
1. クライアントがパイプラインIDを指定してDELETEリクエストを送信する
2. RestDeletePipelineActionがリクエストを受け取り、DeletePipelineRequestを構築する
3. IngestServiceがクラスタ状態からパイプライン定義を削除する
4. クラスタ状態の更新が全ノードに伝播された後、確認レスポンスを返却する

**画面遷移**：パイプライン取得API（131）で既存定義を確認した後に本APIで削除を行う。削除前にパイプラインを参照しているインデックス設定を確認することが推奨される。

**権限による表示制御**：クラスタのインジェストパイプライン管理権限が必要。権限不足の場合は403エラーが返却される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 36 | インジェストパイプライン | 主機能 | インジェストパイプラインを削除する処理 |

## 画面種別

削除（REST API DELETEエンドポイント）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| DELETE | `/_ingest/pipeline/{id}` | 指定IDのパイプラインを削除する |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|-----|------|------|
| id | string | はい | パイプラインID |

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|-----|------|-----------|------|
| cluster_manager_timeout | time | いいえ | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | いいえ | 30s | （非推奨）cluster_manager_timeoutを使用すること |
| timeout | time | いいえ | 30s | 操作の明示的タイムアウト |

## 表示項目

### レスポンスボディ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| acknowledged | boolean | クラスタ状態の更新が全ノードに承認されたか |

## イベント仕様

### 1-パイプライン削除リクエスト

クライアントからDELETEリクエストを受信すると、RestDeletePipelineActionの`prepareRequest`メソッドが呼び出される。パスパラメータからパイプラインIDを取得し、DeletePipelineRequestオブジェクトを生成する。クラスタマネージャタイムアウトと操作タイムアウトを設定した後、`client.admin().cluster().deletePipeline()`を呼び出す。IngestServiceはクラスタ状態のIngestMetadataから指定IDのパイプライン定義を削除し、AckedClusterStateUpdateTaskを通じてクラスタ状態を更新する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| パイプライン削除 | ClusterState（IngestMetadata） | DELETE | クラスタ状態からパイプライン定義を削除 |

### テーブル別更新項目詳細

#### ClusterState - IngestMetadata

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | pipelines[{id}] | 指定IDのパイプライン定義を削除 | パイプラインが存在しない場合はエラー |

## メッセージ仕様

| メッセージID | メッセージ内容 | 種別 | 発生条件 |
|-------------|--------------|------|---------|
| 200 | `{"acknowledged": true}` | 成功 | パイプラインが正常に削除された場合 |
| 404 | パイプラインが見つからない | エラー | 指定IDのパイプラインが存在しない場合 |
| 403 | 権限不足 | エラー | 必要な権限がない場合 |

## 例外処理

- **パイプラインが存在しない場合**: 指定IDのパイプラインが見つからない場合、ResourceNotFoundExceptionがスローされHTTPステータス404が返却される
- **クラスタマネージャノード接続タイムアウト**: 指定時間内にクラスタマネージャノードから応答がない場合、タイムアウトエラーが返却される
- **クラスタブロック**: クラスタ全体にメタデータ書き込みブロックが設定されている場合、ClusterBlockExceptionが返却される

## 備考

- パイプラインを削除しても、既にインジェスト処理済みのドキュメントには影響しない
- 削除したパイプラインを参照しているインデックス設定（default_pipeline等）がある場合、以降のドキュメント登録時にエラーとなる可能性がある
- `master_timeout` パラメータはバージョン2.0.0で非推奨

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DeletePipelineRequest.java | `server/src/main/java/org/opensearch/action/ingest/DeletePipelineRequest.java` | 削除リクエストの構造。idフィールドの保持方法 |

**読解のコツ**: DeletePipelineRequestは`AcknowledgedRequest`を継承しており、タイムアウト付きのクラスタ状態更新リクエストである。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestDeletePipelineAction.java | `server/src/main/java/org/opensearch/rest/action/ingest/RestDeletePipelineAction.java` | RESTリクエストからDeletePipelineRequestへの変換処理 |

**主要処理フロー**:
1. **行58**: ルート定義 - `DELETE /_ingest/pipeline/{id}` を登録
2. **行68**: パスパラメータ`id`を取得してDeletePipelineRequestを生成
3. **行69-71**: タイムアウト設定の適用（cluster_manager_timeout, master_timeout, timeout）
4. **行72**: `client.admin().cluster().deletePipeline()` を呼び出し

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | IngestService.java | `server/src/main/java/org/opensearch/ingest/IngestService.java` | `delete()`メソッドによるクラスタ状態からのパイプライン削除処理 |

### プログラム呼び出し階層図

```
RestDeletePipelineAction.prepareRequest()
    |
    +-- DeletePipelineRequest(id)
    |
    +-- client.admin().cluster().deletePipeline()
            |
            +-- IngestService.delete()
                    |
                    +-- AckedClusterStateUpdateTask
                            |
                            +-- ClusterState.metadata() - IngestMetadataからパイプライン削除
                    |
                    +-- AcknowledgedResponse -> JSONレスポンス
```

### データフロー図

```
[入力]                          [処理]                              [出力]

DELETE /_ingest/pipeline/{id}
    |
    +-- id (パスパラメータ)    --> RestDeletePipelineAction          --> DeletePipelineRequest
    +-- timeout                      |                                    |
                                     v                                    v
                              IngestService.delete()              ClusterState更新
                                                                         |
                                                                         v
                                                              {"acknowledged": true}
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestDeletePipelineAction.java | `server/src/main/java/org/opensearch/rest/action/ingest/RestDeletePipelineAction.java` | ソース | RESTエントリーポイント |
| DeletePipelineRequest.java | `server/src/main/java/org/opensearch/action/ingest/DeletePipelineRequest.java` | ソース | リクエストデータ構造 |
| DeletePipelineAction.java | `server/src/main/java/org/opensearch/action/ingest/DeletePipelineAction.java` | ソース | アクション定義 |
| IngestService.java | `server/src/main/java/org/opensearch/ingest/IngestService.java` | ソース | パイプライン管理サービス |
| IngestMetadata.java | `server/src/main/java/org/opensearch/ingest/IngestMetadata.java` | ソース | パイプラインメタデータ管理 |
| ingest.delete_pipeline.json | `rest-api-spec/src/main/resources/rest-api-spec/api/ingest.delete_pipeline.json` | API仕様 | REST API仕様定義 |
