# 画面設計書 135-Grokパターン一覧

## 概要

本ドキュメントは、OpenSearchのGrokプロセッサパターン一覧API（`GET /_ingest/processor/grok`）の画面設計書である。Grokプロセッサで使用可能な組み込みパターンの一覧を取得するためのREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIは、Grokプロセッサが使用できる組み込みのGrokパターン定義一覧をJSON形式で返却するエンドポイントである。Grokパターンは正規表現ベースのテキスト解析パターンであり、ログデータの構造化解析に広く使用される。

**業務上の目的・背景**：Grokプロセッサはインジェストパイプラインの中核的なプロセッサの一つであり、非構造化テキスト（ログファイルなど）を構造化データに変換する。利用可能なGrokパターンを一覧で確認できることで、パイプライン設計者は既存パターンの再利用や、カスタムパターン作成の参考にすることができる。Apacheログ、Syslog、Windowsイベントログなど、多様なフォーマットの解析パターンが組み込みで提供されている。

**画面へのアクセス方法**：HTTPクライアントから `GET /_ingest/processor/grok` へリクエストを送信する。

**主要な操作・処理内容**：
1. クライアントがGETリクエストを送信する
2. GrokProcessorGetAction.RestActionがリクエストを受け取る
3. Grok.BUILTIN_PATTERNSから組み込みパターンを取得する
4. パターン名と正規表現のマップをJSON形式で返却する

**画面遷移**：本APIで利用可能なGrokパターンを確認した後、パイプライン作成・更新API（132）でGrokプロセッサを含むパイプラインを作成し、パイプラインシミュレーションAPI（134）で動作を検証する流れが一般的である。

**権限による表示制御**：クラスタのインジェストプロセッサ情報取得権限（cluster:admin/ingest/processor/grok/get）が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 37 | インジェスト共通プロセッサ | 主機能 | 組み込みGrokパターンの一覧を返す処理 |

## 画面種別

一覧（REST API GETエンドポイント）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_ingest/processor/grok` | 組み込みGrokパターン一覧を返す |

## 入出力項目

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|-----|------|-----------|------|
| s | boolean | いいえ | false | パターンをアルファベット順にソートするか |

## 表示項目

### レスポンスボディ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| patterns | object | Grokパターン名をキー、正規表現をバリューとしたマップ |

レスポンス例：
```json
{
  "patterns": {
    "WORD": "\\b\\w+\\b",
    "IP": "...",
    "TIMESTAMP_ISO8601": "..."
  }
}
```

## イベント仕様

### 1-Grokパターン一覧取得リクエスト

クライアントからGETリクエストを受信すると、GrokProcessorGetAction.RestActionの`prepareRequest`メソッドが呼び出される。クエリパラメータ`s`を取得しソートフラグとしてRequestオブジェクトを生成する。`client.executeLocally()`を使用してローカルノードでTransportActionを実行する。TransportActionの`doExecute`メソッドでは、ソートフラグがtrueの場合はTreeMapでソートされたパターンを、falseの場合は元のパターンマップをそのまま返却する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Grokパターン一覧取得 | なし | なし | メモリ内の組み込みパターンを返却（データ更新なし） |

## メッセージ仕様

| メッセージID | メッセージ内容 | 種別 | 発生条件 |
|-------------|--------------|------|---------|
| 200 | Grokパターン一覧のJSONレスポンス | 成功 | 正常にパターン一覧を取得できた場合 |

## 例外処理

- **内部エラー**: TransportAction.doExecuteでの例外発生時、listener.onFailure()を通じてエラーレスポンスが返却される
- 本APIはクラスタ状態を参照しないため、クラスタブロックの影響を受けない

## 備考

- 本APIはingest-commonモジュールで提供される（プラグインレベルの実装）
- Grokパターンは`Grok.BUILTIN_PATTERNS`として静的に定義されており、クラスタ状態には依存しない
- ソートオプション(`s`)を使用すると、パターン名のアルファベット順で返却される
- ローカルノードで実行されるため、クラスタマネージャノードへの通信は発生しない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GrokProcessorGetAction.java | `modules/ingest-common/src/main/java/org/opensearch/ingest/common/GrokProcessorGetAction.java` | Request/Responseの内部クラス構造、patternsマップの形式 |
| 1-2 | Grok.java | `libs/grok/src/main/java/org/opensearch/grok/Grok.java` | BUILTIN_PATTERNSの定義と組み込みパターンの読み込み |

**読解のコツ**: GrokProcessorGetActionは1ファイルにActionType、Request、Response、TransportAction、RestActionの全クラスが定義されている点に注意。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GrokProcessorGetAction.RestAction | `modules/ingest-common/src/main/java/org/opensearch/ingest/common/GrokProcessorGetAction.java` (行158-176) | REST層のリクエスト処理 |

**主要処理フロー**:
1. **行162**: ルート定義 - `GET /_ingest/processor/grok` を登録
2. **行172**: クエリパラメータ`s`をboolean値として取得（デフォルト: false）
3. **行173**: GrokProcessorGetAction.Request(sorted)を生成
4. **行174**: `client.executeLocally(INSTANCE, request, listener)` でローカル実行

#### Step 3: トランスポート層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GrokProcessorGetAction.TransportAction | `modules/ingest-common/src/main/java/org/opensearch/ingest/common/GrokProcessorGetAction.java` (行131-156) | パターン取得のビジネスロジック |

**主要処理フロー**:
- **行138**: Grok.BUILTIN_PATTERNSから組み込みパターンを取得
- **行145**: ソート用にTreeMapを事前生成
- **行149-155**: doExecuteで、sortedフラグに応じてソート済み/未ソートのパターンマップを返却

### プログラム呼び出し階層図

```
GrokProcessorGetAction.RestAction.prepareRequest()
    |
    +-- Request(sorted=s)
    |
    +-- client.executeLocally(INSTANCE, request)
            |
            +-- GrokProcessorGetAction.TransportAction.doExecute()
                    |
                    +-- sorted ? sortedGrokPatterns : grokPatterns
                    |       |
                    |       +-- Grok.BUILTIN_PATTERNS (ソースパターン)
                    |       +-- TreeMap(grokPatterns) (ソート済み)
                    |
                    +-- Response(patterns) -> JSONレスポンス
```

### データフロー図

```
[入力]                      [処理]                              [出力]

GET /_ingest/processor/grok
    |
    +-- s (ソートフラグ)  --> RestAction.prepareRequest()       --> Request(sorted)
                                |                                     |
                                v                                     v
                         TransportAction.doExecute()          Grok.BUILTIN_PATTERNS
                                |                                     |
                                v                                     v
                         ソート判定                            Response(patterns)
                                                                      |
                                                                      v
                                                            {"patterns": {...}}
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| GrokProcessorGetAction.java | `modules/ingest-common/src/main/java/org/opensearch/ingest/common/GrokProcessorGetAction.java` | ソース | Action/Rest/Transport全体定義 |
| Grok.java | `libs/grok/src/main/java/org/opensearch/grok/Grok.java` | ソース | 組み込みGrokパターン定義 |
| IngestCommonPlugin.java | `modules/ingest-common/src/main/java/org/opensearch/ingest/common/IngestCommonPlugin.java` | ソース | プラグイン登録 |
| ingest.processor_grok.json | `rest-api-spec/src/main/resources/rest-api-spec/api/ingest.processor_grok.json` | API仕様 | REST API仕様定義 |
