# 画面設計書 136-検索パイプライン取得

## 概要

本ドキュメントは、OpenSearchの検索パイプライン取得API（`GET /_search/pipeline/{id}`）の画面設計書である。登録済みの検索パイプラインの定義情報を取得するためのREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIは、OpenSearchクラスタに登録されている検索パイプラインの定義情報をJSON形式で返却するエンドポイントである。検索パイプラインは検索リクエストの前処理（request processors）と検索レスポンスの後処理（response processors）を定義するものである。

**業務上の目的・背景**：検索パイプラインは、検索リクエストや検索レスポンスを自動的に加工する仕組みであり、検索クエリの書き換え、レスポンスのリランキング、パーソナライゼーションなどの機能を提供する。運用者が検索パイプラインの現在の設定内容を確認することは、検索品質の管理やトラブルシューティングにおいて重要である。

**画面へのアクセス方法**：HTTPクライアントから `GET /_search/pipeline` または `GET /_search/pipeline/{id}` へリクエストを送信する。

**主要な操作・処理内容**：
1. クライアントがパイプラインIDを指定（またはワイルドカード/省略）してGETリクエストを送信する
2. RestGetSearchPipelineActionがリクエストを受け取り、GetSearchPipelineRequestを構築する
3. クラスタマネージャノードからクラスタ状態に格納された検索パイプライン定義を取得する
4. パイプライン定義をJSON形式でレスポンスとして返却する

**画面遷移**：本APIで取得した検索パイプライン定義を基に、検索パイプライン作成・更新API（137）で更新、検索パイプライン削除API（138）で削除を行う流れが一般的である。検索API（21）に検索パイプラインを適用して使用する。

**権限による表示制御**：クラスタのメタデータ読み取り権限が必要。権限不足の場合は403エラーが返却される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 45 | 検索パイプライン管理 | 主機能 | 検索パイプラインの定義を返す処理 |

## 画面種別

詳細（REST API GETエンドポイント）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_search/pipeline` | 全検索パイプラインの定義を返す |
| GET | `/_search/pipeline/{id}` | 指定IDの検索パイプライン定義を返す |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|-----|------|------|
| id | string | いいえ | パイプラインID（カンマ区切りで複数指定可能、ワイルドカード対応） |

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|-----|------|-----------|------|
| cluster_manager_timeout | time | いいえ | 30s | クラスタマネージャノードへの接続タイムアウト |

## 表示項目

### レスポンスボディ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| {pipeline_id} | object | パイプラインIDをキーとしたパイプライン定義 |
| {pipeline_id}.description | string | パイプラインの説明 |
| {pipeline_id}.request_processors | array | リクエストプロセッサ定義の配列 |
| {pipeline_id}.response_processors | array | レスポンスプロセッサ定義の配列 |
| {pipeline_id}.phase_results_processors | array | フェーズ結果プロセッサ定義の配列 |
| {pipeline_id}.version | integer | パイプラインのバージョン番号 |

## イベント仕様

### 1-検索パイプライン取得リクエスト

クライアントからGETリクエストを受信すると、RestGetSearchPipelineActionの`prepareRequest`メソッドが呼び出される。パスパラメータ`id`をカンマ区切りで分割し、GetSearchPipelineRequestオブジェクトを生成する。クラスタマネージャノードのタイムアウト設定を適用した後、`client.admin().cluster().getSearchPipeline()`を呼び出してクラスタ状態から検索パイプライン定義を取得する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 検索パイプライン取得 | ClusterState（SearchPipelineMetadata） | SELECT | クラスタ状態から検索パイプライン定義を読み取り |

### テーブル別更新項目詳細

#### ClusterState - SearchPipelineMetadata

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | pipelines | 指定IDに一致する検索パイプライン定義を取得 | ワイルドカードパターンマッチング対応 |

## メッセージ仕様

| メッセージID | メッセージ内容 | 種別 | 発生条件 |
|-------------|--------------|------|---------|
| 200 | 検索パイプライン定義のJSONレスポンス | 成功 | パイプラインが存在する場合 |
| 404 | パイプラインが見つからない | エラー | 指定IDのパイプラインが存在しない場合 |
| 403 | 権限不足 | エラー | 必要な権限がない場合 |

## 例外処理

- **パイプラインが存在しない場合**: 指定IDのパイプラインが見つからない場合、ResourceNotFoundExceptionがスローされHTTPステータス404が返却される
- **クラスタマネージャノード接続タイムアウト**: 指定時間内に応答がない場合、タイムアウトエラーが返却される

## 備考

- 検索パイプラインはIngestパイプラインとは独立した仕組みであり、検索リクエスト/レスポンスの加工に特化している
- IDを省略した場合は全検索パイプラインの定義が返却される
- インジェストパイプライン取得APIとは異なり、`master_timeout`（非推奨パラメータ）は存在しない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GetSearchPipelineRequest.java | `server/src/main/java/org/opensearch/action/search/GetSearchPipelineRequest.java` | 検索パイプライン取得リクエストの構造 |
| 1-2 | GetSearchPipelineResponse.java | `server/src/main/java/org/opensearch/action/search/GetSearchPipelineResponse.java` | レスポンスの構造とXContent変換 |
| 1-3 | SearchPipelineMetadata.java | `server/src/main/java/org/opensearch/search/pipeline/SearchPipelineMetadata.java` | クラスタ状態内の検索パイプラインメタデータ |

**読解のコツ**: 検索パイプラインはrequest_processors、response_processors、phase_results_processorsの3種のプロセッサを持つ構造に注意。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestGetSearchPipelineAction.java | `server/src/main/java/org/opensearch/rest/action/search/RestGetSearchPipelineAction.java` | RESTリクエストの受付処理 |

**主要処理フロー**:
1. **行36**: ルート定義 - `GET /_search/pipeline` と `GET /_search/pipeline/{id}` を登録
2. **行41**: パスパラメータ`id`をカンマ区切りで分割しGetSearchPipelineRequestを生成
3. **行42**: クラスタマネージャタイムアウトの設定
4. **行43**: `client.admin().cluster().getSearchPipeline()` を呼び出し

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SearchPipelineService.java | `server/src/main/java/org/opensearch/search/pipeline/SearchPipelineService.java` | 検索パイプライン管理サービス |

### プログラム呼び出し階層図

```
RestGetSearchPipelineAction.prepareRequest()
    |
    +-- GetSearchPipelineRequest(ids[])
    |
    +-- client.admin().cluster().getSearchPipeline()
            |
            +-- TransportClusterManagerNodeReadAction
                    |
                    +-- SearchPipelineMetadata取得
                    |
                    +-- GetSearchPipelineResponse -> JSONレスポンス
```

### データフロー図

```
[入力]                        [処理]                                [出力]

GET /_search/pipeline/{id}
    |
    +-- id (パスパラメータ) --> RestGetSearchPipelineAction         --> GetSearchPipelineRequest
    +-- cluster_manager_timeout    |                                      |
                                   v                                      v
                            NodeClient.getSearchPipeline()       ClusterState読み取り
                                   |                                      |
                                   v                                      v
                            SearchPipelineMetadata検索           GetSearchPipelineResponse
                                                                         |
                                                                         v
                                                              JSON レスポンス (200/404)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestGetSearchPipelineAction.java | `server/src/main/java/org/opensearch/rest/action/search/RestGetSearchPipelineAction.java` | ソース | RESTエントリーポイント |
| GetSearchPipelineRequest.java | `server/src/main/java/org/opensearch/action/search/GetSearchPipelineRequest.java` | ソース | リクエストデータ構造 |
| GetSearchPipelineResponse.java | `server/src/main/java/org/opensearch/action/search/GetSearchPipelineResponse.java` | ソース | レスポンスデータ構造 |
| SearchPipelineService.java | `server/src/main/java/org/opensearch/search/pipeline/SearchPipelineService.java` | ソース | 検索パイプライン管理サービス |
| SearchPipelineMetadata.java | `server/src/main/java/org/opensearch/search/pipeline/SearchPipelineMetadata.java` | ソース | メタデータ管理 |
| search_pipeline.get.json | `rest-api-spec/src/main/resources/rest-api-spec/api/search_pipeline.get.json` | API仕様 | REST API仕様定義 |
