# 画面設計書 137-検索パイプライン作成・更新

## 概要

本ドキュメントは、OpenSearchの検索パイプライン作成・更新API（`PUT /_search/pipeline/{id}`）の画面設計書である。検索パイプラインを新規作成または既存パイプラインを更新するためのREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIは、OpenSearchクラスタに検索パイプラインを登録・更新するエンドポイントである。検索パイプラインはrequest processors（検索リクエストの前処理）、response processors（検索レスポンスの後処理）、phase_results_processors（フェーズ結果の後処理）の3種類のプロセッサで構成される。

**業務上の目的・背景**：検索パイプラインは、検索リクエストの書き換えやレスポンスの加工を自動化する仕組みであり、検索品質の向上やカスタマイズに使用される。例えば、検索クエリへのデフォルトフィルタの追加、レスポンスのリランキング、パーソナライゼーション結果の付与などの用途がある。インジェストパイプラインがデータ登録時の前処理を担うのに対し、検索パイプラインは検索時の処理を担当する。

**画面へのアクセス方法**：HTTPクライアントから `PUT /_search/pipeline/{id}` へパイプライン定義をJSON形式のリクエストボディとともに送信する。

**主要な操作・処理内容**：
1. クライアントがパイプラインIDとパイプライン定義をPUTリクエストで送信する
2. RestPutSearchPipelineActionがリクエストを受け取り、PutSearchPipelineRequestを構築する
3. SearchPipelineServiceがパイプライン定義をバリデーションし、クラスタ状態を更新する
4. クラスタ状態の更新が全ノードに伝播された後、確認レスポンスを返却する

**画面遷移**：検索パイプライン取得API（136）で既存定義を確認した後に本APIで更新を行う。作成後は検索API（21）で`search_pipeline`パラメータを指定して使用する。

**権限による表示制御**：クラスタの検索パイプライン管理権限が必要。権限不足の場合は403エラーが返却される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 45 | 検索パイプライン管理 | 主機能 | 検索パイプラインを作成または更新する処理 |

## 画面種別

登録・編集（REST API PUTエンドポイント）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| PUT | `/_search/pipeline/{id}` | 検索パイプラインを作成または更新する |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|-----|------|------|
| id | string | はい | パイプラインID |

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|-----|------|-----------|------|
| cluster_manager_timeout | time | いいえ | 30s | クラスタマネージャノードへの接続タイムアウト |
| timeout | time | いいえ | 30s | 操作の明示的タイムアウト |

### リクエストボディ（必須）

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| description | string | いいえ | パイプラインの説明 |
| request_processors | array | いいえ | 検索リクエスト前処理プロセッサ定義の配列 |
| response_processors | array | いいえ | 検索レスポンス後処理プロセッサ定義の配列 |
| phase_results_processors | array | いいえ | フェーズ結果後処理プロセッサ定義の配列 |
| version | integer | いいえ | パイプラインのバージョン番号 |

## 表示項目

### レスポンスボディ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| acknowledged | boolean | クラスタ状態の更新が全ノードに承認されたか |

## イベント仕様

### 1-検索パイプライン作成・更新リクエスト

クライアントからPUTリクエストを受信すると、RestPutSearchPipelineActionの`prepareRequest`メソッドが呼び出される。リクエストボディからコンテンツとメディアタイプを抽出し、PutSearchPipelineRequestオブジェクトを生成する。クラスタマネージャタイムアウトと操作タイムアウトを設定した後、`client.admin().cluster().putSearchPipeline()`を呼び出す。SearchPipelineServiceはパイプライン定義のパースとバリデーションを行い、AckedClusterStateUpdateTaskを通じてクラスタ状態を更新する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 検索パイプライン作成・更新 | ClusterState（SearchPipelineMetadata） | INSERT/UPDATE | クラスタ状態に検索パイプライン定義を登録または更新 |

### テーブル別更新項目詳細

#### ClusterState - SearchPipelineMetadata

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | pipelines[{id}] | リクエストボディの検索パイプライン定義 | 同一IDのパイプラインが存在する場合は上書き |

## メッセージ仕様

| メッセージID | メッセージ内容 | 種別 | 発生条件 |
|-------------|--------------|------|---------|
| 200 | `{"acknowledged": true}` | 成功 | パイプラインが正常に作成・更新された場合 |
| 400 | パイプライン定義が不正 | エラー | プロセッサ定義にエラーがある場合 |
| 403 | 権限不足 | エラー | 必要な権限がない場合 |

## 例外処理

- **不正なパイプライン定義**: プロセッサの種別が不明、パラメータが不正な場合、OpenSearchParseExceptionがスローされHTTPステータス400が返却される
- **リクエストボディの欠如**: リクエストボディが空の場合、エラーが返却される
- **クラスタマネージャノード接続タイムアウト**: タイムアウトエラーが返却される
- **クラスタブロック**: メタデータ書き込みブロック設定時にClusterBlockExceptionが返却される

## 備考

- 同一IDのパイプラインが既に存在する場合は上書き更新される
- インジェストパイプラインとは異なる独立した管理体系（SearchPipelineMetadata）で管理される
- `master_timeout`（非推奨パラメータ）はこのAPIには存在しない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | PutSearchPipelineRequest.java | `server/src/main/java/org/opensearch/action/search/PutSearchPipelineRequest.java` | 登録リクエストの構造 |
| 1-2 | SearchPipelineMetadata.java | `server/src/main/java/org/opensearch/search/pipeline/SearchPipelineMetadata.java` | メタデータ構造 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestPutSearchPipelineAction.java | `server/src/main/java/org/opensearch/rest/action/search/RestPutSearchPipelineAction.java` | RESTリクエスト処理 |

**主要処理フロー**:
1. **行38**: ルート定義 - `PUT /_search/pipeline/{id}` を登録
2. **行43**: リクエストボディからコンテンツを取得
3. **行44**: PutSearchPipelineRequest(id, source, mediaType)を生成
4. **行45-46**: タイムアウト設定の適用
5. **行47**: `client.admin().cluster().putSearchPipeline()` を呼び出し

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SearchPipelineService.java | `server/src/main/java/org/opensearch/search/pipeline/SearchPipelineService.java` | パイプライン管理ロジック |

### プログラム呼び出し階層図

```
RestPutSearchPipelineAction.prepareRequest()
    |
    +-- PutSearchPipelineRequest(id, source, mediaType)
    |
    +-- client.admin().cluster().putSearchPipeline()
            |
            +-- SearchPipelineService.putPipeline()
                    |
                    +-- バリデーション・プロセッサ生成
                    |
                    +-- AckedClusterStateUpdateTask
                            |
                            +-- ClusterState.metadata().putCustom(SearchPipelineMetadata)
                    |
                    +-- AcknowledgedResponse -> JSONレスポンス
```

### データフロー図

```
[入力]                            [処理]                                [出力]

PUT /_search/pipeline/{id}
    |
    +-- id (パスパラメータ)      --> RestPutSearchPipelineAction       --> PutSearchPipelineRequest
    +-- リクエストボディ(JSON)          |                                     |
    +-- timeout                        v                                     v
                                SearchPipelineService.putPipeline()   バリデーション
                                       |                                     |
                                       v                                     v
                                ClusterState更新                     AcknowledgedResponse
                                                                            |
                                                                            v
                                                                  {"acknowledged": true}
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestPutSearchPipelineAction.java | `server/src/main/java/org/opensearch/rest/action/search/RestPutSearchPipelineAction.java` | ソース | RESTエントリーポイント |
| PutSearchPipelineRequest.java | `server/src/main/java/org/opensearch/action/search/PutSearchPipelineRequest.java` | ソース | リクエストデータ構造 |
| SearchPipelineService.java | `server/src/main/java/org/opensearch/search/pipeline/SearchPipelineService.java` | ソース | 検索パイプライン管理サービス |
| SearchPipelineMetadata.java | `server/src/main/java/org/opensearch/search/pipeline/SearchPipelineMetadata.java` | ソース | メタデータ管理 |
| search_pipeline.put.json | `rest-api-spec/src/main/resources/rest-api-spec/api/search_pipeline.put.json` | API仕様 | REST API仕様定義 |
