# 画面設計書 138-検索パイプライン削除

## 概要

本ドキュメントは、OpenSearchの検索パイプライン削除API（`DELETE /_search/pipeline/{id}`）の画面設計書である。登録済みの検索パイプラインをクラスタ状態から削除するためのREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIは、OpenSearchクラスタに登録されている検索パイプラインを削除するエンドポイントである。削除操作はクラスタ状態の更新を伴い、全ノードに伝播される。

**業務上の目的・背景**：不要になった検索パイプラインの整理や、誤って作成された検索パイプラインの削除に使用される。検索パイプラインがインデックス設定でデフォルトパイプラインとして設定されている場合、削除後に影響が出る可能性があるため、事前確認が重要である。

**画面へのアクセス方法**：HTTPクライアントから `DELETE /_search/pipeline/{id}` へリクエストを送信する。

**主要な操作・処理内容**：
1. クライアントがパイプラインIDを指定してDELETEリクエストを送信する
2. RestDeleteSearchPipelineActionがリクエストを受け取り、DeleteSearchPipelineRequestを構築する
3. SearchPipelineServiceがクラスタ状態から検索パイプライン定義を削除する
4. クラスタ状態の更新が全ノードに伝播された後、確認レスポンスを返却する

**画面遷移**：検索パイプライン取得API（136）で既存定義を確認した後に本APIで削除を行う。

**権限による表示制御**：クラスタの検索パイプライン管理権限が必要。権限不足の場合は403エラーが返却される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 45 | 検索パイプライン管理 | 主機能 | 検索パイプラインを削除する処理 |

## 画面種別

削除（REST API DELETEエンドポイント）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| DELETE | `/_search/pipeline/{id}` | 指定IDの検索パイプラインを削除する |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|-----|------|------|
| id | string | はい | パイプラインID |

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|-----|------|-----------|------|
| cluster_manager_timeout | time | いいえ | 30s | クラスタマネージャノードへの接続タイムアウト |
| timeout | time | いいえ | 30s | 操作の明示的タイムアウト |

## 表示項目

### レスポンスボディ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| acknowledged | boolean | クラスタ状態の更新が全ノードに承認されたか |

## イベント仕様

### 1-検索パイプライン削除リクエスト

クライアントからDELETEリクエストを受信すると、RestDeleteSearchPipelineActionの`prepareRequest`メソッドが呼び出される。パスパラメータからパイプラインIDを取得し、DeleteSearchPipelineRequestオブジェクトを生成する。クラスタマネージャタイムアウトと操作タイムアウトを設定した後、`client.admin().cluster().deleteSearchPipeline()`を呼び出す。SearchPipelineServiceはクラスタ状態のSearchPipelineMetadataから指定IDのパイプライン定義を削除する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 検索パイプライン削除 | ClusterState（SearchPipelineMetadata） | DELETE | クラスタ状態から検索パイプライン定義を削除 |

### テーブル別更新項目詳細

#### ClusterState - SearchPipelineMetadata

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | pipelines[{id}] | 指定IDの検索パイプライン定義を削除 | パイプラインが存在しない場合はエラー |

## メッセージ仕様

| メッセージID | メッセージ内容 | 種別 | 発生条件 |
|-------------|--------------|------|---------|
| 200 | `{"acknowledged": true}` | 成功 | パイプラインが正常に削除された場合 |
| 404 | パイプラインが見つからない | エラー | 指定IDのパイプラインが存在しない場合 |
| 403 | 権限不足 | エラー | 必要な権限がない場合 |

## 例外処理

- **パイプラインが存在しない場合**: 指定IDのパイプラインが見つからない場合、ResourceNotFoundExceptionがスローされHTTPステータス404が返却される
- **クラスタマネージャノード接続タイムアウト**: タイムアウトエラーが返却される
- **クラスタブロック**: メタデータ書き込みブロック設定時にClusterBlockExceptionが返却される

## 備考

- 削除しても既に実行された検索処理には影響しない
- インデックス設定でデフォルト検索パイプラインとして設定されている場合、削除後の検索リクエストに影響が出る可能性がある
- `master_timeout`（非推奨パラメータ）はこのAPIには存在しない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DeleteSearchPipelineRequest.java | `server/src/main/java/org/opensearch/action/search/DeleteSearchPipelineRequest.java` | 削除リクエストの構造 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestDeleteSearchPipelineAction.java | `server/src/main/java/org/opensearch/rest/action/search/RestDeleteSearchPipelineAction.java` | RESTリクエスト処理 |

**主要処理フロー**:
1. **行35**: ルート定義 - `DELETE /_search/pipeline/{id}` を登録
2. **行40**: パスパラメータ`id`を取得してDeleteSearchPipelineRequestを生成
3. **行41-42**: タイムアウト設定の適用
4. **行43**: `client.admin().cluster().deleteSearchPipeline()` を呼び出し

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SearchPipelineService.java | `server/src/main/java/org/opensearch/search/pipeline/SearchPipelineService.java` | パイプライン削除ロジック |

### プログラム呼び出し階層図

```
RestDeleteSearchPipelineAction.prepareRequest()
    |
    +-- DeleteSearchPipelineRequest(id)
    |
    +-- client.admin().cluster().deleteSearchPipeline()
            |
            +-- SearchPipelineService.deletePipeline()
                    |
                    +-- AckedClusterStateUpdateTask
                            |
                            +-- ClusterState.metadata() - SearchPipelineMetadataから削除
                    |
                    +-- AcknowledgedResponse -> JSONレスポンス
```

### データフロー図

```
[入力]                            [処理]                                [出力]

DELETE /_search/pipeline/{id}
    |
    +-- id (パスパラメータ)      --> RestDeleteSearchPipelineAction    --> DeleteSearchPipelineRequest
    +-- timeout                        |                                     |
                                       v                                     v
                                SearchPipelineService.deletePipeline()  ClusterState更新
                                                                             |
                                                                             v
                                                                  {"acknowledged": true}
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestDeleteSearchPipelineAction.java | `server/src/main/java/org/opensearch/rest/action/search/RestDeleteSearchPipelineAction.java` | ソース | RESTエントリーポイント |
| DeleteSearchPipelineRequest.java | `server/src/main/java/org/opensearch/action/search/DeleteSearchPipelineRequest.java` | ソース | リクエストデータ構造 |
| SearchPipelineService.java | `server/src/main/java/org/opensearch/search/pipeline/SearchPipelineService.java` | ソース | 検索パイプライン管理サービス |
| SearchPipelineMetadata.java | `server/src/main/java/org/opensearch/search/pipeline/SearchPipelineMetadata.java` | ソース | メタデータ管理 |
| search_pipeline.delete.json | `rest-api-spec/src/main/resources/rest-api-spec/api/search_pipeline.delete.json` | API仕様 | REST API仕様定義 |
