# 画面設計書 141-スクリプト削除

## 概要

本ドキュメントは、OpenSearchのスクリプト削除API（DELETE /_scripts/{id}）の画面設計書である。保存済みスクリプトをクラスタから削除するためのREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIは、クラスタ状態に保存されているストアドスクリプトを、スクリプトIDを指定して削除する処理を提供する。

**業務上の目的・背景**：不要になったストアドスクリプトをクラスタから削除し、クラスタメタデータを整理するために必要である。スクリプトのライフサイクル管理（作成・取得・削除）の一部として、不要なスクリプトリソースのクリーンアップを行う。セキュリティ上、不要なスクリプトを残しておくことはリスクとなるため、適切な削除手段が必要である。

**画面へのアクセス方法**：REST APIクライアント（curl、Kibana Dev Tools等）から `DELETE /_scripts/{id}` エンドポイントにリクエストを送信する。

**主要な操作・処理内容**：
1. クライアントが削除対象のスクリプトIDを指定してDELETEリクエストを送信する
2. リクエストのバリデーション（ID必須チェック、`#`文字の禁止チェック）が実行される
3. クラスタマネージャノードに転送され、クラスタ状態からスクリプトメタデータが削除される
4. 削除結果（acknowledged）がクライアントに返却される

**画面遷移**：本APIは「スクリプト作成・更新」（No.140）で登録されたスクリプトを削除する操作であり、「スクリプト取得」（No.139）で存在確認した後に実行されることが多い。

**権限による表示制御**：クラスタレベルのMETADATA_WRITE権限が必要である。権限がない場合はClusterBlockExceptionが返される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 82 | ストアドスクリプト | 主機能 | スクリプトを削除する処理 |

## 画面種別

削除操作（API）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| DELETE | `/_scripts/{id}` | 指定IDのストアドスクリプトを削除する |

## 入出力項目

### パスパラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| id | string | Yes | 削除対象のスクリプトID |

### クエリパラメータ

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|-----|------|-----------|------|
| timeout | time | No | 30s | 操作のタイムアウト時間 |
| cluster_manager_timeout | time | No | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | No | 30s | （非推奨）master_timeoutの代わりにcluster_manager_timeoutを使用 |

## 表示項目

### レスポンスフィールド

| 項目名 | 型 | 説明 |
|--------|-----|------|
| acknowledged | boolean | 削除リクエストが受理されたかどうか |

## イベント仕様

### 1-スクリプト削除リクエスト

1. クライアントがDELETE /_scripts/{id}にリクエストを送信する
2. RestDeleteStoredScriptActionがリクエストを受け付け、DeleteStoredScriptRequestを構築する
3. リクエストバリデーションが実行される（IDの空チェック、`#`文字の含有チェック）
4. クラスタマネージャノードにリクエストが転送される
5. TransportDeleteStoredScriptActionがクラスタ状態を更新してスクリプトを削除する
6. ScriptServiceのdeleteStoredScriptメソッドがクラスタ状態からスクリプトメタデータを除去する
7. AcknowledgedResponseがクライアントに返却される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| スクリプト削除 | ClusterState（ScriptMetadata） | DELETE | クラスタ状態からスクリプトメタデータを削除する |

### テーブル別更新項目詳細

#### ClusterState - ScriptMetadata

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | scripts[id] | 指定されたスクリプトIDに対応するエントリを削除 | クラスタ状態メタデータとして永続化 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|--------------|----------|
| - | 成功 | `{"acknowledged": true}` | スクリプト削除が正常に完了した場合 |
| - | エラー | `must specify id for stored script` | IDが未指定または空の場合 |
| - | エラー | `id cannot contain '#' for stored script` | IDに`#`文字が含まれている場合 |
| - | エラー | `resource_not_found_exception` | 指定IDのスクリプトが存在しない場合 |

## 例外処理

| 例外 | 状況 | HTTPステータス |
|------|------|---------------|
| ActionRequestValidationException | IDが空または`#`を含む | 400 |
| ResourceNotFoundException | 指定IDのスクリプトが存在しない | 404 |
| ClusterBlockException | クラスタがMETADATA_WRITEブロック状態 | 403 |
| ClusterManagerNodeTimeout | クラスタマネージャノードへの接続タイムアウト | 504 |

## 備考

- master_timeoutパラメータはバージョン2.0.0で非推奨となり、cluster_manager_timeoutの使用が推奨される
- スクリプト削除はクラスタ状態の変更を伴うため、クラスタマネージャノードで実行される
- 削除操作はClusterManagerTaskThrottlerによるスロットリングの対象である
- API安定性: stable

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、リクエスト・レスポンスのデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DeleteStoredScriptRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/storedscripts/DeleteStoredScriptRequest.java` | リクエストのデータ構造。idフィールド、バリデーションロジック（行71-81）を確認する |
| 1-2 | delete_script.json | `rest-api-spec/src/main/resources/rest-api-spec/api/delete_script.json` | REST API仕様定義。パスパラメータとクエリパラメータの定義を確認する |

**読解のコツ**: DeleteStoredScriptRequestはAcknowledgedRequestを継承しており、timeout等の共通パラメータが含まれる。

#### Step 2: エントリーポイントを理解する

RESTリクエストの受付処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestDeleteStoredScriptAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestDeleteStoredScriptAction.java` | RESTハンドラ。ルート定義（行58）、リクエスト構築処理（行67-76）を確認する |

**主要処理フロー**:
1. **行58**: DELETE /_scripts/{id} ルートを定義
2. **行68**: パスパラメータからidを取得
3. **行69**: DeleteStoredScriptRequestを構築
4. **行70-74**: timeout、cluster_manager_timeout、master_timeout（非推奨）パラメータを設定
5. **行76**: クラスタクライアントのdeleteStoredScriptを呼び出し

#### Step 3: Transport層を理解する

クラスタマネージャノードでの実際の削除処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportDeleteStoredScriptAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/storedscripts/TransportDeleteStoredScriptAction.java` | Transport層の実装。クラスタマネージャノードでの実行、ScriptServiceへの委譲（行99-105）を確認する |

**主要処理フロー**:
- **行85**: DELETE_SCRIPTタスクキーをClusterManagerTaskThrottlerに登録
- **行99-105**: clusterManagerOperationメソッドでScriptService.deleteStoredScriptを呼び出し
- **行108-110**: METADATA_WRITEレベルのクラスタブロックチェック

### プログラム呼び出し階層図

```
RestDeleteStoredScriptAction.prepareRequest() [行67-76]
    |
    +-- DeleteStoredScriptRequest(id) [行69]
    |
    +-- client.admin().cluster().deleteStoredScript() [行76]
            |
            +-- TransportDeleteStoredScriptAction.clusterManagerOperation() [行99-105]
                    |
                    +-- ScriptService.deleteStoredScript() [行104]
                            |
                            +-- ClusterState更新（ScriptMetadataからスクリプト削除）
```

### データフロー図

```
[入力]                    [処理]                           [出力]

DELETE /_scripts/{id} --> RestDeleteStoredScriptAction --> DeleteStoredScriptRequest
                          (パラメータ解析)
                                   |
                                   v
                          TransportDeleteStoredScriptAction
                          (クラスタマネージャノードで実行)
                                   |
                                   v
                          ScriptService.deleteStoredScript()
                          (ClusterState更新)
                                   |
                                   v
                          AcknowledgedResponse ----------> {"acknowledged": true}
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| delete_script.json | `rest-api-spec/src/main/resources/rest-api-spec/api/delete_script.json` | API仕様 | REST API仕様定義 |
| RestDeleteStoredScriptAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestDeleteStoredScriptAction.java` | ソース | RESTリクエストハンドラ |
| DeleteStoredScriptRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/storedscripts/DeleteStoredScriptRequest.java` | ソース | リクエストデータクラス |
| DeleteStoredScriptAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/storedscripts/DeleteStoredScriptAction.java` | ソース | アクション定義 |
| TransportDeleteStoredScriptAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/storedscripts/TransportDeleteStoredScriptAction.java` | ソース | Transport層実装 |
| ScriptService.java | `server/src/main/java/org/opensearch/script/ScriptService.java` | ソース | スクリプト管理サービス |
