# 画面設計書 142-スクリプトコンテキスト一覧

## 概要

本ドキュメントは、OpenSearchのスクリプトコンテキスト一覧API（GET /_script_context）の画面設計書である。利用可能な全スクリプトコンテキスト情報を返すREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIは、OpenSearchで利用可能なすべてのスクリプトコンテキスト（スクリプトが実行される文脈）の一覧を取得する処理を提供する。

**業務上の目的・背景**：スクリプトはOpenSearchの様々な場面（検索スコアリング、インジェスト、フィルタリング等）で利用されるが、それぞれの場面（コンテキスト）で利用可能なメソッドや変数が異なる。本APIにより、どのようなスクリプトコンテキストが存在するかを確認でき、スクリプト開発・デバッグに役立てることができる。

**画面へのアクセス方法**：REST APIクライアント（curl、Kibana Dev Tools等）から `GET /_script_context` エンドポイントにリクエストを送信する。

**主要な操作・処理内容**：
1. クライアントがGETリクエストを送信する
2. GetScriptContextActionが実行され、スクリプトサービスに登録された全コンテキスト情報を取得する
3. 各コンテキストの名前とメソッド情報がJSON形式で返却される

**画面遷移**：本APIは参照専用であり、「Painlessスクリプト実行」（No.144）でスクリプトを実行する前にコンテキスト情報を確認する用途で使用される。「スクリプト言語一覧」（No.143）と併用してスクリプト環境を把握する。

**権限による表示制御**：特段の権限制御は実装されていない。クラスタへの接続が可能であれば参照可能である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 79 | Painlessスクリプト | 主機能 | 全スクリプトコンテキストを返す処理 |

## 画面種別

一覧表示（API）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_script_context` | 全スクリプトコンテキストを返す |

## 入出力項目

### クエリパラメータ

パラメータなし。

## 表示項目

### レスポンスフィールド

| 項目名 | 型 | 説明 |
|--------|-----|------|
| contexts | array | スクリプトコンテキストの配列 |
| contexts[].name | string | コンテキスト名 |
| contexts[].methods | array | コンテキストで利用可能なメソッド情報 |

## イベント仕様

### 1-スクリプトコンテキスト一覧取得

1. クライアントがGET /_script_contextにリクエストを送信する
2. RestGetScriptContextActionがリクエストを受け付ける
3. GetScriptContextActionが実行され、ScriptServiceに登録された全コンテキストを収集する
4. コンテキスト一覧がJSON形式で返却される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| コンテキスト一覧取得 | - | SELECT（読み取りのみ） | ScriptServiceの登録済みコンテキスト情報を参照するのみ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|--------------|----------|
| - | 成功 | `{"contexts": [...]}` | 正常にコンテキスト一覧が取得された場合 |

## 例外処理

| 例外 | 状況 | HTTPステータス |
|------|------|---------------|
| - | 本APIは参照のみであり、特段の例外シナリオは限定的 | - |

## 備考

- API安定性: experimental（実験的）
- パラメータなしのシンプルなGETリクエストである
- 返却されるコンテキストはOpenSearchのバージョンや導入プラグインによって異なる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

API仕様とリクエスト/レスポンスの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | get_script_context.json | `rest-api-spec/src/main/resources/rest-api-spec/api/get_script_context.json` | REST API仕様定義。パラメータなしのシンプルなGET APIであることを確認 |

**読解のコツ**: 本APIはパラメータが一切ないため、リクエスト構造は非常にシンプルである。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestGetScriptContextAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestGetScriptContextAction.java` | RESTハンドラ。ルート定義（行57）、GetScriptContextAction実行（行67-71）を確認する |

**主要処理フロー**:
1. **行57**: GET /_script_context ルートを定義
2. **行67-71**: GetScriptContextAction.INSTANCEとGetScriptContextRequestを使ってアクションを実行

#### Step 3: Transport層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GetScriptContextAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/storedscripts/GetScriptContextAction.java` | アクション定義 |
| 3-2 | GetScriptContextRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/storedscripts/GetScriptContextRequest.java` | リクエスト定義（パラメータなし） |

### プログラム呼び出し階層図

```
RestGetScriptContextAction.prepareRequest() [行66-72]
    |
    +-- client.execute(GetScriptContextAction.INSTANCE, new GetScriptContextRequest()) [行67-70]
            |
            +-- TransportGetScriptContextAction
                    |
                    +-- ScriptService（コンテキスト一覧収集）
                            |
                            +-- GetScriptContextResponse
```

### データフロー図

```
[入力]                  [処理]                           [出力]

GET /_script_context --> RestGetScriptContextAction --> GetScriptContextRequest
                         (パラメータなし)
                                  |
                                  v
                         TransportGetScriptContextAction
                         (ScriptService参照)
                                  |
                                  v
                         GetScriptContextResponse -------> {"contexts": [...]}
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| get_script_context.json | `rest-api-spec/src/main/resources/rest-api-spec/api/get_script_context.json` | API仕様 | REST API仕様定義 |
| RestGetScriptContextAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestGetScriptContextAction.java` | ソース | RESTリクエストハンドラ |
| GetScriptContextAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/storedscripts/GetScriptContextAction.java` | ソース | アクション定義 |
| GetScriptContextRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/storedscripts/GetScriptContextRequest.java` | ソース | リクエストデータクラス |
| ScriptService.java | `server/src/main/java/org/opensearch/script/ScriptService.java` | ソース | スクリプト管理サービス |
