# 画面設計書 143-スクリプト言語一覧

## 概要

本ドキュメントは、OpenSearchのスクリプト言語一覧API（GET /_script_language）の画面設計書である。利用可能なスクリプトタイプ、言語、コンテキストの情報を返すREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIは、OpenSearchで利用可能なすべてのスクリプト言語（Painless、Mustache、Expression等）とそれぞれの言語がサポートするコンテキスト情報を取得する処理を提供する。

**業務上の目的・背景**：OpenSearchは複数のスクリプト言語をサポートしており、プラグインによって追加の言語が利用可能になることもある。本APIにより、現在のクラスタでどのスクリプト言語が利用可能か、各言語がどのコンテキストで使用できるかを確認できる。スクリプトの開発や運用管理において、対応言語の把握は不可欠である。

**画面へのアクセス方法**：REST APIクライアント（curl、Kibana Dev Tools等）から `GET /_script_language` エンドポイントにリクエストを送信する。

**主要な操作・処理内容**：
1. クライアントがGETリクエストを送信する
2. GetScriptLanguageActionが実行される
3. ScriptServiceに登録されたすべてのスクリプトエンジン情報が収集される
4. 言語ごとのサポートコンテキスト情報がJSON形式で返却される

**画面遷移**：本APIは参照専用である。「スクリプトコンテキスト一覧」（No.142）と併用してスクリプト環境を把握する。「Painlessスクリプト実行」（No.144）や「スクリプト作成・更新」（No.140）の事前確認として使用される。

**権限による表示制御**：特段の権限制御は実装されていない。クラスタへの接続が可能であれば参照可能である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 79 | Painlessスクリプト | 主機能 | 利用可能なスクリプトタイプ・言語・コンテキストを返す処理 |
| 80 | Mustacheテンプレート | 補助機能 | Mustacheテンプレート言語の情報提供 |
| 81 | Expressionスクリプト | 補助機能 | Expression言語の情報提供 |

## 画面種別

一覧表示（API）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_script_language` | 利用可能なスクリプト言語一覧を返す |

## 入出力項目

### クエリパラメータ

パラメータなし。

## 表示項目

### レスポンスフィールド

| 項目名 | 型 | 説明 |
|--------|-----|------|
| types_allowed | array | 許可されたスクリプトタイプ（inline、stored等） |
| language_contexts | array | 言語とコンテキストの対応情報 |
| language_contexts[].language | string | スクリプト言語名（painless、mustache、expression等） |
| language_contexts[].contexts | array | その言語がサポートするコンテキスト名のリスト |

## イベント仕様

### 1-スクリプト言語一覧取得

1. クライアントがGET /_script_languageにリクエストを送信する
2. RestGetScriptLanguageActionがリクエストを受け付ける
3. GetScriptLanguageAction.INSTANCEが実行される
4. ScriptServiceに登録された全スクリプトエンジンの言語情報が収集される
5. 各言語がサポートするコンテキスト情報と合わせて返却される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| スクリプト言語一覧取得 | - | SELECT（読み取りのみ） | ScriptServiceの登録済み言語情報を参照するのみ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|--------------|----------|
| - | 成功 | `{"types_allowed": [...], "language_contexts": [...]}` | 正常に言語一覧が取得された場合 |

## 例外処理

| 例外 | 状況 | HTTPステータス |
|------|------|---------------|
| - | 本APIは参照のみであり、特段の例外シナリオは限定的 | - |

## 備考

- API安定性: experimental（実験的）
- パラメータなしのシンプルなGETリクエストである
- 返却される言語リストはインストール済みプラグイン（lang-painless等）に依存する
- デフォルトではpainless、mustache、expressionの3言語が利用可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | get_script_languages.json | `rest-api-spec/src/main/resources/rest-api-spec/api/get_script_languages.json` | REST API仕様定義。パラメータなしのシンプルなGET APIであることを確認 |

**読解のコツ**: 本APIはget_script_contextと類似したパラメータなしの参照APIである。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestGetScriptLanguageAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestGetScriptLanguageAction.java` | RESTハンドラ。ルート定義（行57）、GetScriptLanguageAction実行（行67-71）を確認する |

**主要処理フロー**:
1. **行57**: GET /_script_language ルートを定義
2. **行67-71**: GetScriptLanguageAction.INSTANCEとGetScriptLanguageRequestを使ってアクションを実行

#### Step 3: Transport層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GetScriptLanguageAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/storedscripts/GetScriptLanguageAction.java` | アクション定義 |
| 3-2 | GetScriptLanguageRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/storedscripts/GetScriptLanguageRequest.java` | リクエスト定義（パラメータなし） |

### プログラム呼び出し階層図

```
RestGetScriptLanguageAction.prepareRequest() [行66-72]
    |
    +-- client.execute(GetScriptLanguageAction.INSTANCE, new GetScriptLanguageRequest()) [行67-70]
            |
            +-- TransportGetScriptLanguageAction
                    |
                    +-- ScriptService（言語一覧収集）
                            |
                            +-- GetScriptLanguageResponse
```

### データフロー図

```
[入力]                   [処理]                            [出力]

GET /_script_language --> RestGetScriptLanguageAction --> GetScriptLanguageRequest
                          (パラメータなし)
                                   |
                                   v
                          TransportGetScriptLanguageAction
                          (ScriptService参照)
                                   |
                                   v
                          GetScriptLanguageResponse -------> {"types_allowed": [...],
                                                              "language_contexts": [...]}
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| get_script_languages.json | `rest-api-spec/src/main/resources/rest-api-spec/api/get_script_languages.json` | API仕様 | REST API仕様定義 |
| RestGetScriptLanguageAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestGetScriptLanguageAction.java` | ソース | RESTリクエストハンドラ |
| GetScriptLanguageAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/storedscripts/GetScriptLanguageAction.java` | ソース | アクション定義 |
| GetScriptLanguageRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/storedscripts/GetScriptLanguageRequest.java` | ソース | リクエストデータクラス |
| ScriptService.java | `server/src/main/java/org/opensearch/script/ScriptService.java` | ソース | スクリプト管理サービス |
