# 画面設計書 145-Cat ヘルプ

## 概要

本ドキュメントは、OpenSearchのCat ヘルプAPI（GET /_cat）の画面設計書である。Cat APIの利用可能なエンドポイント一覧をテキスト形式で返すREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIは、利用可能なすべてのCat APIエンドポイントの一覧をプレーンテキスト形式で返す。Cat APIはクラスタの状態やメトリクスを人間が読みやすいテーブル形式で表示するためのAPI群であり、本エンドポイントはそのヘルプ（インデックス）として機能する。

**業務上の目的・背景**：Cat APIは多数のエンドポイントを提供しており、運用者がどのようなCat APIが利用可能かを素早く確認できる手段が必要である。本APIは、curlやターミナルからの対話的な利用を想定しており、利用可能なパス一覧を簡潔に表示する。先頭に猫の顔文字（=^.^=）が表示されるユニークな特徴がある。

**画面へのアクセス方法**：REST APIクライアント（curl等）から `GET /_cat` エンドポイントにリクエストを送信する。

**主要な操作・処理内容**：
1. クライアントがGET /_catにリクエストを送信する
2. RestCatActionが登録済みの全AbstractCatActionのdocumentationを収集する
3. 各Cat APIのエンドポイントパスをテキスト形式で連結する
4. プレーンテキストとしてレスポンスを返却する

**画面遷移**：本APIから表示された各Cat APIのパスを使って、個別のCat APIにアクセスする。例えば「Cat エイリアス」（No.146）、「Cat アロケーション」（No.147）等への入口となる。

**権限による表示制御**：特段の権限制御は実装されていない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 49 | ノード情報・統計 | 主機能 | Cat APIの利用可能なエンドポイント一覧を返すヘルプ処理 |

## 画面種別

ヘルプ表示（API）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_cat` | Cat APIヘルプを返す |

## 入出力項目

### クエリパラメータ

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|-----|------|-----------|------|
| help | boolean | No | false | ヘルプ情報を返すかどうか |
| s | list | No | - | ソートするカラム名のカンマ区切りリスト |

## 表示項目

### レスポンス（プレーンテキスト）

レスポンスはJSON形式ではなく、プレーンテキスト形式で返却される。

```
=^.^=
/_cat/aliases
/_cat/aliases/{alias}
/_cat/allocation
/_cat/cluster_manager
/_cat/count
/_cat/count/{index}
/_cat/fielddata
/_cat/fielddata/{fields}
/_cat/health
/_cat/indices
...
```

## イベント仕様

### 1-Cat ヘルプ取得

1. クライアントがGET /_catにリクエストを送信する
2. RestCatActionがリクエストを受け付ける
3. コンストラクタで事前に構築されたHELP文字列をBytesRestResponseで返却する
4. レスポンスはHTTPステータス200(OK)で返される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ヘルプ取得 | - | なし | データの参照・更新なし。静的なヘルプテキストを返すのみ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|--------------|----------|
| - | 成功 | `=^.^=\n/_cat/aliases\n...` | 正常にヘルプが返却された場合 |

## 例外処理

| 例外 | 状況 | HTTPステータス |
|------|------|---------------|
| - | 本APIは静的テキスト返却のみであり、例外シナリオは基本的にない | - |

## 備考

- API安定性: stable
- レスポンスはJSON形式ではなくプレーンテキスト形式
- HELP文字列はRestCatActionのコンストラクタで一度だけ構築され、以降はキャッシュされる
- 先頭行に猫の顔文字 `=^.^=` が表示される（CAT定数、RestCatAction行54）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | cat.help.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cat.help.json` | REST API仕様定義。help、sパラメータを確認する |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestCatAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestCatAction.java` | メイン実装。コンストラクタ（行58-65）でHELP文字列を構築、prepareRequest（行78-80）で返却 |

**主要処理フロー**:
1. **行54**: CAT定数 `=^.^=` を定義
2. **行58-65**: コンストラクタで全AbstractCatActionのdocumentationメソッドを呼び出してHELP文字列を構築
3. **行69**: GET /_cat ルートを定義
4. **行78-80**: prepareRequestでBytesRestResponse(OK, HELP)を返却

### プログラム呼び出し階層図

```
RestCatAction(catActions) [コンストラクタ:行58-65]
    |
    +-- 各AbstractCatAction.documentation(sb) [行62-63]
    |   （HELP文字列を事前構築）
    |
RestCatAction.prepareRequest() [行78-80]
    |
    +-- BytesRestResponse(RestStatus.OK, HELP) [行79]
```

### データフロー図

```
[入力]          [処理]                    [出力]

GET /_cat --> RestCatAction.prepareRequest() --> BytesRestResponse
              (事前構築済みHELP文字列返却)        (プレーンテキスト)
                                                  =^.^=
                                                  /_cat/aliases
                                                  /_cat/allocation
                                                  ...
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cat.help.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cat.help.json` | API仕様 | REST API仕様定義 |
| RestCatAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestCatAction.java` | ソース | メイン実装（ヘルプテキスト構築・返却） |
| AbstractCatAction.java | `server/src/main/java/org/opensearch/rest/action/cat/AbstractCatAction.java` | ソース | Cat APIの基底クラス（documentationメソッド定義） |
