# 画面設計書 146-Cat エイリアス

## 概要

本ドキュメントは、OpenSearchのCat エイリアスAPI（GET /_cat/aliases）の画面設計書である。設定済みのインデックスエイリアス情報をテーブル形式で表示するREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIは、OpenSearchクラスタに設定されているインデックスエイリアスの情報（エイリアス名、対象インデックス、フィルタ、ルーティング、書き込みインデックスフラグ等）を人間が読みやすいテーブル形式で返す。

**業務上の目的・背景**：インデックスエイリアスはOpenSearchの運用において重要な機能であり、ルーティング、フィルタリング、書き込み先の制御等に利用される。運用者がエイリアスの設定状況を素早く確認し、設定ミスの発見やトラブルシューティングを行うために、簡潔なテーブル形式での表示が必要である。

**画面へのアクセス方法**：REST APIクライアント（curl等）から `GET /_cat/aliases` または `GET /_cat/aliases/{alias}` エンドポイントにリクエストを送信する。

**主要な操作・処理内容**：
1. クライアントがGETリクエストを送信する（オプションでエイリアス名をフィルタ指定可能）
2. GetAliasesRequestが構築され、クラスタ状態からエイリアス情報が取得される
3. 各エイリアスの情報がTable形式に変換される
4. テーブル形式（プレーンテキストまたはJSON/YAML）でレスポンスが返却される

**画面遷移**：「エイリアス取得」（No.56）の簡易版として使用される。「エイリアス作成・更新」（No.57）の設定確認に利用する。

**権限による表示制御**：allowSystemIndexAccessByDefaultがtrueに設定されており、システムインデックスのエイリアスも表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | インデックスエイリアス | 主機能 | 設定済みエイリアス情報をテーブル形式で表示する処理 |

## 画面種別

一覧表示（API）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_cat/aliases` | 全エイリアス情報を表示 |
| GET | `/_cat/aliases/{alias}` | 指定エイリアスの情報を表示 |

## 入出力項目

### パスパラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| alias（name） | list | No | 表示するエイリアス名のカンマ区切りリスト |

### クエリパラメータ

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|-----|------|-----------|------|
| format | string | No | - | レスポンス形式（json、yaml等） |
| local | boolean | No | false | ローカル情報を返す（マスタノードからの取得を回避） |
| h | list | No | - | 表示するカラム名のカンマ区切りリスト |
| help | boolean | No | false | カラムヘルプ情報を返す |
| s | list | No | - | ソートするカラム名のカンマ区切りリスト |
| v | boolean | No | false | 詳細モード（カラムヘッダ表示） |
| expand_wildcards | enum | No | all | ワイルドカード展開方式（open/closed/hidden/none/all） |

## 表示項目

### テーブルカラム

| カラム名 | エイリアス | 説明 |
|---------|----------|------|
| alias | a | エイリアス名 |
| index | i, idx | エイリアスが指すインデックス名 |
| filter | f, fi | フィルタの有無（`*`=あり、`-`=なし） |
| routing.index | ri, routingIndex | インデックスルーティング |
| routing.search | rs, routingSearch | 検索ルーティング |
| is_write_index | w, isWriteIndex | 書き込みインデックスフラグ |

## イベント仕様

### 1-エイリアス一覧取得

1. クライアントがGET /_cat/aliasesにリクエストを送信する
2. RestAliasActionがリクエストを受け付ける
3. aliasパラメータからGetAliasesRequestが構築される（行76-78）
4. IndicesOptionsとlocalパラメータが設定される（行79-80）
5. client.admin().indices().getAliasesが呼び出される（行82）
6. GetAliasesResponseからエイリアス情報を取得しTableを構築する（行111-132）
7. 各エイリアスについてalias、index、filter、routing.index、routing.search、is_write_indexカラムを設定
8. RestTable.buildResponseでテーブル形式レスポンスを返却する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| エイリアス一覧取得 | ClusterState（Metadata） | SELECT | クラスタメタデータからエイリアス情報を参照するのみ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|--------------|----------|
| - | 成功 | テーブル形式のエイリアス一覧 | 正常にエイリアス情報が取得された場合 |

## 例外処理

| 例外 | 状況 | HTTPステータス |
|------|------|---------------|
| IndexNotFoundException | 指定したインデックスが存在しない場合 | 404 |

## 備考

- API安定性: stable
- allowSystemIndexAccessByDefaultがtrue（行70-72）であり、システムインデックスのエイリアスもデフォルトで表示される
- フィルタの有無は`*`（あり）と`-`（なし）で表示される
- ルーティングと書き込みインデックスフラグは未設定時に`-`が表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | cat.aliases.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cat.aliases.json` | REST API仕様定義。パスパラメータとクエリパラメータを確認する |
| 1-2 | AliasMetadata.java | `server/src/main/java/org/opensearch/cluster/metadata/AliasMetadata.java` | エイリアスメタデータのデータ構造を確認する |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestAliasAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestAliasAction.java` | メイン実装。ルート定義（行61）、doCatRequest（行75-89）、テーブル構造（行98-109）、テーブル構築（行111-132） |

**主要処理フロー**:
1. **行61**: GET /_cat/aliases と GET /_cat/aliases/{alias} ルートを定義
2. **行76-78**: aliasパラメータからGetAliasesRequestを構築
3. **行79-80**: IndicesOptionsとlocalパラメータ設定
4. **行82**: getAliasesを呼び出し
5. **行98-109**: getTableWithHeaderでテーブルヘッダ定義（alias, index, filter, routing.index, routing.search, is_write_index）
6. **行114-129**: buildTableでGetAliasesResponseを走査し各行を構築
7. **行120**: フィルタ有無を`*`/`-`で表示
8. **行121-125**: ルーティングとwrite_indexを`-`（未設定時）で表示

### プログラム呼び出し階層図

```
RestAliasAction.doCatRequest() [行75-89]
    |
    +-- GetAliasesRequest構築 [行76-78]
    +-- IndicesOptions設定 [行79]
    +-- local設定 [行80]
    |
    +-- client.admin().indices().getAliases() [行82]
            |
            +-- GetAliasesResponse
                    |
                    +-- buildTable() [行111-132]
                    |   +-- AliasMetadata走査
                    |   +-- alias, index, filter, routing, is_write_index設定
                    |
                    +-- RestTable.buildResponse() [行86]
```

### データフロー図

```
[入力]                     [処理]                          [出力]

GET /_cat/aliases      --> RestAliasAction             --> GetAliasesRequest
GET /_cat/aliases/{a}      (パラメータ解析)
                                   |
                                   v
                           GetAliasesResponse
                           (クラスタメタデータ参照)
                                   |
                                   v
                           buildTable()                --> テーブル形式レスポンス
                           (AliasMetadata→Table変換)       alias | index | filter | ...
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cat.aliases.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cat.aliases.json` | API仕様 | REST API仕様定義 |
| RestAliasAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestAliasAction.java` | ソース | メイン実装 |
| AbstractCatAction.java | `server/src/main/java/org/opensearch/rest/action/cat/AbstractCatAction.java` | ソース | Cat API基底クラス |
| AliasMetadata.java | `server/src/main/java/org/opensearch/cluster/metadata/AliasMetadata.java` | ソース | エイリアスメタデータ |
| GetAliasesRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/get/GetAliasesRequest.java` | ソース | リクエストクラス |
| GetAliasesResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/get/GetAliasesResponse.java` | ソース | レスポンスクラス |
