# 画面設計書 147-Cat アロケーション

## 概要

本ドキュメントは、OpenSearchのCat アロケーションAPI（GET /_cat/allocation）の画面設計書である。データノードへのシャード割り当てとディスク使用量をテーブル形式で表示するREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIは、各データノードに割り当てられたシャード数、ディスク使用量（インデックス分、全体使用量、空き容量、合計容量、使用率）、およびノードのホスト名・IPアドレス・ノード名を人間が読みやすいテーブル形式で返す。未割り当てシャードの数も表示される。

**業務上の目的・背景**：クラスタの容量計画やディスク使用状況の監視において、各ノードへのシャード分散状況とディスク使用量を素早く把握する手段が必要である。本APIにより、ノード間のシャード偏りやディスク容量不足の兆候を早期に発見でき、適切な対応（シャード再配置、ノード追加等）を判断できる。

**画面へのアクセス方法**：REST APIクライアント（curl等）から `GET /_cat/allocation` または `GET /_cat/allocation/{node_id}` エンドポイントにリクエストを送信する。

**主要な操作・処理内容**：
1. クライアントがGETリクエストを送信する
2. ClusterStateRequestでルーティングテーブルを取得する
3. NodesStatsRequestで各ノードのファイルシステム統計とストア情報を取得する
4. シャードのルーティング情報からノードごとのシャード数を集計する
5. ノード統計とシャード数を組み合わせてテーブルを構築する
6. 未割り当てシャードがある場合はUNASSIGNED行を追加する

**画面遷移**：「クラスタヘルス」（No.90）で問題を検知した後、本APIでシャード分散状況を確認する。「アロケーション説明」（No.95）で個別シャードの配置理由を確認する。

**権限による表示制御**：クラスタ状態の参照権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 56 | シャードアロケーション | 主機能 | データノードへのシャード割り当てとディスク使用量をテーブル形式で表示する処理 |

## 画面種別

一覧表示（API）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_cat/allocation` | 全データノードのアロケーション情報を表示 |
| GET | `/_cat/allocation/{node_id}` | 指定ノードのアロケーション情報を表示 |

## 入出力項目

### パスパラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| node_id | list | No | 表示するノードIDまたは名前のカンマ区切りリスト |

### クエリパラメータ

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|-----|------|-----------|------|
| format | string | No | - | レスポンス形式（json、yaml等） |
| bytes | enum | No | - | バイト値の表示単位（b/k/kb/m/mb/g/gb/t/tb/p/pb） |
| local | boolean | No | false | ローカル情報を返す |
| cluster_manager_timeout | time | No | - | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | No | - | （非推奨）cluster_manager_timeoutを使用 |
| h | list | No | - | 表示するカラム名のカンマ区切りリスト |
| help | boolean | No | false | カラムヘルプ情報を返す |
| s | list | No | - | ソートするカラム名のカンマ区切りリスト |
| v | boolean | No | false | 詳細モード（カラムヘッダ表示） |

## 表示項目

### テーブルカラム

| カラム名 | エイリアス | 説明 |
|---------|----------|------|
| shards | s | ノード上のシャード数 |
| disk.indices | di, diskIndices | OpenSearchインデックスが使用するディスク容量 |
| disk.used | du, diskUsed | ディスク使用量（OS全体） |
| disk.avail | da, diskAvail | ディスク空き容量 |
| disk.total | dt, diskTotal | ディスク合計容量 |
| disk.percent | dp, diskPercent | ディスク使用率（%） |
| host | h | ノードのホスト名 |
| ip | - | ノードのIPアドレス |
| node | n | ノード名 |

## イベント仕様

### 1-アロケーション情報取得

1. クライアントがGET /_cat/allocationにリクエストを送信する
2. RestAllocationActionがリクエストを受け付ける
3. nodesパラメータを取得（デフォルト: "data:true"）（行87）
4. ClusterStateRequestでルーティングテーブルを取得（行88-94）
5. NodesStatsRequestでFS統計とストア情報を取得（行99-104）
6. ルーティングテーブルの全シャードを走査し、ノードごとのシャード数を集計（行136-146）
7. 各ノードのシャード数、ディスク使用量、ホスト情報でテーブル行を構築（行150-178）
8. ディスク使用率は `used * 100 / (used + avail)` で計算（行163）
9. UNASSIGNEDシャードがある場合は専用行を追加（行180-193）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| アロケーション情報取得 | ClusterState、NodesStats | SELECT | ルーティングテーブルとノード統計を参照するのみ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|--------------|----------|
| - | 成功 | テーブル形式のアロケーション情報 | 正常に情報が取得された場合 |

## 例外処理

| 例外 | 状況 | HTTPステータス |
|------|------|---------------|
| ClusterManagerNodeTimeout | クラスタマネージャノードへの接続タイムアウト | 504 |

## 備考

- API安定性: stable
- デフォルトではデータノード（data:true）のみ表示対象（行87）
- ディスク使用量が不明な場合（非データノード等）はnullが設定される
- ディスク使用率が計算不能な場合は-1が設定され、表示時にnullとなる
- master_timeoutパラメータはv2.0.0で非推奨

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | cat.allocation.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cat.allocation.json` | REST API仕様。パスパラメータとクエリパラメータの定義を確認 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestAllocationAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestAllocationAction.java` | メイン実装。2段階のリクエスト（ClusterState→NodesStats）構造を確認する |

**主要処理フロー**:
1. **行72**: GET /_cat/allocation と GET /_cat/allocation/{nodes} ルートを定義
2. **行87**: nodesパラメータ取得（デフォルト "data:true"）
3. **行88-94**: ClusterStateRequestでルーティングテーブル取得
4. **行96-114**: ClusterStateResponseのコールバック内でNodesStatsRequest実行
5. **行119-133**: テーブルヘッダ定義（shards, disk.indices, disk.used, disk.avail, disk.total, disk.percent, host, ip, node）
6. **行135-196**: buildTableでシャード集計、ノード統計取得、テーブル構築

### プログラム呼び出し階層図

```
RestAllocationAction.doCatRequest() [行86-116]
    |
    +-- ClusterStateRequest構築 [行88-94]
    |
    +-- client.admin().cluster().state() [行96]
            |
            +-- RestActionListener.processResponse() [行98]
                    |
                    +-- NodesStatsRequest構築 [行99-104]
                    |
                    +-- client.admin().cluster().nodesStats() [行106]
                            |
                            +-- buildTable(request, state, stats) [行135]
                            |   +-- allShards走査でノード別シャード数集計 [行138-146]
                            |   +-- ノードごとにディスク統計をテーブルに設定 [行150-178]
                            |   +-- UNASSIGNEDシャード行追加 [行180-193]
                            |
                            +-- RestTable.buildResponse() [行110]
```

### データフロー図

```
[入力]                      [処理]                              [出力]

GET /_cat/allocation   --> RestAllocationAction
                            |
                            +-- ClusterStateRequest
                            |   (ルーティングテーブル取得)
                            |
                            +-- NodesStatsRequest
                            |   (FS統計+ストア情報取得)
                            |
                            +-- buildTable()              --> テーブル形式レスポンス
                                (シャード集計+ディスク統計)     shards | disk.used | ...
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cat.allocation.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cat.allocation.json` | API仕様 | REST API仕様定義 |
| RestAllocationAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestAllocationAction.java` | ソース | メイン実装 |
| AbstractCatAction.java | `server/src/main/java/org/opensearch/rest/action/cat/AbstractCatAction.java` | ソース | Cat API基底クラス |
| ClusterStateRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/state/ClusterStateRequest.java` | ソース | クラスタ状態リクエスト |
| NodesStatsRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/stats/NodesStatsRequest.java` | ソース | ノード統計リクエスト |
| NodeStats.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/stats/NodeStats.java` | ソース | ノード統計データ |
