# 画面設計書 149-Cat ドキュメント件数

## 概要

本ドキュメントは、OpenSearchのCat ドキュメント件数API（GET /_cat/count）の画面設計書である。クラスタ全体またはインデックスのドキュメント件数をテーブル形式で返すREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIは、クラスタ全体または指定したインデックスのドキュメント件数をタイムスタンプ付きのテーブル形式で返す。内部的にはSearchRequestを使用してsize=0のカウントクエリを実行する。

**業務上の目的・背景**：インデックスのドキュメント数をリアルタイムで把握することは、データ取り込みの監視、インデックスの成長トレンドの確認、データ整合性の検証等において重要である。本APIにより、curlやスクリプトから簡潔にドキュメント数を取得し、運用監視に活用できる。

**画面へのアクセス方法**：REST APIクライアント（curl等）から `GET /_cat/count` または `GET /_cat/count/{index}` エンドポイントにリクエストを送信する。

**主要な操作・処理内容**：
1. クライアントがGETリクエストを送信する（オプションでインデックス名を指定可能）
2. SearchRequestが構築され、size=0、trackTotalHits=trueに設定される
3. クエリが指定されていない場合はマッチオールクエリが使用される
4. 検索結果のtotalHits.valueをカウント値として返却する

**画面遷移**：「ドキュメント件数」（No.23）の簡易版として使用される。「Cat インデックス」（No.152）でインデックスごとの詳細情報を確認する。

**権限による表示制御**：検索対象インデックスへの読み取り権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 20 | 検索API | 主機能 | クラスタ全体またはインデックスのドキュメント件数をテーブル形式で返す処理 |

## 画面種別

一覧表示（API）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_cat/count` | クラスタ全体のドキュメント件数を返す |
| GET | `/_cat/count/{index}` | 指定インデックスのドキュメント件数を返す |

## 入出力項目

### パスパラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| index | list | No | 対象インデックス名のカンマ区切りリスト |

### クエリパラメータ

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|-----|------|-----------|------|
| format | string | No | - | レスポンス形式（json、yaml等） |
| h | list | No | - | 表示するカラム名のカンマ区切りリスト |
| help | boolean | No | false | カラムヘルプ情報を返す |
| s | list | No | - | ソートするカラム名のカンマ区切りリスト |
| v | boolean | No | false | 詳細モード（カラムヘッダ表示） |

## 表示項目

### テーブルカラム

| カラム名 | エイリアス | 説明 |
|---------|----------|------|
| epoch | - | タイムスタンプ（エポック秒） |
| timestamp | - | タイムスタンプ（人間可読形式） |
| count | dc, docs.count, docsCount | ドキュメント件数 |

## イベント仕様

### 1-ドキュメント件数取得

1. クライアントがGET /_cat/countにリクエストを送信する
2. RestCountActionがリクエストを受け付ける
3. indexパラメータからインデックス配列を取得（行81）
4. SearchRequestを構築（size=0, trackTotalHits=true）（行82-84）
5. リクエストボディまたはURLパラメータからクエリを解析（行86-98）
6. クライアントでsearchを実行（行99）
7. SearchResponseのtotalHits.valueをカウント値として返却（行120）
8. テーブルにはタイムスタンプ付きで1行を返す

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ドキュメント件数取得 | インデックス（Lucene） | SELECT | 検索クエリ（size=0）でドキュメント数を取得するのみ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|--------------|----------|
| - | 成功 | テーブル形式のドキュメント件数（タイムスタンプ付き） | 正常にカウントが取得された場合 |
| - | エラー | `Couldn't parse query` | クエリの解析に失敗した場合 |

## 例外処理

| 例外 | 状況 | HTTPステータス |
|------|------|---------------|
| OpenSearchException | クエリの解析に失敗した場合 | 400 |
| IndexNotFoundException | 指定インデックスが存在しない場合 | 404 |

## 備考

- API安定性: stable
- 内部的にはSearchRequestを使用（size=0, trackTotalHits=true）
- TotalHits.Relation.EQUAL_TOのアサーションが含まれる（行102）
- startHeadersWithTimestampを使用し、タイムスタンプカラムが自動追加される（行111）
- リクエストボディでカスタムクエリを指定可能（行86-98）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | cat.count.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cat.count.json` | REST API仕様。パスパラメータとクエリパラメータの定義を確認 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestCountAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestCountAction.java` | メイン実装。SearchRequest構築（行80-98）、テーブル構造（行109-115）、テーブル構築（行117-124） |

**主要処理フロー**:
1. **行65**: GET /_cat/count と GET /_cat/count/{index} ルートを定義
2. **行81**: indexパラメータをカンマ区切りで配列に変換
3. **行82-84**: SearchRequest構築（size=0, trackTotalHits=true）
4. **行86-98**: クエリ解析（ボディまたはURLパラメータから）
5. **行99-105**: client.searchで検索実行、SearchResponseからテーブル構築
6. **行111**: startHeadersWithTimestampでタイムスタンプ付きヘッダ定義
7. **行112**: countカラム追加（エイリアス: dc, docs.count, docsCount）
8. **行120**: response.getHits().getTotalHits().value()でカウント値取得

### プログラム呼び出し階層図

```
RestCountAction.doCatRequest() [行80-106]
    |
    +-- SearchRequest構築 [行82-84]
    |   +-- size(0), trackTotalHits(true)
    |
    +-- クエリ解析 [行86-98]
    |   +-- URLパラメータまたはリクエストボディからクエリ構築
    |
    +-- client.search() [行99]
            |
            +-- SearchResponse
                    |
                    +-- buildTable() [行117-124]
                    |   +-- getTotalHits().value() [行120]
                    |
                    +-- RestTable.buildResponse() [行103]
```

### データフロー図

```
[入力]                    [処理]                          [出力]

GET /_cat/count       --> RestCountAction
GET /_cat/count/{idx}     |
                          +-- SearchRequest(size=0)
                          |   (カウントクエリ実行)
                          |
                          +-- SearchResponse
                          |   (totalHits取得)
                          |
                          +-- buildTable()            --> テーブル形式レスポンス
                                                          epoch | timestamp | count
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cat.count.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cat.count.json` | API仕様 | REST API仕様定義 |
| RestCountAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestCountAction.java` | ソース | メイン実装 |
| AbstractCatAction.java | `server/src/main/java/org/opensearch/rest/action/cat/AbstractCatAction.java` | ソース | Cat API基底クラス |
| SearchRequest.java | `server/src/main/java/org/opensearch/action/search/SearchRequest.java` | ソース | 検索リクエスト |
| SearchResponse.java | `server/src/main/java/org/opensearch/action/search/SearchResponse.java` | ソース | 検索レスポンス |
| RestActions.java | `server/src/main/java/org/opensearch/rest/action/RestActions.java` | ソース | クエリ解析ユーティリティ |
