# 画面設計書 150-Cat Fielddata

## 概要

本ドキュメントは、OpenSearchのCat Fielddata API（GET /_cat/fielddata）の画面設計書である。フィールドデータのヒープメモリ使用量をテーブル形式で表示するREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIは、クラスタ内の各データノードにおけるフィールドデータ（fielddata）のヒープメモリ使用量を、フィールド単位・ノード単位でテーブル形式で返す。

**業務上の目的・背景**：フィールドデータはソート、集計、スクリプト処理等で使用されるインメモリのデータ構造であり、大量のヒープメモリを消費する可能性がある。本APIにより、どのフィールドがどのノードでどれだけのメモリを使用しているかを素早く把握でき、メモリ使用量の最適化やフィールドデータのキャッシュ戦略の改善に役立てることができる。OutOfMemoryエラーの予防やパフォーマンスチューニングにおいて重要な監視ツールである。

**画面へのアクセス方法**：REST APIクライアント（curl等）から `GET /_cat/fielddata` または `GET /_cat/fielddata/{fields}` エンドポイントにリクエストを送信する。

**主要な操作・処理内容**：
1. クライアントがGETリクエストを送信する（オプションでフィールド名を指定可能）
2. NodesStatsRequestが構築され、データノード（data:true）のインデックス統計が取得される
3. 各ノードのフィールドデータ統計からフィールド別のメモリ使用量を取得する
4. ノード・フィールドごとにテーブル行を構築して返却する

**画面遷移**：「ノード統計」（No.108）でノード全体のリソース使用状況を確認した後、本APIでフィールドデータの詳細を確認する。「キャッシュクリア」（No.83）でフィールドデータキャッシュをクリアする判断材料とする。

**権限による表示制御**：ノード統計への参照権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 109 | インデックスキャッシュ | 主機能 | フィールドデータのヒープメモリ使用量をテーブル形式で表示する処理 |

## 画面種別

一覧表示（API）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_cat/fielddata` | 全フィールドのフィールドデータ使用量を表示 |
| GET | `/_cat/fielddata/{fields}` | 指定フィールドのフィールドデータ使用量を表示 |

## 入出力項目

### パスパラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| fields | list | No | 表示するフィールド名のカンマ区切りリスト |

### クエリパラメータ

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|-----|------|-----------|------|
| format | string | No | - | レスポンス形式（json、yaml等） |
| bytes | enum | No | - | バイト値の表示単位（b/k/kb/m/mb/g/gb/t/tb/p/pb） |
| h | list | No | - | 表示するカラム名のカンマ区切りリスト |
| help | boolean | No | false | カラムヘルプ情報を返す |
| s | list | No | - | ソートするカラム名のカンマ区切りリスト |
| v | boolean | No | false | 詳細モード（カラムヘッダ表示） |
| fields | list | No | - | クエリパラメータとしてもフィールド指定可能 |

## 表示項目

### テーブルカラム

| カラム名 | エイリアス | 説明 |
|---------|----------|------|
| id | - | ノードID |
| host | h | ホスト名 |
| ip | - | IPアドレス |
| node | n | ノード名 |
| field | f | フィールド名 |
| size | s | フィールドデータの使用量 |

## イベント仕様

### 1-フィールドデータ情報取得

1. クライアントがGET /_cat/fielddataにリクエストを送信する
2. RestFielddataActionがリクエストを受け付ける
3. NodesStatsRequestが構築される（対象: "data:true"）（行70）
4. fieldsパラメータを取得し、未指定の場合はワイルドカード`*`を使用（行73-74）
5. client.admin().cluster().nodesStatsが実行される（行76）
6. 各NodeStatsのフィールドデータ統計からフィールド別のメモリ使用量を取得（行107-119）
7. ノードID、ホスト名、IPアドレス、ノード名、フィールド名、使用量でテーブル行を構築
8. RestTable.buildResponseでテーブル形式レスポンスを返却する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| フィールドデータ情報取得 | NodesStats | SELECT | ノード統計のフィールドデータ情報を参照するのみ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|--------------|----------|
| - | 成功 | テーブル形式のフィールドデータ使用量 | 正常に情報が取得された場合 |

## 例外処理

| 例外 | 状況 | HTTPステータス |
|------|------|---------------|
| - | 本APIはノード統計の参照のみであり、特段の例外シナリオは限定的 | - |

## 備考

- API安定性: stable
- デフォルトではデータノード（data:true）のみ対象（行70）
- fieldsパラメータ未指定時はワイルドカード`*`で全フィールドが対象（行74）
- フィールドデータが存在しないノードはスキップされる（行108のnullチェック）
- 各フィールドのメモリ使用量はByteSizeValueで表示される（行116）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | cat.fielddata.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cat.fielddata.json` | REST API仕様。パスパラメータとクエリパラメータの定義を確認。fieldsパラメータが2箇所で定義されていることに注意 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestFielddataAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestFielddataAction.java` | メイン実装。NodesStatsRequest構築（行69-74）、テーブル構造（行91-102）、テーブル構築（行104-123） |

**主要処理フロー**:
1. **行60**: GET /_cat/fielddata と GET /_cat/fielddata/{fields} ルートを定義
2. **行70**: NodesStatsRequest構築（対象: "data:true"）
3. **行71-72**: clear()してindices(true)のみ有効化
4. **行73-74**: fieldsパラメータ取得、未指定時は `*` をデフォルト使用
5. **行76-81**: nodesStatsを実行しテーブル構築
6. **行93-101**: テーブルヘッダ定義（id, host, ip, node, field, size）
7. **行104-123**: buildTableで各ノードのフィールドデータを走査

#### Step 3: フィールドデータ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | NodeStats.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/stats/NodeStats.java` | ノード統計データ。getIndices().getFieldData().getFields()のデータ構造を確認 |

### プログラム呼び出し階層図

```
RestFielddataAction.doCatRequest() [行69-82]
    |
    +-- NodesStatsRequest構築 [行70-74]
    |   +-- "data:true"ノード対象
    |   +-- indices統計のみ
    |   +-- fieldDataFields設定
    |
    +-- client.admin().cluster().nodesStats() [行76]
            |
            +-- NodesStatsResponse
                    |
                    +-- buildTable() [行104-123]
                    |   +-- 各NodeStats走査 [行107]
                    |   +-- getFieldData().getFields()走査 [行109]
                    |   +-- id/host/ip/node/field/size設定 [行110-116]
                    |
                    +-- RestTable.buildResponse() [行79]
```

### データフロー図

```
[入力]                       [処理]                          [出力]

GET /_cat/fielddata      --> RestFielddataAction
GET /_cat/fielddata/{f}      |
                             +-- NodesStatsRequest
                             |   (データノードのインデックス統計取得)
                             |
                             +-- buildTable()            --> テーブル形式レスポンス
                                 (フィールドデータ走査)       id | host | ip | node | field | size
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cat.fielddata.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cat.fielddata.json` | API仕様 | REST API仕様定義 |
| RestFielddataAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestFielddataAction.java` | ソース | メイン実装 |
| AbstractCatAction.java | `server/src/main/java/org/opensearch/rest/action/cat/AbstractCatAction.java` | ソース | Cat API基底クラス |
| NodesStatsRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/stats/NodesStatsRequest.java` | ソース | ノード統計リクエスト |
| NodeStats.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/stats/NodeStats.java` | ソース | ノード統計データ |
| ByteSizeValue.java | `libs/core/src/main/java/org/opensearch/core/common/unit/ByteSizeValue.java` | ソース | バイトサイズ表示ユーティリティ |
