# 画面設計書 16-クエリによる更新スロットル変更

## 概要

本ドキュメントは、OpenSearchのUpdate By Query Rethrottle API（`_update_by_query/{task_id}/_rethrottle`）エンドポイントに関する画面設計書である。実行中のUpdate By Query操作のスロットル値（リクエスト/秒）を動的に変更するためのREST APIインターフェースを定義する。

### 本画面の処理概要

本APIは、実行中のUpdate By Query操作に対してスロットル値を動的に変更する機能を提供する。Delete By Query Rethrottle（No.14）と同一のRestRethrottleActionクラスで処理されるため、動作は同等である。

**業務上の目的・背景**：Update By Query操作は大量データを処理するため、クラスタの通常運用に影響を与える可能性がある。運用中にスロットル値を変更することで、負荷を制御しながら更新処理の速度を調整できる。

**画面へのアクセス方法**：HTTPクライアントから`POST /_update_by_query/{task_id}/_rethrottle?requests_per_second=N`エンドポイントにリクエストを送信する。

**主要な操作・処理内容**：
1. タスクIDとrequests_per_secondパラメータを受け取る
2. 指定されたタスクのスロットル値を更新する
3. クラスタ内の関連ノードに対してRethrottleアクションを伝播する

**画面遷移**：クエリによる更新（No.15）でwait_for_completion=falseで実行したタスクのスロットルを変更する。タスク一覧（No.112）やタスク取得（No.113）でタスクIDを確認後に使用する。

**権限による表示制御**：タスク管理に関する権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 15 | Update By Query | 主機能 | Update By Query操作のリクエスト/秒スロットルを変更する処理 |
| 51 | タスク管理 | 補助機能 | 実行中タスクのスロットル値を変更するタスク管理処理 |

## 画面種別

API（タスクスロットル変更）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| POST | `/_update_by_query/{task_id}/_rethrottle` | Update By Queryタスクのスロットル変更 |

## 入出力項目

### URLパスパラメータ

| パラメータ | 型 | 必須 | 説明 |
|-----------|------|------|------|
| task_id | string | はい | スロットルを変更するタスクのID |

### クエリパラメータ

| パラメータ | 型 | 必須 | デフォルト | 説明 |
|-----------|------|------|-----------|------|
| requests_per_second | number | はい | - | 設定するスロットル値（サブリクエスト/秒）。-1でスロットルなし |

## 表示項目

### レスポンスボディ

| フィールド | 型 | 説明 |
|-----------|------|------|
| nodes | object | ノード別のタスク情報 |
| nodes.{node_id}.tasks | object | タスク情報 |

## イベント仕様

### 1-Rethrottleリクエスト実行

1. `RestRethrottleAction.prepareRequest()`がタスクIDとrequests_per_secondを解析する（行73-87）
2. `RethrottleRequest`オブジェクトを構築し、`TaskId`とスロットル値を設定する
3. requests_per_secondがnullの場合、IllegalArgumentExceptionをスローする（行77-79）
4. `RethrottleAction.INSTANCE`を実行し、クラスタ内のタスクにスロットル変更を伝播する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Rethrottleリクエスト | なし | なし | タスクのスロットル値を変更するのみ |

### テーブル別更新項目詳細

本APIはタスクのランタイムパラメータ変更のみであり、Luceneインデックスへの直接的な更新は行わない。

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|--------------|------|--------------|
| 成功 | スロットル変更成功 | HTTPステータス200、ノード別タスク情報 |
| エラー | requests_per_second未指定 | "requests_per_second is a required parameter" |
| エラー | タスクID不正 | タスクが見つからないエラー |

## 例外処理

| 例外 | 条件 | 動作 |
|------|------|------|
| IllegalArgumentException | requests_per_secondパラメータ未指定 | リクエスト全体が失敗、HTTPステータス400 |
| ResourceNotFoundException | 指定タスクIDが存在しない場合 | エラーレスポンスを返す |

## 備考

- No.14（Delete By Query Rethrottle）と同一のRestRethrottleActionクラスで処理される
- requests_per_secondに-1を設定するとスロットルが解除される
- APIパスは`/_update_by_query/{taskId}/_rethrottle`であり、rest-api-specの`{task_id}`とRestRethrottleAction内の`{taskId}`で命名が異なる点に注意

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | update_by_query_rethrottle.json | `rest-api-spec/src/main/resources/rest-api-spec/api/update_by_query_rethrottle.json` | API定義。No.14と同じ構造 |
| 1-2 | RethrottleRequest.java | `server/src/main/java/org/opensearch/index/reindex/RethrottleRequest.java` | リクエストデータ構造（共通） |

**読解のコツ**: No.14（Delete By Query Rethrottle）と同一の処理基盤であるため、No.14のコードリーディングガイドも参照すること。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestRethrottleAction.java | `modules/reindex/src/main/java/org/opensearch/index/reindex/RestRethrottleAction.java` | RESTハンドラ（3API共通） |

**主要処理フロー**:
1. **行60**: routes()で`/_update_by_query/{taskId}/_rethrottle`のルートを定義
2. **行73-87**: prepareRequest()の処理はNo.14と同一

### プログラム呼び出し階層図

```
RestRethrottleAction.prepareRequest()                   [行73]
    |
    +-- RethrottleRequest()
    |       +-- setTaskId()                             [行75]
    |       +-- setRequestsPerSecond()                  [行80]
    |
    +-- NodeClient.execute(RethrottleAction.INSTANCE, ...)  [行82]
            |
            +-- TransportRethrottleAction
                    +-- 各ノードへのスロットル変更伝播
```

### データフロー図

```
[入力]                           [処理]                              [出力]

HTTPリクエスト              RestRethrottleAction                 ListTasksResponse
(POST /_update_by_query/ パラメータ解析・リクエスト構築
 {task_id}/_rethrottle)         |
   |                            v
   v                    TransportRethrottleAction              レスポンスJSON
task_id +              各ノードへスロットル変更伝播             {nodes: {...}}
requests_per_second
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| update_by_query_rethrottle.json | `rest-api-spec/src/main/resources/rest-api-spec/api/update_by_query_rethrottle.json` | API定義 | REST API仕様 |
| RestRethrottleAction.java | `modules/reindex/src/main/java/org/opensearch/index/reindex/RestRethrottleAction.java` | ソース | RESTハンドラ（3API共通） |
| RethrottleRequest.java | `server/src/main/java/org/opensearch/index/reindex/RethrottleRequest.java` | ソース | リクエストデータ構造 |
| RethrottleAction.java | `server/src/main/java/org/opensearch/index/reindex/RethrottleAction.java` | ソース | アクション定義 |
