# 画面設計書 161-Cat シャード

## 概要

本ドキュメントは、OpenSearchのCat Shards API（`GET /_cat/shards`）の画面設計書である。ノードへのシャード割り当ての詳細をテーブル形式で表示するREST APIエンドポイントについて、入出力仕様・処理フロー・データベース影響等を定義する。

### 本画面の処理概要

Cat Shards APIは、クラスタ内の全シャードに関する詳細情報を人間が読みやすいテーブル形式で返すAPIエンドポイントである。

**業務上の目的・背景**：クラスタの運用監視において、各インデックスのシャードがどのノードに配置されているか、シャードの状態（STARTED/RELOCATING/INITIALIZING/UNASSIGNED）、ドキュメント数、ストアサイズなどを一目で確認する必要がある。本APIにより、シャードアロケーションの問題やクラスタの不均衡を迅速に特定でき、運用者の障害対応・キャパシティプランニングを支援する。

**画面へのアクセス方法**：HTTPクライアント（curl、OpenSearch Dashboards Dev Tools等）から `GET /_cat/shards` または `GET /_cat/shards/{index}` にリクエストを送信する。

**主要な操作・処理内容**：
1. クラスタ状態からシャードルーティング情報を取得する
2. インデックス統計（IndicesStats）からシャード単位の統計情報を取得する
3. シャードごとにインデックス名、シャード番号、プライマリ/レプリカ種別、状態、ドキュメント数、ストアサイズ、IP、ノード名等をテーブル行として組み立てる
4. 未割り当てシャードの場合は、未割り当て理由・時刻・詳細も表示する

**画面遷移**：本APIは単独で使用される。関連APIとして、Cat Allocation（`GET /_cat/allocation`）やクラスタヘルス（`GET /_cluster/health`）と組み合わせて利用されることが多い。

**権限による表示制御**：システムインデックスへのアクセスがデフォルトで許可されている（`allowSystemIndexAccessByDefault`がtrue）。セキュリティプラグイン導入時は、インデックス単位の権限制御が適用される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 56 | シャードアロケーション | 主機能 | ノードへのシャード割り当ての詳細をテーブル形式で表示する処理 |

## 画面種別

一覧（テーブル形式表示）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_cat/shards` | 全インデックスのシャード情報を返す |
| GET | `/_cat/shards/{index}` | 指定インデックスのシャード情報を返す |

## 入出力項目

### リクエストパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| index | list | No | - | 情報取得対象のインデックス名（カンマ区切り） |
| format | string | No | text | レスポンス形式（json, yaml, text等） |
| bytes | enum | No | - | バイト値の表示単位（b/k/kb/m/mb/g/gb/t/tb/p/pb） |
| local | boolean | No | false | ローカルノードの情報のみ返すか |
| cluster_manager_timeout | time | No | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | No | 30s | 非推奨。cluster_manager_timeoutを使用すること |
| h | list | No | - | 表示するカラム名のカンマ区切りリスト |
| help | boolean | No | false | ヘルプ情報を返す |
| s | list | No | - | ソートするカラム名のカンマ区切りリスト |
| time | enum | No | ms | 時間値の表示単位（d/h/m/s/ms/micros/nanos） |
| v | boolean | No | false | カラムヘッダを表示するか |

## 表示項目

### デフォルト表示カラム

| カラム名 | エイリアス | 説明 |
|---------|----------|------|
| index | i, idx | インデックス名 |
| shard | s, sh | シャード番号 |
| prirep | p, pr, primaryOrReplica | プライマリ(p)/レプリカ(r)/検索専用(s) |
| state | st | シャード状態（STARTED/RELOCATING/INITIALIZING/UNASSIGNED） |
| docs | d, dc | シャード内のドキュメント数 |
| store | sto | シャードのストアサイズ |
| ip | - | シャードが配置されているノードのIPアドレス |
| node | n | シャードが配置されているノード名 |

### オプション表示カラム（抜粋）

| カラム名 | エイリアス | 説明 |
|---------|----------|------|
| id | - | ノードの一意ID |
| sync_id | sync_id | 同期ID |
| unassigned.reason | ur | 未割り当て理由 |
| unassigned.at | ua | 未割り当て発生時刻（UTC） |
| unassigned.for | uf | 未割り当て経過時間 |
| unassigned.details | ud | 未割り当て詳細 |
| recoverysource.type | rs | リカバリソース種別 |
| completion.size | cs | completionサイズ |
| fielddata.memory_size | fm | fielddataキャッシュ使用量 |
| query_cache.memory_size | qcm | クエリキャッシュ使用量 |
| flush.total | ft | フラッシュ回数 |
| get.total | gto | GET操作回数 |
| indexing.index_total | iito | インデキシング操作回数 |
| merges.total | mt | マージ操作回数 |
| refresh.total | rto | リフレッシュ回数 |
| search.query_total | sqto | 検索クエリ回数 |
| segments.count | sc | セグメント数 |
| seq_no.max | sqm | 最大シーケンス番号 |
| seq_no.local_checkpoint | sql | ローカルチェックポイント |
| seq_no.global_checkpoint | sqg | グローバルチェックポイント |
| docs.deleted | dd | 削除済みドキュメント数 |

## イベント仕様

### 1-GETリクエスト受信

1. `RestShardsAction.doCatRequest()`がリクエストを受信する
2. リクエストパラメータからインデックス名、タイムアウト値等を解析する
3. `CatShardsRequest`を構築し、`CatShardsAction`を実行する
4. レスポンスとして`CatShardsResponse`を受け取り、`buildTable()`でテーブルを構築する
5. `RestTable.buildResponse()`でテーブルをフォーマットしてレスポンスを返す

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| GETリクエスト | - | SELECT | クラスタ状態とインデックス統計を参照のみ。データ更新なし |

### テーブル別更新項目詳細

本APIは読み取り専用であり、データベース（クラスタ状態・インデックス）への更新は発生しない。

## メッセージ仕様

| 種別 | 条件 | メッセージ/レスポンス |
|------|------|---------------------|
| 成功 | 正常取得時 | テーブル形式のシャード情報（HTTPステータス200） |
| 成功 | 該当シャードなし | 空テーブル（HTTPステータス200） |
| エラー | クラスタマネージャ接続タイムアウト | 接続タイムアウトエラー（HTTPステータス503） |
| エラー | 存在しないインデックス指定時 | index_not_found_exception（HTTPステータス404） |

## 例外処理

- クラスタマネージャノードへの接続がタイムアウトした場合、`cluster_manager_timeout`で指定された時間後にタイムアウトエラーを返す
- 指定されたインデックスが存在しない場合は404エラーを返す
- `cancel_after_time_interval`パラメータにより、長時間実行を中断可能
- リクエストリミットチェック（`isRequestLimitCheckSupported`がtrue）により、大量シャード環境でのレスポンスサイズ制限が適用される

## 備考

- `master_timeout`パラメータはOpenSearch 2.0.0で非推奨。`cluster_manager_timeout`を使用すること
- `AbstractListAction`を継承しており、ページネーション機能のインフラは存在するが、`isActionPaginated()`はfalseを返すため、現時点ではページネーションは無効
- prirep列の値: p=プライマリ、r=レプリカ、s=検索専用レプリカ
- 再配置中のシャードはnode列に `{元IP} -> {先IP} {先ノードID} {先ノード名}` の形式で表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

シャード情報の表示にはクラスタルーティング情報とインデックス統計の2つのデータソースが必要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | cat.shards.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cat.shards.json` | APIのパス、パラメータ定義を確認 |
| 1-2 | CatShardsRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/shards/CatShardsRequest.java` | リクエストオブジェクトの構造（indices, pageParams, cancelAfterTimeInterval） |
| 1-3 | CatShardsResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/shards/CatShardsResponse.java` | レスポンスオブジェクト（nodes, indicesStatsResponse, responseShards, pageToken） |

**読解のコツ**: CatShardsRequestはClusterManagerNodeReadRequestを継承しており、クラスタマネージャノードに転送されて処理される点に注目する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestShardsAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestShardsAction.java` | AbstractListActionを継承したRESTハンドラ |

**主要処理フロー**:
1. **行91-93**: ルート定義 `/_cat/shards` と `/_cat/shards/{index}`
2. **行117-142**: `doCatRequest()`でCatShardsRequestを構築しCatShardsActionを実行
3. **行149-358**: `getTableWithHeader()`で80以上のカラムを定義
4. **行371-598**: `buildTable()`でシャードごとにテーブル行を構築

#### Step 3: テーブル構築ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RestShardsAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestShardsAction.java` | buildTable()メソッド（行371-598）でShardRouting, CommonStats, CommitStatsからテーブル行を構築 |
| 3-2 | AbstractListAction.java | `server/src/main/java/org/opensearch/rest/action/list/AbstractListAction.java` | ページネーション基盤クラス |

**主要処理フロー**:
- **行380**: responseSharedsをループ処理
- **行381-387**: ShardStatsから共通統計とコミット統計を取得
- **行394-402**: プライマリ(p)/レプリカ(r)/検索専用(s)の判別
- **行406-429**: 割り当て済みノードの情報取得、再配置中の場合は移動先情報も付加
- **行433-444**: 未割り当て情報の表示

### プログラム呼び出し階層図

```
RestShardsAction.doCatRequest() [行117]
    |
    +-- CatShardsRequest 構築 [行118-126]
    |
    +-- client.execute(CatShardsAction.INSTANCE, ...) [行127]
    |       |
    |       +-- CatShardsAction (TransportAction)
    |               |
    |               +-- ClusterState取得 -> ShardRouting一覧
    |               +-- IndicesStatsAction -> ShardStats取得
    |               +-- CatShardsResponse構築
    |
    +-- buildTable() [行371]
    |       |
    |       +-- getTableWithHeader() [行149] -- 80+カラム定義
    |       +-- ShardRoutingループ [行380]
    |               +-- ShardStats/CommonStats取得
    |               +-- テーブル行構築
    |
    +-- RestTable.buildResponse() [行130]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

GET /_cat/shards   ---> RestShardsAction              テーブル形式
  ?v=true                  |                           レスポンス
  &format=json             +-> CatShardsAction         (text/json/yaml)
                           |     +-> ClusterState
                           |     +-> IndicesStats
                           |     +-> CatShardsResponse
                           +-> buildTable()
                           +-> RestTable.buildResponse()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestShardsAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestShardsAction.java` | ソース | RESTエンドポイントハンドラ（テーブル構築含む） |
| CatShardsRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/shards/CatShardsRequest.java` | ソース | リクエストオブジェクト |
| CatShardsResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/shards/CatShardsResponse.java` | ソース | レスポンスオブジェクト |
| CatShardsAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/shards/CatShardsAction.java` | ソース | トランスポートアクション定義 |
| AbstractListAction.java | `server/src/main/java/org/opensearch/rest/action/list/AbstractListAction.java` | ソース | ページネーション基盤クラス |
| RestShardsListAction.java | `server/src/main/java/org/opensearch/rest/action/list/RestShardsListAction.java` | ソース | リスト形式シャードアクション |
| cat.shards.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cat.shards.json` | 設定 | REST APIスペック定義 |
| RestShardsActionTests.java | `server/src/test/java/org/opensearch/rest/action/cat/RestShardsActionTests.java` | テスト | ユニットテスト |
