# 画面設計書 162-Cat スナップショット

## 概要

本ドキュメントは、OpenSearchのCat Snapshots API（`GET /_cat/snapshots`）の画面設計書である。特定リポジトリの全スナップショットをテーブル形式で返すREST APIエンドポイントについて、入出力仕様・処理フロー・データベース影響等を定義する。

### 本画面の処理概要

Cat Snapshots APIは、スナップショットリポジトリに保存されているスナップショットの一覧情報を、人間が読みやすいテーブル形式で返すAPIエンドポイントである。

**業務上の目的・背景**：バックアップ・リストア運用において、リポジトリ内のスナップショット一覧を簡単に確認する必要がある。本APIにより、各スナップショットのステータス（SUCCESS/IN_PROGRESS/FAILED等）、開始・終了時刻、所要時間、含まれるインデックス数、シャードの成功/失敗数を迅速に把握でき、バックアップの正常性確認やリストア対象の選定を支援する。

**画面へのアクセス方法**：HTTPクライアントから `GET /_cat/snapshots` または `GET /_cat/snapshots/{repository}` にリクエストを送信する。

**主要な操作・処理内容**：
1. 指定リポジトリのスナップショット情報を取得する（GetSnapshotsAction）
2. 各スナップショットのID、ステータス、開始/終了時刻、所要時間、インデックス数、シャード情報を収集する
3. 進行中のスナップショットの場合、所要時間は現在時刻から算出する
4. テーブル形式でレスポンスを返す

**画面遷移**：本APIは単独で使用される。関連APIとして、Cat Repositories（`GET /_cat/repositories`）でリポジトリ一覧を確認した後、本APIで特定リポジトリのスナップショット一覧を確認する流れが一般的である。

**権限による表示制御**：セキュリティプラグイン導入時は、スナップショットリポジトリへのアクセス権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | スナップショット作成・管理 | 主機能 | 特定リポジトリの全スナップショットをテーブル形式で返す処理 |

## 画面種別

一覧（テーブル形式表示）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_cat/snapshots` | 全リポジトリのスナップショット情報を返す |
| GET | `/_cat/snapshots/{repository}` | 指定リポジトリのスナップショット情報を返す |

## 入出力項目

### リクエストパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| repository | list | No | - | スナップショット情報取得元のリポジトリ名 |
| format | string | No | text | レスポンス形式 |
| ignore_unavailable | boolean | No | false | 利用不可スナップショットを無視するか |
| cluster_manager_timeout | time | No | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | No | 30s | 非推奨。cluster_manager_timeoutを使用すること |
| h | list | No | - | 表示するカラム名のカンマ区切りリスト |
| help | boolean | No | false | ヘルプ情報を返す |
| s | list | No | - | ソートするカラム名のカンマ区切りリスト |
| time | enum | No | ms | 時間値の表示単位（d/h/m/s/ms/micros/nanos） |
| v | boolean | No | false | カラムヘッダを表示するか |

## 表示項目

| カラム名 | エイリアス | 説明 |
|---------|----------|------|
| id | id, snapshot | スナップショットの一意名 |
| status | s, status | スナップショットの状態（SUCCESS/IN_PROGRESS/FAILED/PARTIAL等） |
| start_epoch | ste, startEpoch | 開始時刻（1970-01-01 00:00:00からの秒数） |
| start_time | sti, startTime | 開始時刻（HH:MM:SS形式、UTC） |
| end_epoch | ete, endEpoch | 終了時刻（1970-01-01 00:00:00からの秒数） |
| end_time | eti, endTime | 終了時刻（HH:MM:SS形式、UTC） |
| duration | dur, duration | 所要時間 |
| indices | i, indices | 含まれるインデックス数 |
| successful_shards | ss | 成功シャード数 |
| failed_shards | fs | 失敗シャード数 |
| total_shards | ts | 合計シャード数 |
| reason | r, reason | 失敗理由（デフォルト非表示） |

## イベント仕様

### 1-GETリクエスト受信

1. `RestSnapshotAction.doCatRequest()`がリクエストを受信する
2. `GetSnapshotsRequest`を構築し、全スナップショット（`ALL_SNAPSHOTS`）を要求する
3. `client.admin().cluster().getSnapshots()`を実行する
4. `buildTable()`で各SnapshotInfoからテーブル行を構築する
5. IN_PROGRESS状態のスナップショットはdurationを現在時刻から動的算出する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| GETリクエスト | - | SELECT | スナップショットリポジトリのメタデータを参照のみ。データ更新なし |

## メッセージ仕様

| 種別 | 条件 | メッセージ/レスポンス |
|------|------|---------------------|
| 成功 | 正常取得時 | テーブル形式のスナップショット情報（HTTPステータス200） |
| 成功 | スナップショットなし | 空テーブル（HTTPステータス200） |
| エラー | リポジトリ未指定かつ存在しない場合 | repository_missing_exception（HTTPステータス404） |
| エラー | クラスタマネージャ接続タイムアウト | 接続タイムアウトエラー（HTTPステータス503） |

## 例外処理

- 指定リポジトリが存在しない場合は`repository_missing_exception`を返す
- `ignore_unavailable=true`の場合、利用不可スナップショットはスキップされる
- クラスタマネージャノードへの接続タイムアウト時はエラーレスポンスを返す

## 備考

- `master_timeout`パラメータはOpenSearch 2.0.0で非推奨
- 時刻表示はUTCの`HH:mm:ss`形式（DateFormatterで定義）
- 進行中スナップショットのdurationは`System.currentTimeMillis() - startTime`で動的計算

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | cat.snapshots.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cat.snapshots.json` | APIパス・パラメータ定義 |
| 1-2 | SnapshotInfo.java | `server/src/main/java/org/opensearch/snapshots/SnapshotInfo.java` | スナップショット情報の構造（snapshotId, state, startTime, endTime, indices等） |
| 1-3 | SnapshotState.java | `server/src/main/java/org/opensearch/snapshots/SnapshotState.java` | スナップショット状態の列挙（IN_PROGRESS, SUCCESS, FAILED, PARTIAL等） |

**読解のコツ**: SnapshotInfoがテーブル各列の情報源である点を押さえる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestSnapshotAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestSnapshotAction.java` | AbstractCatActionを継承したRESTハンドラ |

**主要処理フロー**:
1. **行67-69**: ルート定義 `/_cat/snapshots` と `/_cat/snapshots/{repository}`
2. **行77-96**: `doCatRequest()`でGetSnapshotsRequestを構築し実行
3. **行104-119**: `getTableWithHeader()`で12カラムを定義
4. **行123-151**: `buildTable()`で各SnapshotInfoからテーブル行を構築

#### Step 3: 所要時間計算ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RestSnapshotAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestSnapshotAction.java` | 行134-139: IN_PROGRESS時とそれ以外でduration計算が異なる |

### プログラム呼び出し階層図

```
RestSnapshotAction.doCatRequest() [行77]
    |
    +-- GetSnapshotsRequest 構築 [行78-86]
    |
    +-- client.admin().cluster().getSnapshots() [行88-96]
    |       |
    |       +-- GetSnapshotsAction
    |               +-- リポジトリからスナップショット一覧取得
    |               +-- GetSnapshotsResponse構築
    |
    +-- buildTable() [行123]
    |       +-- SnapshotInfoループ [行125]
    |       +-- テーブル行構築 [行126-147]
    |
    +-- RestTable.buildResponse() [行93]
```

### データフロー図

```
[入力]                        [処理]                          [出力]

GET /_cat/snapshots    ---> RestSnapshotAction             テーブル形式
  /{repository}              |                              レスポンス
                             +-> GetSnapshotsAction
                             |     +-> SnapshotRepository
                             |     +-> SnapshotInfo一覧
                             +-> buildTable()
                             +-> RestTable.buildResponse()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestSnapshotAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestSnapshotAction.java` | ソース | RESTエンドポイントハンドラ |
| GetSnapshotsRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/snapshots/get/GetSnapshotsRequest.java` | ソース | リクエストオブジェクト |
| GetSnapshotsResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/snapshots/get/GetSnapshotsResponse.java` | ソース | レスポンスオブジェクト |
| SnapshotInfo.java | `server/src/main/java/org/opensearch/snapshots/SnapshotInfo.java` | ソース | スナップショット情報データ構造 |
| cat.snapshots.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cat.snapshots.json` | 設定 | REST APIスペック定義 |
