# 画面設計書 163-Cat タスク

## 概要

本ドキュメントは、OpenSearchのCat Tasks API（`GET /_cat/tasks`）の画面設計書である。クラスタ内で実行中のタスク情報をテーブル形式で返すREST APIエンドポイントについて、入出力仕様・処理フロー・データベース影響等を定義する。

### 本画面の処理概要

Cat Tasks APIは、クラスタ内の全ノードで現在実行中のタスクの一覧情報を、人間が読みやすいテーブル形式で返すAPIエンドポイントである。

**業務上の目的・背景**：クラスタの運用監視において、長時間実行中のタスクやスタックしたタスクを特定する必要がある。本APIにより、各タスクのアクション名、実行時間、実行ノード、親タスクIDなどを確認でき、パフォーマンス問題の診断やタスクキャンセルの判断を支援する。特にreindex、delete_by_query、update_by_queryなどの長時間タスクの監視に有用である。

**画面へのアクセス方法**：HTTPクライアントから `GET /_cat/tasks` にリクエストを送信する。

**主要な操作・処理内容**：
1. ListTasksRequestを生成し、クラスタ全体のタスク一覧を取得する
2. タスクをTaskGroupとして階層化し、開始時刻でソートする
3. 各タスクのID、アクション名、タスクID、親タスクID、タイプ、開始時刻、実行時間、ノード情報を収集する
4. detailedモードが有効な場合はタスク説明やリソース統計も表示する

**画面遷移**：本APIは単独で使用される。特定タスクの詳細はTasks Get API（`GET /_tasks/{task_id}`）で確認し、キャンセルはTasks Cancel API（`POST /_tasks/{task_id}/_cancel`）で行う。

**権限による表示制御**：セキュリティプラグイン導入時は、タスク管理権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 51 | タスク管理 | 主機能 | クラスタ内で実行中のタスク情報をテーブル形式で返す処理 |

## 画面種別

一覧（テーブル形式表示）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_cat/tasks` | 実行中タスクの一覧を返す |

## 入出力項目

### リクエストパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| format | string | No | text | レスポンス形式 |
| nodes | list | No | - | 対象ノードIDのカンマ区切りリスト（`_local`でローカルノードのみ） |
| actions | list | No | - | フィルタするアクション名のカンマ区切りリスト |
| detailed | boolean | No | false | 詳細タスク情報を返すか |
| parent_task_id | string | No | - | 指定親タスクIDの子タスクのみ返す（-1で全タスク） |
| h | list | No | - | 表示するカラム名のカンマ区切りリスト |
| help | boolean | No | false | ヘルプ情報を返す |
| s | list | No | - | ソートするカラム名のカンマ区切りリスト |
| time | enum | No | ms | 時間値の表示単位（d/h/m/s/ms/micros/nanos） |
| v | boolean | No | false | カラムヘッダを表示するか |

## 表示項目

### 標準カラム

| カラム名 | エイリアス | デフォルト表示 | 説明 |
|---------|----------|-------------|------|
| id | - | No | ノード内タスクID |
| action | ac | Yes | タスクアクション名 |
| task_id | ti | Yes | タスクの一意ID（ノードID:タスク番号） |
| parent_task_id | pti | Yes | 親タスクID（なければ`-`） |
| type | ty | Yes | タスクタイプ |
| start_time | start | Yes | 開始時刻（ミリ秒） |
| timestamp | ts, hms, hhmmss | Yes | 開始時刻（HH:MM:SS形式、UTC） |
| running_time_ns | time | No | 実行時間（ナノ秒） |
| running_time | time | Yes | 実行時間（人間可読形式） |
| node_id | ni | No | ノードID |
| ip | i | Yes | ノードIPアドレス |
| port | po | No | トランスポートポート |
| node | n | Yes | ノード名 |
| version | v | No | OpenSearchバージョン |
| x_opaque_id | x | No | X-Opaque-IDヘッダ値 |

### detailedモード追加カラム

| カラム名 | エイリアス | 説明 |
|---------|----------|------|
| description | desc | タスクの説明 |
| resource_stats | - | タスクのリソース消費情報 |

## イベント仕様

### 1-GETリクエスト受信

1. `RestTasksAction.doCatRequest()`がリクエストを受信する
2. `generateListTasksRequest()`で`ListTasksRequest`を構築する
3. `client.admin().cluster().listTasks()`を実行する
4. `buildTable()`でTaskGroupを開始時刻でソートし、再帰的にテーブル行を構築する
5. 親タスクから子タスクの順に行を出力する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| GETリクエスト | - | SELECT | タスク管理情報を参照のみ。データ更新なし |

## メッセージ仕様

| 種別 | 条件 | メッセージ/レスポンス |
|------|------|---------------------|
| 成功 | 正常取得時 | テーブル形式のタスク情報（HTTPステータス200） |
| 成功 | 実行中タスクなし | 空テーブル（HTTPステータス200） |
| エラー | ノード接続エラー | ノード障害情報を含むレスポンス |

## 例外処理

- タスク情報取得中にノードが離脱した場合、そのノードのタスク情報は`-`で表示される（行174-177でnull安全チェック）
- 親タスクIDが設定されていないタスクは`-`と表示される（行161-165）
- DiscoveryNodesからノード情報が取得できない場合はIP/ポート/ノード名に`-`を表示

## 備考

- タスクはTaskGroupとして階層化され、開始時刻の昇順でソートされる
- `detailed=true`を指定するとdescriptionとresource_statsカラムが追加される
- X-Opaque-IDヘッダはリクエスト追跡用の識別子で、設定されていない場合は`-`を表示
- `nodesInCluster` SupplierはDiscoveryNodesをリアルタイムで取得し、ノード離脱に対応する

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | cat.tasks.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cat.tasks.json` | APIパス・パラメータ定義 |
| 1-2 | TaskInfo.java | `server/src/main/java/org/opensearch/tasks/TaskInfo.java` | タスク情報の構造（taskId, action, type, startTime, runningTimeNanos等） |
| 1-3 | TaskGroup.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/list/TaskGroup.java` | タスクの親子階層構造 |

**読解のコツ**: TaskInfoが各テーブル行の情報源、TaskGroupが階層表示のデータ構造であることを理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestTasksAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestTasksAction.java` | AbstractCatActionを継承したRESTハンドラ |

**主要処理フロー**:
1. **行79**: ルート定義 `/_cat/tasks`
2. **行93-101**: `doCatRequest()`でListTasksRequestを構築し実行
3. **行118-149**: `getTableWithHeader()`でカラム定義（detailedフラグで追加カラム制御）
4. **行153-185**: `buildRow()`で個別タスク行を構築
5. **行187-195**: `buildGroups()`で再帰的にTaskGroup階層を展開

#### Step 3: リクエスト生成ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RestListTasksAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestListTasksAction.java` | `generateListTasksRequest()`メソッドでフィルタリングパラメータを解析 |

### プログラム呼び出し階層図

```
RestTasksAction.doCatRequest() [行93]
    |
    +-- generateListTasksRequest(request) [行94]
    |       (RestListTasksAction.generateListTasksRequest)
    |
    +-- client.admin().cluster().listTasks() [行95]
    |       |
    |       +-- ListTasksAction
    |               +-- 各ノードからタスク情報収集
    |               +-- ListTasksResponse構築
    |
    +-- buildTable() [行197]
    |       +-- buildGroups() [行187] (再帰)
    |               +-- ソート (startTime昇順)
    |               +-- buildRow() [行153] 各TaskInfo
    |               +-- buildGroups() 子TaskGroup
    |
    +-- RestTable.buildResponse() [行98]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

GET /_cat/tasks    ---> RestTasksAction              テーブル形式
  ?detailed=true          |                           レスポンス
                          +-> ListTasksAction
                          |     +-> 各ノードからタスク収集
                          |     +-> TaskGroup階層化
                          +-> buildTable()
                          |     +-> buildGroups() 再帰
                          +-> RestTable.buildResponse()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestTasksAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestTasksAction.java` | ソース | RESTエンドポイントハンドラ |
| RestListTasksAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestListTasksAction.java` | ソース | ListTasksRequest生成ヘルパー |
| ListTasksRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/list/ListTasksRequest.java` | ソース | リクエストオブジェクト |
| ListTasksResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/list/ListTasksResponse.java` | ソース | レスポンスオブジェクト |
| TaskGroup.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/list/TaskGroup.java` | ソース | タスク階層構造 |
| TaskInfo.java | `server/src/main/java/org/opensearch/tasks/TaskInfo.java` | ソース | タスク情報データ構造 |
| cat.tasks.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cat.tasks.json` | 設定 | REST APIスペック定義 |
