# 画面設計書 164-Cat テンプレート

## 概要

本ドキュメントは、OpenSearchのCat Templates API（`GET /_cat/templates`）の画面設計書である。既存テンプレートの情報をテーブル形式で返すREST APIエンドポイントについて、入出力仕様・処理フロー・データベース影響等を定義する。

### 本画面の処理概要

Cat Templates APIは、クラスタに登録されているインデックステンプレート（レガシーテンプレートおよびComposableインデックステンプレート）の一覧情報を、人間が読みやすいテーブル形式で返すAPIエンドポイントである。

**業務上の目的・背景**：インデックステンプレートの管理において、クラスタに登録済みのテンプレートを一覧で確認する必要がある。本APIにより、テンプレート名、インデックスパターン、優先度、バージョン、構成コンポーネントを迅速に把握でき、テンプレートの重複確認や優先度調整、コンポーネントテンプレートの利用状況確認を支援する。レガシーテンプレートとComposableテンプレートの両方を一覧できる点が特に有用である。

**画面へのアクセス方法**：HTTPクライアントから `GET /_cat/templates` または `GET /_cat/templates/{name}` にリクエストを送信する。

**主要な操作・処理内容**：
1. クラスタ状態からメタデータを取得する（ClusterStateRequest）
2. レガシーテンプレート（IndexTemplateMetadata）を列挙する
3. Composableインデックステンプレート（ComposableIndexTemplate）を列挙する
4. nameパラメータが指定されている場合はパターンマッチでフィルタリングする
5. テーブル形式でレスポンスを返す

**画面遷移**：本APIは単独で使用される。テンプレートの詳細確認にはGet Index Template API（`GET /_index_template/{name}`）を使用する。

**権限による表示制御**：セキュリティプラグイン導入時は、クラスタ状態の読み取り権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | インデックステンプレート | 主機能 | 既存テンプレートの情報をテーブル形式で返す処理 |

## 画面種別

一覧（テーブル形式表示）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_cat/templates` | 全テンプレートの情報を返す |
| GET | `/_cat/templates/{name}` | パターンに一致するテンプレートの情報を返す |

## 入出力項目

### リクエストパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| name | string | No | - | テンプレート名のマッチパターン |
| format | string | No | text | レスポンス形式 |
| local | boolean | No | false | ローカルノードの情報のみ返すか |
| cluster_manager_timeout | time | No | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | No | 30s | 非推奨。cluster_manager_timeoutを使用すること |
| h | list | No | - | 表示するカラム名のカンマ区切りリスト |
| help | boolean | No | false | ヘルプ情報を返す |
| s | list | No | - | ソートするカラム名のカンマ区切りリスト |
| v | boolean | No | false | カラムヘッダを表示するか |

## 表示項目

| カラム名 | エイリアス | 説明 |
|---------|----------|------|
| name | n | テンプレート名 |
| index_patterns | t | テンプレートのインデックスパターン（例: `[logs-*]`） |
| order | o, p | テンプレートの適用優先度（レガシー: order、Composable: priority） |
| version | v | テンプレートのバージョン |
| composed_of | c | 構成するコンポーネントテンプレート一覧（Composableテンプレートのみ） |

## イベント仕様

### 1-GETリクエスト受信

1. `RestTemplatesAction.doCatRequest()`がリクエストを受信する
2. `ClusterStateRequest`を構築し、metadata=trueで状態を要求する
3. `client.admin().cluster().state()`を実行する
4. `buildTable()`でレガシーテンプレートとComposableテンプレートの両方を処理する
5. nameパラメータが指定されている場合、`Regex.simpleMatch()`でフィルタリングする
6. レガシーテンプレートのcomposed_of列は空文字列となる

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| GETリクエスト | - | SELECT | クラスタ状態のメタデータを参照のみ。データ更新なし |

## メッセージ仕様

| 種別 | 条件 | メッセージ/レスポンス |
|------|------|---------------------|
| 成功 | 正常取得時 | テーブル形式のテンプレート情報（HTTPステータス200） |
| 成功 | テンプレートなし/パターン不一致 | 空テーブル（HTTPステータス200） |
| エラー | クラスタマネージャ接続タイムアウト | 接続タイムアウトエラー（HTTPステータス503） |

## 例外処理

- nameパラメータが指定されているが一致するテンプレートがない場合、空テーブルを返す（エラーにはならない）
- クラスタマネージャノードへの接続タイムアウト時はエラーレスポンスを返す

## 備考

- `master_timeout`パラメータはOpenSearch 2.0.0で非推奨
- レガシーテンプレート（`metadata.templates()`）とComposableテンプレート（`metadata.templatesV2()`）の両方が一覧に含まれる
- レガシーテンプレートはorder値、Composableテンプレートはpriorityが"order"列に表示される
- composed_of列はComposableテンプレートのみで、レガシーテンプレートでは空文字列
- nameパラメータはワイルドカード（`Regex.simpleMatch`）をサポート

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | cat.templates.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cat.templates.json` | APIパス・パラメータ定義 |
| 1-2 | IndexTemplateMetadata.java | `server/src/main/java/org/opensearch/cluster/metadata/IndexTemplateMetadata.java` | レガシーテンプレートの構造（name, patterns, order, version） |
| 1-3 | ComposableIndexTemplate.java | `server/src/main/java/org/opensearch/cluster/metadata/ComposableIndexTemplate.java` | Composableテンプレートの構造（indexPatterns, priority, version, composedOf） |

**読解のコツ**: 2種類のテンプレート（レガシーとComposable）が同一テーブルに混在して表示される点に注意する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestTemplatesAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestTemplatesAction.java` | AbstractCatActionを継承したRESTハンドラ |

**主要処理フロー**:
1. **行65-67**: ルート定義 `/_cat/templates` と `/_cat/templates/{name}`
2. **行80-96**: `doCatRequest()`でClusterStateRequestを構築し実行
3. **行99-109**: `getTableWithHeader()`で5カラムを定義
4. **行111-140**: `buildTable()`でレガシーテンプレートとComposableテンプレートを別々に処理
5. **行114-124**: レガシーテンプレートのループ処理（composed_ofは空文字列）
6. **行126-138**: Composableテンプレートのループ処理（composed_ofにコンポーネント一覧）

### プログラム呼び出し階層図

```
RestTemplatesAction.doCatRequest() [行80]
    |
    +-- ClusterStateRequest 構築 [行82-88]
    |       (clear().metadata(true))
    |
    +-- client.admin().cluster().state() [行90]
    |       |
    |       +-- ClusterStateAction
    |               +-- Metadata取得
    |
    +-- buildTable() [行111]
    |       +-- metadata.templates() ループ [行114] -- レガシー
    |       |       +-- Regex.simpleMatch() フィルタ
    |       |       +-- テーブル行構築
    |       +-- metadata.templatesV2() ループ [行126] -- Composable
    |               +-- Regex.simpleMatch() フィルタ
    |               +-- テーブル行構築
    |
    +-- RestTable.buildResponse() [行93]
```

### データフロー図

```
[入力]                        [処理]                          [出力]

GET /_cat/templates    ---> RestTemplatesAction             テーブル形式
  /{name}                    |                              レスポンス
                             +-> ClusterStateAction
                             |     +-> Metadata
                             |         +-> templates() (レガシー)
                             |         +-> templatesV2() (Composable)
                             +-> buildTable()
                             |     +-> simpleMatchフィルタ
                             +-> RestTable.buildResponse()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestTemplatesAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestTemplatesAction.java` | ソース | RESTエンドポイントハンドラ |
| IndexTemplateMetadata.java | `server/src/main/java/org/opensearch/cluster/metadata/IndexTemplateMetadata.java` | ソース | レガシーテンプレートデータ構造 |
| ComposableIndexTemplate.java | `server/src/main/java/org/opensearch/cluster/metadata/ComposableIndexTemplate.java` | ソース | Composableテンプレートデータ構造 |
| Metadata.java | `server/src/main/java/org/opensearch/cluster/metadata/Metadata.java` | ソース | クラスタメタデータ（templates(), templatesV2()） |
| Regex.java | `server/src/main/java/org/opensearch/common/regex/Regex.java` | ソース | パターンマッチユーティリティ |
| cat.templates.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cat.templates.json` | 設定 | REST APIスペック定義 |
