# 画面設計書 165-Cat スレッドプール

## 概要

本ドキュメントは、OpenSearchのCat Thread Pool API（`GET /_cat/thread_pool`）の画面設計書である。クラスタ全体のスレッドプール統計をテーブル形式で返すREST APIエンドポイントについて、入出力仕様・処理フロー・データベース影響等を定義する。

### 本画面の処理概要

Cat Thread Pool APIは、クラスタ内の各ノードにおけるスレッドプールの統計情報（アクティブスレッド数、キュー数、拒否数など）を、人間が読みやすいテーブル形式で返すAPIエンドポイントである。

**業務上の目的・背景**：クラスタのパフォーマンス監視において、各スレッドプールの負荷状況を確認する必要がある。本APIにより、検索（search）、インデキシング（write）、マージ（force_merge）などの各スレッドプールのアクティブスレッド数、キュー待ちタスク数、拒否数を確認でき、スロットリングの発生やキューの溢れを検知して適切なチューニングを行うことができる。特にrejected数の増加はクラスタ過負荷の重要なシグナルである。

**画面へのアクセス方法**：HTTPクライアントから `GET /_cat/thread_pool` または `GET /_cat/thread_pool/{thread_pool_patterns}` にリクエストを送信する。

**主要な操作・処理内容**：
1. クラスタ状態からノード一覧を取得する（ClusterStateRequest）
2. 各ノードのスレッドプール設定情報を取得する（NodesInfoRequest）
3. 各ノードのスレッドプール統計情報を取得する（NodesStatsRequest）
4. パターンマッチで対象スレッドプールをフィルタリングする
5. ノード/スレッドプールごとにテーブル行を構築する

**画面遷移**：本APIは単独で使用される。ノードの詳細情報はNodes Info API（`GET /_nodes`）で確認できる。

**権限による表示制御**：セキュリティプラグイン導入時は、クラスタ状態およびノード情報の読み取り権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 128 | スレッドプール管理 | 主機能 | クラスタ全体のスレッドプール統計をテーブル形式で返す処理 |

## 画面種別

一覧（テーブル形式表示）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_cat/thread_pool` | 全スレッドプールの統計を返す |
| GET | `/_cat/thread_pool/{thread_pool_patterns}` | パターンに一致するスレッドプールの統計を返す |

## 入出力項目

### リクエストパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| thread_pool_patterns | list | No | * | フィルタする正規表現パターンのカンマ区切りリスト |
| format | string | No | text | レスポンス形式 |
| local | boolean | No | false | ローカルノードの情報のみ返すか |
| cluster_manager_timeout | time | No | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | No | 30s | 非推奨。cluster_manager_timeoutを使用すること |
| h | list | No | - | 表示するカラム名のカンマ区切りリスト |
| help | boolean | No | false | ヘルプ情報を返す |
| s | list | No | - | ソートするカラム名のカンマ区切りリスト |
| v | boolean | No | false | カラムヘッダを表示するか |

## 表示項目

| カラム名 | エイリアス | デフォルト表示 | 説明 |
|---------|----------|-------------|------|
| node_name | nn | Yes | ノード名 |
| node_id | id | No | ノードの永続ID |
| ephemeral_node_id | eid | No | ノードのエフェメラルID |
| pid | p | No | プロセスID |
| host | h | No | ホスト名 |
| ip | i | No | IPアドレス |
| port | po | No | トランスポートポート |
| name | n | Yes | スレッドプール名 |
| type | t | No | スレッドプールタイプ（fixed/scaling/fork_join） |
| active | a | Yes | アクティブスレッド数 |
| pool_size | psz | No | スレッド数 |
| queue | q | Yes | キュー内タスク数 |
| queue_size | qs | No | キュー最大サイズ |
| rejected | r | Yes | 拒否タスク数 |
| largest | l | No | 最大アクティブスレッド数 |
| completed | c | No | 完了タスク数 |
| total_wait_time | twt | No | キュー待ち合計時間 |
| core | cr | No | scalingプールの最小スレッド数 |
| max | mx | No | scalingプールの最大スレッド数 |
| size | sz | No | fixedプールのスレッド数 |
| keep_alive | ka | No | スレッドキープアライブ時間 |
| parallelism | pl | No | fork_joinプールのワーカースレッド数 |

## イベント仕様

### 1-GETリクエスト受信

1. `RestThreadPoolAction.doCatRequest()`がリクエストを受信する
2. `ClusterStateRequest`を構築し、nodes情報のみ要求する
3. クラスタ状態取得後、`NodesInfoRequest`でプロセス情報とスレッドプール情報を要求する
4. ノード情報取得後、`NodesStatsRequest`でスレッドプール統計を要求する
5. 3段階のネストされたコールバックで全データを収集し、`buildTable()`でテーブルを構築する
6. `Regex.simpleMatch()`でthread_pool_patternsフィルタを適用する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| GETリクエスト | - | SELECT | クラスタ状態・ノード情報・ノード統計を参照のみ。データ更新なし |

## メッセージ仕様

| 種別 | 条件 | メッセージ/レスポンス |
|------|------|---------------------|
| 成功 | 正常取得時 | テーブル形式のスレッドプール統計（HTTPステータス200） |
| 成功 | パターン不一致 | 空テーブル（HTTPステータス200） |
| エラー | クラスタマネージャ接続タイムアウト | 接続タイムアウトエラー（HTTPステータス503） |

## 例外処理

- ノードの統計情報が取得できない場合（ノード離脱等）、該当ノードのスレッドプール情報はスキップされる
- fork_joinタイプのスレッドプールは特別処理され、active/pool_size/queue等は0、parallelism列にmax値が表示される
- poolInfoがnullの場合、type/active/queue等はnullで表示される

## 備考

- `master_timeout`パラメータはOpenSearch 2.0.0で非推奨
- `size`パラメータはOpenSearch 7.7.0で非推奨（効果なし）
- 3段階のネストされた非同期コールバック（ClusterState -> NodesInfo -> NodesStats）で実装されている
- スレッドプール名はソートされたTreeMapを使用して名前順で表示される
- fork_joinタイプのスレッドプールは専用の表示ロジック（行204-219）を持つ
- fixedタイプは`size`列、scalingタイプは`core`/`max`列に値が表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | cat.thread_pool.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cat.thread_pool.json` | APIパス・パラメータ定義 |
| 1-2 | ThreadPool.java | `server/src/main/java/org/opensearch/threadpool/ThreadPool.java` | ThreadPool.Infoの構造（name, type, min, max, queueSize, keepAlive） |
| 1-3 | ThreadPoolStats.java | `server/src/main/java/org/opensearch/threadpool/ThreadPoolStats.java` | ThreadPoolStats.Statsの構造（active, threads, queue, rejected, largest, completed, waitTime） |

**読解のコツ**: ThreadPool.Info（設定情報）とThreadPoolStats.Stats（ランタイム統計）の2種類のデータソースがあることを理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestThreadPoolAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestThreadPoolAction.java` | AbstractCatActionを継承したRESTハンドラ |

**主要処理フロー**:
1. **行80-82**: ルート定義 `/_cat/thread_pool` と `/_cat/thread_pool/{thread_pool_patterns}`
2. **行96-131**: `doCatRequest()`で3段階ネストコールバック（ClusterState -> NodesInfo -> NodesStats）
3. **行147-177**: `getTableWithHeader()`で22カラムを定義
4. **行180-263**: `writeRow()`でスレッドプールタイプ別の行構築（fork_join専用処理あり）
5. **行265-335**: `buildTable()`でノードごとにスレッドプール統計を処理

#### Step 3: テーブル構築ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RestThreadPoolAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestThreadPoolAction.java` | buildTable()メソッド（行265-335）でノードごとにスレッドプール統計を収集 |

**主要処理フロー**:
- **行266**: thread_pool_patternsパラメータを解析（デフォルト: `*`）
- **行271-276**: 全ノードからスレッドプール名候補を収集
- **行279-284**: パターンマッチでフィルタ
- **行286-332**: ノードごとにTreeMapでソートしてwriteRow()を呼び出し

### プログラム呼び出し階層図

```
RestThreadPoolAction.doCatRequest() [行96]
    |
    +-- ClusterStateRequest 構築 [行97-103]
    |       (clear().nodes(true))
    |
    +-- client.admin().cluster().state() [行105]
    |       |
    |       +-- processResponse() [行107]
    |               |
    |               +-- NodesInfoRequest 構築 [行108-111]
    |               |       (PROCESS, THREAD_POOL)
    |               |
    |               +-- client.admin().cluster().nodesInfo() [行112]
    |                       |
    |                       +-- processResponse() [行114]
    |                               |
    |                               +-- NodesStatsRequest 構築 [行115-117]
    |                               |       (THREAD_POOL)
    |                               |
    |                               +-- client.admin().cluster().nodesStats() [行118]
    |                                       |
    |                                       +-- buildTable() [行265]
    |                                               +-- パターンマッチフィルタ
    |                                               +-- ノードループ
    |                                                   +-- writeRow() [行180]
    |
    +-- RestTable.buildResponse() [行121]
```

### データフロー図

```
[入力]                            [処理]                          [出力]

GET /_cat/thread_pool       ---> RestThreadPoolAction          テーブル形式
  /{thread_pool_patterns}         |                             レスポンス
                                  +-> ClusterStateAction
                                  |     +-> DiscoveryNodes
                                  +-> NodesInfoAction
                                  |     +-> ThreadPoolInfo
                                  |     +-> ProcessInfo
                                  +-> NodesStatsAction
                                  |     +-> ThreadPoolStats
                                  +-> buildTable()
                                  |     +-> パターンフィルタ
                                  |     +-> writeRow()
                                  +-> RestTable.buildResponse()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestThreadPoolAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestThreadPoolAction.java` | ソース | RESTエンドポイントハンドラ |
| ThreadPool.java | `server/src/main/java/org/opensearch/threadpool/ThreadPool.java` | ソース | スレッドプール管理（Info内部クラス含む） |
| ThreadPoolStats.java | `server/src/main/java/org/opensearch/threadpool/ThreadPoolStats.java` | ソース | スレッドプール統計データ構造 |
| ThreadPoolInfo.java | `server/src/main/java/org/opensearch/threadpool/ThreadPoolInfo.java` | ソース | スレッドプール設定情報 |
| Regex.java | `server/src/main/java/org/opensearch/common/regex/Regex.java` | ソース | パターンマッチユーティリティ |
| cat.thread_pool.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cat.thread_pool.json` | 設定 | REST APIスペック定義 |
