# 画面設計書 18-Reindexスロットル変更

## 概要

本ドキュメントは、OpenSearchのReindex Rethrottle API（`_reindex/{task_id}/_rethrottle`）エンドポイントに関する画面設計書である。実行中のReindex操作のスロットル値（リクエスト/秒）を動的に変更するためのREST APIインターフェースを定義する。

### 本画面の処理概要

本APIは、実行中のReindex操作に対してスロットル値を動的に変更する機能を提供する。Delete By Query Rethrottle（No.14）、Update By Query Rethrottle（No.16）と同一のRestRethrottleActionクラスで処理される。

**業務上の目的・背景**：Reindex操作は大量データをインデックス間でコピーするため、長時間にわたりクラスタリソースを消費する。運用中にスロットル値を変更することで、通常のクエリ処理への影響を最小化しながら、Reindex処理の速度を動的に調整できる。

**画面へのアクセス方法**：HTTPクライアントから`POST /_reindex/{task_id}/_rethrottle?requests_per_second=N`エンドポイントにリクエストを送信する。

**主要な操作・処理内容**：
1. タスクIDとrequests_per_secondパラメータを受け取る
2. 指定されたタスクのスロットル値を更新する
3. クラスタ内の関連ノードに対してRethrottleアクションを伝播する

**画面遷移**：Reindex（No.17）でwait_for_completion=falseで実行したタスクのスロットルを変更する。タスク一覧（No.112）やタスク取得（No.113）でタスクIDを確認後に使用する。

**権限による表示制御**：タスク管理に関する権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 14 | リインデックス | 主機能 | Reindex操作のリクエスト/秒スロットルを変更する処理 |
| 51 | タスク管理 | 補助機能 | 実行中タスクのスロットル値を変更するタスク管理処理 |

## 画面種別

API（タスクスロットル変更）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| POST | `/_reindex/{task_id}/_rethrottle` | Reindexタスクのスロットル変更 |

## 入出力項目

### URLパスパラメータ

| パラメータ | 型 | 必須 | 説明 |
|-----------|------|------|------|
| task_id | string | はい | スロットルを変更するタスクのID |

### クエリパラメータ

| パラメータ | 型 | 必須 | デフォルト | 説明 |
|-----------|------|------|-----------|------|
| requests_per_second | number | はい | - | 設定するスロットル値（サブリクエスト/秒）。-1でスロットルなし |

## 表示項目

### レスポンスボディ

| フィールド | 型 | 説明 |
|-----------|------|------|
| nodes | object | ノード別のタスク情報 |
| nodes.{node_id}.tasks | object | タスク情報 |

## イベント仕様

### 1-Rethrottleリクエスト実行

1. `RestRethrottleAction.prepareRequest()`がタスクIDとrequests_per_secondを解析する（行73-87）
2. `RethrottleRequest`オブジェクトを構築し、`TaskId`とスロットル値を設定する
3. requests_per_secondがnullの場合、IllegalArgumentExceptionをスローする（行77-79）
4. `RethrottleAction.INSTANCE`を実行し、クラスタ内のタスクにスロットル変更を伝播する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Rethrottleリクエスト | なし | なし | タスクのスロットル値を変更するのみ |

### テーブル別更新項目詳細

本APIはタスクのランタイムパラメータ変更のみであり、Luceneインデックスへの直接的な更新は行わない。

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|--------------|------|--------------|
| 成功 | スロットル変更成功 | HTTPステータス200、ノード別タスク情報 |
| エラー | requests_per_second未指定 | "requests_per_second is a required parameter" |
| エラー | タスクID不正 | タスクが見つからないエラー |

## 例外処理

| 例外 | 条件 | 動作 |
|------|------|------|
| IllegalArgumentException | requests_per_secondパラメータ未指定 | HTTPステータス400 |
| ResourceNotFoundException | 指定タスクIDが存在しない場合 | エラーレスポンスを返す |

## 備考

- No.14（Delete By Query Rethrottle）、No.16（Update By Query Rethrottle）と同一のRestRethrottleActionクラスで処理される
- requests_per_secondに-1を設定するとスロットルが解除される
- rest-api-specでは`{task_id}`、RestRethrottleActionでは`{taskId}`とパラメータ名が異なる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | reindex_rethrottle.json | `rest-api-spec/src/main/resources/rest-api-spec/api/reindex_rethrottle.json` | API定義。No.14, No.16と同じ構造 |
| 1-2 | RethrottleRequest.java | `server/src/main/java/org/opensearch/index/reindex/RethrottleRequest.java` | リクエストデータ構造（共通） |

**読解のコツ**: 3つのRethrottle API（Delete By Query, Update By Query, Reindex）は全て同一のRestRethrottleActionで処理される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestRethrottleAction.java | `modules/reindex/src/main/java/org/opensearch/index/reindex/RestRethrottleAction.java` | RESTハンドラ（3API共通） |

**主要処理フロー**:
1. **行62**: routes()で`/_reindex/{taskId}/_rethrottle`のルートを定義
2. **行73-87**: prepareRequest()の処理はNo.14, No.16と同一

### プログラム呼び出し階層図

```
RestRethrottleAction.prepareRequest()                   [行73]
    |
    +-- RethrottleRequest()
    |       +-- setTaskId()                             [行75]
    |       +-- setRequestsPerSecond()                  [行80]
    |
    +-- NodeClient.execute(RethrottleAction.INSTANCE, ...)  [行82]
            |
            +-- TransportRethrottleAction
                    +-- 各ノードへのスロットル変更伝播
```

### データフロー図

```
[入力]                           [処理]                              [出力]

HTTPリクエスト              RestRethrottleAction                 ListTasksResponse
(POST /_reindex/        パラメータ解析・リクエスト構築
 {task_id}/_rethrottle)         |
   |                            v
   v                    TransportRethrottleAction              レスポンスJSON
task_id +              各ノードへスロットル変更伝播             {nodes: {...}}
requests_per_second
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| reindex_rethrottle.json | `rest-api-spec/src/main/resources/rest-api-spec/api/reindex_rethrottle.json` | API定義 | REST API仕様 |
| RestRethrottleAction.java | `modules/reindex/src/main/java/org/opensearch/index/reindex/RestRethrottleAction.java` | ソース | RESTハンドラ（3API共通） |
| RethrottleRequest.java | `server/src/main/java/org/opensearch/index/reindex/RethrottleRequest.java` | ソース | リクエストデータ構造 |
| RethrottleAction.java | `server/src/main/java/org/opensearch/index/reindex/RethrottleAction.java` | ソース | アクション定義 |
