# 画面設計書 2-Ping

## 概要

OpenSearchクラスタが稼働中かどうかを確認するREST APIエンドポイント（HEAD /）の設計書である。レスポンスボディを返さず、HTTPステータスコードのみでクラスタの生死を判定する。

### 本画面の処理概要

本APIは、OpenSearchクラスタに対してHEADリクエストを送信することで、クラスタが稼働しているかどうかを確認する機能を提供する。

**業務上の目的・背景**：運用監視やロードバランサのヘルスチェック、クライアントアプリケーションからの接続確認など、最小限のオーバーヘッドでクラスタの稼働状態を確認する必要がある。HEADリクエストはレスポンスボディを返さないため、GETリクエスト（クラスタ情報API）よりも軽量なヘルスチェックが可能である。

**画面へのアクセス方法**：HTTPクライアントからOpenSearchクラスタのルートURL（`HEAD /`）にリクエストを送信する。

**主要な操作・処理内容**：
1. クライアントからHEADリクエストを受信する
2. MainActionを実行し、クラスタの稼働状態を確認する
3. HTTPステータス200（OK）のみを返却する（レスポンスボディなし）

**画面遷移**：本APIは独立したエンドポイントであり、他のAPIへの直接的な遷移はない。ヘルスチェックとして使用される。

**権限による表示制御**：特別な権限制御は適用されない。クラスタに接続可能な全てのクライアントがアクセスできる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 48 | クラスタ状態管理 | 主機能 | クラスタが稼働中かどうかを確認するヘルスチェック処理 |

## 画面種別

ヘルスチェック（参照系API）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| HEAD | `/` | クラスタが稼働中かを確認する |

## 入出力項目

### リクエストパラメータ

本APIにはリクエストパラメータは存在しない。

### レスポンス

レスポンスボディは返却されない。HTTPステータスコードのみで結果を伝える。

| HTTPステータス | 意味 |
|--------------|------|
| 200 OK | クラスタが稼働中 |

## 表示項目

レスポンスボディなし。HTTPヘッダのみが返却される。

## イベント仕様

### 1-HEADリクエスト受信

1. クライアントからHEAD `/` リクエストを受信する
2. `RestMainAction.prepareRequest()` がリクエストを処理する（GET `/` と同じハンドラ）
3. `MainAction.INSTANCE` を実行し、`MainRequest` を送信する
4. `MainResponse` を受け取るが、HEADリクエストのためレスポンスボディは破棄される
5. HTTPステータス200（OK）のみを返却する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| HEAD / | なし | なし | データの読み書きは行わない |

### テーブル別更新項目詳細

本APIはデータベース（インデックス）の更新を行わない。

## メッセージ仕様

| メッセージ種別 | HTTPステータス | 条件 | メッセージ内容 |
|--------------|--------------|------|-------------|
| 成功 | 200 OK | クラスタが稼働中の場合 | レスポンスボディなし |

## 例外処理

| 例外 | HTTPステータス | 条件 | レスポンス |
|------|--------------|------|----------|
| 接続エラー | N/A | クラスタに接続できない場合 | 接続タイムアウトまたは接続拒否 |

## 備考

- Ping APIはRestMainActionによって処理される。GET `/` とHEAD `/` は同一のハンドラで処理されるが、HEADリクエストの場合はHTTPプロトコルの仕様に従いレスポンスボディが省略される。
- サーキットブレーカーをトリップさせない（`canTripCircuitBreaker()` が `false`）ため、高負荷時でもヘルスチェックが可能。
- REST API仕様定義上は `ping.json` として独立したAPI定義が存在するが、実装上はRestMainActionが両方を処理する。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Ping APIはレスポンスボディを返さないが、内部的にはクラスタ情報APIと同じデータ構造を使用する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MainRequest.java | `server/src/main/java/org/opensearch/action/main/MainRequest.java` | リクエストオブジェクトの構造（パラメータなし） |
| 1-2 | MainResponse.java | `server/src/main/java/org/opensearch/action/main/MainResponse.java` | レスポンスオブジェクト（HEADの場合はボディが破棄される） |

**読解のコツ**: Ping APIはクラスタ情報APIと内部処理は同一であり、HTTPメソッドの違い（HEAD vs GET）のみがレスポンスの形式に影響する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestMainAction.java | `server/src/main/java/org/opensearch/rest/action/RestMainAction.java` | 63行目でHEAD `/` のルーティングが定義されていることを確認する |

**主要処理フロー**:
1. **63行目**: `routes()` で `new Route(HEAD, "/")` が登録されている
2. **72行目**: `prepareRequest()` でGETと同じ処理が実行される
3. HTTPレイヤーでHEADリクエストのレスポンスボディが自動的に破棄される

#### Step 3: API仕様定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ping.json | `rest-api-spec/src/main/resources/rest-api-spec/api/ping.json` | API仕様として独立した定義が存在することを確認する |

### プログラム呼び出し階層図

```
RestMainAction.prepareRequest()  [HEAD /]
    |
    +-- client.execute(MainAction.INSTANCE, MainRequest)
            |
            +-- TransportMainAction.doExecute()
                    |
                    +-- MainResponse を構築
                            |
                            +-- RestMainAction.convertMainResponse()
                                    |
                                    +-- BytesRestResponse(OK, builder)
                                            |
                                            +-- [HTTP層でボディ破棄]
                                            +-- HTTP 200 ヘッダのみ返却
```

### データフロー図

```
[入力]               [処理]                    [出力]

HEAD / ------->  RestMainAction           -------> HTTP 200
                    |                              (ボディなし)
                    v
              TransportMainAction
                    |
                    v
              ClusterService
              (稼働確認)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestMainAction.java | `server/src/main/java/org/opensearch/rest/action/RestMainAction.java` | ソース | RESTハンドラ（GET/HEAD両方を処理） |
| MainAction.java | `server/src/main/java/org/opensearch/action/main/MainAction.java` | ソース | アクション定義 |
| MainRequest.java | `server/src/main/java/org/opensearch/action/main/MainRequest.java` | ソース | リクエストオブジェクト |
| MainResponse.java | `server/src/main/java/org/opensearch/action/main/MainResponse.java` | ソース | レスポンスオブジェクト |
| TransportMainAction.java | `server/src/main/java/org/opensearch/action/main/TransportMainAction.java` | ソース | トランスポートアクション実装 |
| ping.json | `rest-api-spec/src/main/resources/rest-api-spec/api/ping.json` | 設定 | REST API仕様定義 |
